/*
 * Decompiled with CFR 0.152.
 */
package techguns.worldgen.structures;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemDoor;
import net.minecraft.world.World;
import team.chisel.init.ChiselBlocks;
import techguns.TGBlocks;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.worldgen.structures.Structure;

public class SmallHouse
extends Structure {
    MBlock b_floor = new MBlock(TGBlocks.concrete, 5);
    MBlock b_wall = new MBlock(Blocks.field_150336_V, 0);
    MBlock b_scaffold = new MBlock(Blocks.field_150417_aV, 0);
    MBlock b_window = new MBlock((Block)ChiselBlocks.glass_pane, 2);
    MBlock b_roofSlab = new MBlock((Block)Blocks.field_150333_U, 0);
    MBlock b_roof = new MBlock((Block)Blocks.field_150334_T, 0);
    MBlock b_torch = new MBlock(TGBlocks.lamp01, 0);

    public SmallHouse(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        super(minX, 5, minZ, maxX, 5, maxZ);
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, BlockUtils.BiomeColorType colorType) {
        int dz;
        int dx;
        int zoffset;
        int xoffset;
        sizeX -= (sizeX - 1) % 4;
        sizeZ -= (sizeZ - 1) % 4;
        sizeY = 7;
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                for (int y = 0; y < sizeY; ++y) {
                    if (y == 0) {
                        if (x == 0 || z == 0 || x == sizeX - 1 || z == sizeZ - 1) {
                            world.func_147465_d(posX + x, posY + y, posZ + z, this.b_scaffold.block, this.b_scaffold.meta, 2);
                            continue;
                        }
                        world.func_147465_d(posX + x, posY + y, posZ + z, this.b_floor.block, this.b_floor.meta, 2);
                        continue;
                    }
                    if (y <= 3) {
                        if (x != 0 && z != 0 && x != sizeX - 1 && z != sizeZ - 1) continue;
                        if (x % 4 == 0 && z % 4 == 0) {
                            world.func_147465_d(posX + x, posY + y, posZ + z, this.b_scaffold.block, this.b_scaffold.meta, 2);
                            continue;
                        }
                        if (y == 2 && (x % 4 == 2 || z % 4 == 2)) {
                            world.func_147465_d(posX + x, posY + y, posZ + z, this.b_window.block, this.b_window.meta, 2);
                            continue;
                        }
                        world.func_147465_d(posX + x, posY + y, posZ + z, this.b_wall.block, this.b_wall.meta, 2);
                        continue;
                    }
                    if (y == 4) {
                        if (x != 0 && z != 0 && x != sizeX - 1 && z != sizeZ - 1) continue;
                        world.func_147465_d(posX + x, posY + y, posZ + z, this.b_scaffold.block, this.b_scaffold.meta, 2);
                        continue;
                    }
                    if (y != 5) continue;
                    if (x == 0 || z == 0 || x == sizeX - 1 || z == sizeZ - 1) {
                        world.func_147465_d(posX + x, posY + y, posZ + z, this.b_roofSlab.block, this.b_roofSlab.meta, 2);
                        continue;
                    }
                    world.func_147465_d(posX + x, posY + y, posZ + z, this.b_roof.block, this.b_roof.meta, 2);
                }
            }
        }
        switch (direction) {
            case 0: {
                xoffset = 0;
                zoffset = sizeZ / 8 * 4 + 2;
                dx = -1;
                dz = 0;
                break;
            }
            case 1: {
                xoffset = sizeX / 8 * 4 + 2;
                zoffset = 0;
                dx = 0;
                dz = -1;
                break;
            }
            case 2: {
                xoffset = sizeX - 1;
                zoffset = sizeZ / 8 * 4 + 2;
                dx = 1;
                dz = 0;
                break;
            }
            default: {
                xoffset = sizeX / 8 * 4 + 2;
                zoffset = sizeZ - 1;
                dx = 0;
                dz = 1;
            }
        }
        world.func_147449_b(posX + xoffset, posY + 2, posZ + zoffset, Blocks.field_150350_a);
        world.func_147449_b(posX + xoffset, posY + 1, posZ + zoffset, Blocks.field_150350_a);
        ItemDoor.func_150924_a((World)world, (int)(posX + xoffset), (int)(posY + 1), (int)(posZ + zoffset), (int)BlockUtils.getBlockDirMeta(BlockUtils.BlockType.DOOR, direction), (Block)Blocks.field_150466_ao);
        world.func_147465_d(posX + xoffset + dx, posY + 3, posZ + zoffset + dz, this.b_torch.block, 7, 2);
        this.destroyTop(world, sizeX, sizeY, posY + 5, 3, posX, posZ);
    }

    public void destroyTop(World w, int sizeX, int sizeZ, int maxy, int miny, int posX, int posZ) {
        Random rnd = new Random();
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                if (!rnd.nextBoolean()) continue;
                int yroll = rnd.nextInt(miny);
                for (int i = maxy; i >= maxy - yroll; --i) {
                    w.func_147468_f(posX + x, i, posZ + z);
                }
            }
        }
    }
}

