/*
 * Decompiled with CFR 0.152.
 */
package techguns.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import techguns.TGConfig;
import techguns.util.BlockUtils;
import techguns.worldgen.AlienBugNest;
import techguns.worldgen.MilitaryCamp;
import techguns.worldgen.structures.FactoryHouseSmall;
import techguns.worldgen.structures.HouseMedium;
import techguns.worldgen.structures.SmallTrainstation;
import techguns.worldgen.structures.Structure;

public class WorldGenTGStructureSpawn
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
            }
            case 0: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16, 0, 0, false);
            }
            case 1: {
                this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateEnd(World world, Random random, int i, int j) {
    }

    private void generateNether(World world, Random random, int i, int j) {
    }

    private void generateSurface(World world, Random random, int x, int z, int sizeX, int sizeZ, boolean rndcheck) {
        int SPAWNWEIGHT_SMALL = TGConfig.spawnWeightTGStructureSmall;
        int SPAWNWEIGHT_BIG = TGConfig.spawnWeightTGStructureBig;
        int cx = x / 16;
        int cz = z / 16;
        if (cx % SPAWNWEIGHT_BIG == 0 && cz % SPAWNWEIGHT_BIG == 0) {
            if (rndcheck || (double)random.nextFloat() < 0.5) {
                int y;
                if (sizeX <= 0) {
                    sizeX = 32 + random.nextInt(48);
                }
                if (sizeZ <= 0) {
                    sizeZ = 32 + random.nextInt(48);
                }
                if ((y = BlockUtils.getValidSpawnY(world, x, z, sizeX, sizeZ, 5)) > 0) {
                    BlockUtils.removeJunkInArea(world, x - 1, z - 1, sizeX + 2, sizeZ + 2);
                    MilitaryCamp camp = new MilitaryCamp(4, random);
                    camp.init(x, y, z, sizeX, sizeZ);
                    camp.setBlocks(world);
                } else if (sizeX >= 32 && sizeZ >= 32) {
                    this.generateSurface(world, random, x, z, sizeX - 16, sizeZ - 16, true);
                }
            }
        } else if (cx % SPAWNWEIGHT_SMALL == 0 && cz % SPAWNWEIGHT_SMALL == 0 && (rndcheck || (double)random.nextFloat() < 0.5)) {
            int y;
            if (sizeX <= 0) {
                sizeX = 12;
            }
            if (sizeZ <= 0) {
                sizeZ = 12;
            }
            if ((y = BlockUtils.getValidSpawnY(world, x, z, sizeX, sizeZ, 4)) > 0) {
                BlockUtils.removeJunkInArea(world, x - 1, z - 1, sizeX + 2, sizeZ + 2);
                boolean spawned = false;
                BiomeGenBase biome = world.func_72959_q().func_76935_a(x, z);
                if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) && random.nextDouble() > 0.5) {
                    AlienBugNest s = new AlienBugNest(x, y, z, 16 + random.nextInt(16), 0, 16 + random.nextInt(16), random);
                    s.setBlocks(world);
                    spawned = true;
                }
                if (!spawned) {
                    int type = random.nextInt(6);
                    switch (type) {
                        case 0: 
                        case 1: {
                            FactoryHouseSmall s = new FactoryHouseSmall(8, 0, 7, 9, 5, 10);
                            ((Structure)s).setBlocks(world, x, y - 1, z, sizeX, 8, sizeZ, random.nextInt(4), BlockUtils.BiomeColorType.WOODLAND);
                            break;
                        }
                        case 2: {
                            HouseMedium h = new HouseMedium(16, 12, 16, 16, 12, 16);
                            ((Structure)h).setBlocks(world, x, y - 1, z, 16, 12, 16, random.nextInt(4), BlockUtils.BiomeColorType.WOODLAND);
                            break;
                        }
                        case 3: 
                        case 4: {
                            SmallTrainstation t = new SmallTrainstation(0, 0, 0, 0, 0, 0);
                            ((Structure)t).setBlocks(world, x, y - 1, z, sizeX, 7, sizeZ, random.nextInt(4), BlockUtils.BiomeColorType.WOODLAND);
                            break;
                        }
                    }
                }
            }
        }
    }
}

