/*
 * Decompiled with CFR 0.152.
 */
package techguns.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import techguns.entities.npc.AlienBug;
import techguns.entities.npc.ArmySoldier;
import techguns.entities.npc.Bandit;
import techguns.entities.npc.CyberDemon;
import techguns.entities.npc.DictatorDave;
import techguns.entities.npc.GenericNPC;
import techguns.entities.npc.PsychoSteve;
import techguns.entities.npc.SkeletonSoldier;
import techguns.entities.npc.ZombieFarmer;
import techguns.entities.npc.ZombieMiner;
import techguns.entities.npc.ZombiePigmanSoldier;
import techguns.entities.npc.ZombieSoldier;

public class EntityDeathUtils {
    public static HashMap<DeathType, List<Class<? extends EntityLivingBase>>> entityDeathTypes = new HashMap();

    public static boolean hasSpecialDeathAnim(EntityLivingBase entityLiving, DeathType deathtype) {
        if (entityLiving instanceof IBossDisplayData) {
            return entityLiving instanceof GenericNPC;
        }
        if (deathtype == DeathType.BIO || deathtype == DeathType.LASER) {
            return true;
        }
        return entityDeathTypes.get((Object)DeathType.GORE).contains(entityLiving.getClass());
    }

    static {
        ArrayList<Class> listGore = new ArrayList<Class>();
        listGore.add(EntityPlayer.class);
        listGore.add(EntityZombie.class);
        listGore.add(EntitySkeleton.class);
        listGore.add(EntityEnderman.class);
        listGore.add(EntityCreeper.class);
        listGore.add(EntityCow.class);
        listGore.add(EntitySheep.class);
        listGore.add(EntityPig.class);
        listGore.add(EntityChicken.class);
        listGore.add(EntityPigZombie.class);
        listGore.add(ZombieSoldier.class);
        listGore.add(ArmySoldier.class);
        listGore.add(CyberDemon.class);
        listGore.add(ZombiePigmanSoldier.class);
        listGore.add(EntitySpider.class);
        listGore.add(EntityCaveSpider.class);
        listGore.add(EntityWitch.class);
        listGore.add(EntitySlime.class);
        listGore.add(ZombieFarmer.class);
        listGore.add(ZombieMiner.class);
        listGore.add(Bandit.class);
        listGore.add(ZombieSoldier.class);
        listGore.add(EntityHorse.class);
        listGore.add(EntityMooshroom.class);
        listGore.add(EntityWolf.class);
        listGore.add(EntitySquid.class);
        listGore.add(EntityGhast.class);
        listGore.add(EntityVillager.class);
        listGore.add(PsychoSteve.class);
        listGore.add(DictatorDave.class);
        listGore.add(SkeletonSoldier.class);
        listGore.add(AlienBug.class);
        entityDeathTypes.put(DeathType.GORE, listGore);
    }

    public static enum DeathType {
        DEFAULT(0),
        GORE(1),
        BIO(2),
        LASER(3),
        DISMEMBER(4);

        int value;

        private DeathType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

