/*
 * Decompiled with CFR 0.152.
 */
package techguns.util;

import java.util.ArrayList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import techguns.util.MathUtil;

public class BlockCoords {
    public int x;
    public int y;
    public int z;

    public BlockCoords(BlockCoords coords) {
        this.x = coords.x;
        this.y = coords.y;
        this.z = coords.z;
    }

    public BlockCoords(TileEntity tile) {
        this.x = tile.field_145851_c;
        this.y = tile.field_145848_d;
        this.z = tile.field_145849_e;
    }

    public BlockCoords(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public void shift(ForgeDirection dir, int amount) {
        switch (dir) {
            case DOWN: {
                this.y -= amount;
                break;
            }
            case UP: {
                this.y += amount;
                break;
            }
            case NORTH: {
                this.z -= amount;
                break;
            }
            case SOUTH: {
                this.z += amount;
                break;
            }
            case EAST: {
                this.x += amount;
                break;
            }
            case WEST: {
                this.x -= amount;
                break;
            }
            case UNKNOWN: {
                break;
            }
        }
    }

    public ArrayList<BlockCoords> getBoxWithOffsets(int minX, int maxX, int minY, int maxY, int minZ, int maxZ, boolean addOrigin) {
        ArrayList<BlockCoords> box = new ArrayList<BlockCoords>();
        for (int x = this.x + minX; x <= this.x + maxX; ++x) {
            for (int y = this.y + minY; y <= this.y + maxY; ++y) {
                for (int z = this.z + minZ; z <= this.z + maxZ; ++z) {
                    BlockCoords pos = new BlockCoords(x, y, z);
                    if (!addOrigin && pos.equals(this)) continue;
                    box.add(pos);
                }
            }
        }
        return box;
    }

    public ArrayList<BlockCoords> getCuboid(ForgeDirection direction, int radius, int length, boolean round) {
        ArrayList<BlockCoords> cuboid;
        block10: {
            block11: {
                block9: {
                    cuboid = new ArrayList<BlockCoords>();
                    if (direction != ForgeDirection.UP && direction != ForgeDirection.DOWN) break block9;
                    int dir = direction == ForgeDirection.UP ? 1 : -1;
                    for (int y = 0; y < length; ++y) {
                        for (int x = -radius; x <= radius; ++x) {
                            for (int z = -radius; z <= radius; ++z) {
                                if (round && MathUtil.abs(x) == radius && MathUtil.abs(z) == radius) continue;
                                BlockCoords pos = new BlockCoords(this.x + x, this.y + y * dir, this.z + z);
                                cuboid.add(pos);
                            }
                        }
                    }
                    break block10;
                }
                if (direction != ForgeDirection.NORTH && direction != ForgeDirection.SOUTH) break block11;
                int dir = direction == ForgeDirection.SOUTH ? 1 : -1;
                for (int z = 0; z < length; ++z) {
                    for (int x = -radius; x <= radius; ++x) {
                        for (int y = -radius; y <= radius; ++y) {
                            if (round && MathUtil.abs(x) == radius && MathUtil.abs(y) == radius) continue;
                            BlockCoords pos = new BlockCoords(this.x + x, this.y + y, this.z + z * dir);
                            cuboid.add(pos);
                        }
                    }
                }
                break block10;
            }
            if (direction != ForgeDirection.EAST && direction != ForgeDirection.WEST) break block10;
            int dir = direction == ForgeDirection.EAST ? 1 : -1;
            for (int x = 0; x < length; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    for (int y = -radius; y <= radius; ++y) {
                        if (round && MathUtil.abs(z) == radius && MathUtil.abs(y) == radius) continue;
                        BlockCoords pos = new BlockCoords(this.x + x * dir, this.y + y, this.z + z);
                        cuboid.add(pos);
                    }
                }
            }
        }
        return cuboid;
    }

    public BlockCoords getShifted(ForgeDirection dir, int amount) {
        BlockCoords newPos = new BlockCoords(this.x, this.y, this.z);
        newPos.shift(dir, amount);
        return newPos;
    }

    public String toString() {
        return "BlockCoords:(" + this.x + "," + this.y + "," + this.z + ")";
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof BlockCoords) {
            BlockCoords other = (BlockCoords)obj;
            return this.x == other.x && this.y == other.y && this.z == other.z;
        }
        return false;
    }
}

