/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import techguns.TGItems;
import techguns.inventory.MetalPressRecipes;
import techguns.tileentities.BasicMachineTileEntity;

public class MetalPressTileEnt
extends BasicMachineTileEntity {
    int minSoundDelay = 0;
    byte autoSlitMode = 0;

    public MetalPressTileEnt() {
        super(4, 20000);
    }

    @Override
    public void readEntityDataFromNBT(NBTTagCompound tags) {
        super.readEntityDataFromNBT(tags);
        this.autoSlitMode = tags.func_74771_c("autoSplitMode");
    }

    @Override
    public void writeEntityDataToNBT(NBTTagCompound tags) {
        super.writeEntityDataToNBT(tags);
        tags.func_74774_a("autoSplitMode", this.autoSlitMode);
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2};
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return this.func_94041_b(slot, item);
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return slot == 2;
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        if (this.content[slot] != null && OreDictionary.itemMatches((ItemStack)this.content[slot], (ItemStack)item, (boolean)true) && this.content[slot].field_77994_a + item.field_77994_a <= item.func_77976_d()) {
            return true;
        }
        if (this.content[0] == null && slot == 0 && MetalPressRecipes.hasRecipeUsing(item)) {
            return true;
        }
        return this.content[0] != null && slot == 1 && this.content[1] == null && MetalPressRecipes.getOutputFor(this.content[0], item) != null;
    }

    public int getValidSlotForItemInMachine(ItemStack item) {
        if (this.content[0] != null && OreDictionary.itemMatches((ItemStack)this.content[0], (ItemStack)item, (boolean)true)) {
            return 0;
        }
        if (this.content[1] != null && OreDictionary.itemMatches((ItemStack)this.content[1], (ItemStack)item, (boolean)true)) {
            return 1;
        }
        if (this.content[0] == null && MetalPressRecipes.hasRecipeUsing(item)) {
            return 0;
        }
        if (this.content[0] != null && this.content[1] == null && MetalPressRecipes.getOutputFor(this.content[0], item) != null) {
            return 1;
        }
        if (item != null && item.func_77973_b() == TGItems.machineStackUpgrade.func_77973_b() && item.func_77960_j() == TGItems.machineStackUpgrade.func_77960_j()) {
            return 3;
        }
        return -1;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.isRedstoneEnabled()) {
            if (this.currentOperation != null) {
                if (this.consumePower(20 * this.stackmultiplier)) {
                    ++this.progress;
                    this.playAmbientSound();
                    if (this.progress >= this.totalTime) {
                        if (!this.field_145850_b.field_72995_K) {
                            if (this.content[2] == null) {
                                this.content[2] = new ItemStack(this.currentOperation.func_77973_b(), this.currentOperation.field_77994_a * this.stackmultiplier, this.currentOperation.func_77960_j());
                            } else {
                                this.content[2].field_77994_a += this.currentOperation.field_77994_a * this.stackmultiplier;
                            }
                        }
                        this.progress = 0;
                        this.totalTime = 0;
                        this.currentOperation = null;
                        this.stackmultiplier = 1;
                        this.checkAndStartOperation();
                        if (!this.field_145850_b.field_72995_K) {
                            this.needUpdate();
                        }
                    }
                }
            } else if (this.content[0] != null || this.content[1] != null) {
                if (this.autoSlitMode > 0 && (this.content[0] == null || this.content[1] == null)) {
                    ItemStack output;
                    if (this.content[1] == null && this.content[0].field_77994_a > 1) {
                        ItemStack output2 = MetalPressRecipes.getOutputFor(this.content[0], this.content[0]);
                        if (output2 != null) {
                            int split1 = this.content[0].field_77994_a / 2 + this.content[0].field_77994_a % 2;
                            int split2 = this.content[0].field_77994_a / 2;
                            this.content[1] = new ItemStack(this.content[0].func_77973_b(), split2, this.content[0].func_77960_j());
                            this.content[0].field_77994_a = split1;
                        }
                    } else if (this.content[0] == null && this.content[1].field_77994_a > 1 && (output = MetalPressRecipes.getOutputFor(this.content[1], this.content[1])) != null) {
                        int split1 = this.content[1].field_77994_a / 2 + this.content[1].field_77994_a % 2;
                        int split2 = this.content[1].field_77994_a / 2;
                        this.content[0] = new ItemStack(this.content[1].func_77973_b(), split2, this.content[1].func_77960_j());
                        this.content[1].field_77994_a = split1;
                    }
                    this.checkAndStartOperation();
                } else if (this.autoSlitMode > 0 && this.content[0] != null && this.content[1] != null) {
                    if (this.content[0].func_77973_b() == this.content[1].func_77973_b() && this.content[0].func_77960_j() == this.content[1].func_77960_j() && Math.abs(this.content[1].field_77994_a - this.content[0].field_77994_a) > 1) {
                        int total = this.content[0].field_77994_a + this.content[1].field_77994_a;
                        int split1 = total / 2 + total % 2;
                        int split2 = total / 2;
                        this.content[0].field_77994_a = split1;
                        this.content[1].field_77994_a = split2;
                    }
                    this.checkAndStartOperation();
                } else {
                    this.checkAndStartOperation();
                }
            }
        }
    }

    public void checkAndStartOperation() {
        ItemStack output = MetalPressRecipes.getOutputFor(this.content[0], this.content[1]);
        if (output != null && this.canOutput(output, 2)) {
            ItemStack outputStack = TGItems.newStack(output, output.field_77994_a);
            int maxStack = 1;
            if (this.content[3] != null && this.content[3].func_77973_b() == TGItems.machineStackUpgrade.func_77973_b() && this.content[3].func_77960_j() == TGItems.machineStackUpgrade.func_77960_j()) {
                maxStack = this.content[3].field_77994_a + 1;
            }
            int originalStacksize = output.field_77994_a;
            for (int i = maxStack; i > 1; --i) {
                outputStack.field_77994_a = output.field_77994_a * i;
                if (!this.canOutput(outputStack, 2) || this.content[0].field_77994_a < i || this.content[1].field_77994_a < i) continue;
                output = outputStack;
                this.stackmultiplier = i;
                break;
            }
            this.content[0].field_77994_a -= this.stackmultiplier;
            if (this.content[0].field_77994_a <= 0) {
                this.content[0] = null;
            }
            this.content[1].field_77994_a -= this.stackmultiplier;
            if (this.content[1].field_77994_a <= 0) {
                this.content[1] = null;
            }
            this.progress = 0;
            this.totalTime = 100;
            this.currentOperation = new ItemStack(output.func_77973_b(), originalStacksize, output.func_77960_j());
            if (!this.field_145850_b.field_72995_K) {
                this.needUpdate();
            }
        }
    }

    private void playAmbientSound() {
        int soundTick1 = Math.round((float)this.totalTime * 0.075f);
        int halfTime = Math.round((float)this.totalTime * 0.5f);
        if (this.progress == soundTick1 || this.progress == soundTick1 + halfTime) {
            this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "techguns:machines.metalpressWork", 1.0f, 1.0f, true);
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.name : "techguns.container.metalpress";
    }

    public byte getAutoSplitMode() {
        return this.autoSlitMode;
    }

    public void setAutoSplitMode(byte mode) {
        this.autoSlitMode = mode;
    }

    @Override
    public void buttonClicked(int id, EntityPlayer ply) {
        if (id <= 2) {
            super.buttonClicked(id, ply);
        } else if (id == 3 && this.func_70300_a(ply)) {
            this.changeAutoSplitMode();
        }
    }

    public void changeAutoSplitMode() {
        this.autoSlitMode = this.autoSlitMode == 0 ? (byte)1 : 0;
    }
}

