/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import techguns.TGConfig;
import techguns.entities.npc.TGNpcFactions;
import techguns.tileentities.BasicInventoryTileEnt;

public abstract class BasicPoweredTileEnt
extends BasicInventoryTileEnt
implements IEnergyReceiver {
    public static final int MAX_BUTTON_USED = 2;
    protected EnergyStorage energy;
    protected byte redstoneBehaviour = 0;
    protected UUID owner;
    protected boolean hasSignal = false;

    public void setOwner(EntityPlayer ply) {
        UUID id = ply.func_146103_bH().getId();
        if (id != null) {
            this.owner = id;
            this.security = 0;
        }
    }

    public boolean isOwnedByPlayer(EntityPlayer ply) {
        if (this.owner == null) {
            return false;
        }
        return this.owner.equals(ply.func_146103_bH().getId());
    }

    public UUID getOwner() {
        return this.owner;
    }

    public byte getSecurity() {
        return this.security;
    }

    public BasicPoweredTileEnt(int slots, int MaximumPower) {
        super(slots);
        this.energy = new EnergyStorage(MaximumPower);
    }

    public void onNeighborBlockChange() {
        boolean signal;
        if (!this.field_145850_b.field_72995_K && (signal = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) != this.hasSignal) {
            this.hasSignal = signal;
            this.needUpdate();
        }
    }

    public boolean isRedstoneEnabled() {
        return this.redstoneBehaviour == 0 || this.hasSignal && this.redstoneBehaviour == 1 || !this.hasSignal && this.redstoneBehaviour == 2;
    }

    @Override
    public void readEntityDataFromNBT(NBTTagCompound tags) {
        super.readEntityDataFromNBT(tags);
        NBTTagCompound tagEnergy = tags.func_74775_l("Energy");
        this.energy.readFromNBT(tagEnergy);
        this.hasSignal = tags.func_74767_n("hasSignal");
        this.redstoneBehaviour = tags.func_74771_c("redstoneBehaviour");
        this.security = tags.func_74771_c("security");
        String own = tags.func_74779_i("owner");
        if (own != null && !own.equals("")) {
            try {
                this.owner = UUID.fromString(own);
            }
            catch (IllegalArgumentException e) {
                this.owner = null;
                System.out.println("Error Parsing Owner, machine is not owned anymore.");
            }
        }
    }

    @Override
    public void writeEntityDataToNBT(NBTTagCompound tags) {
        super.writeEntityDataToNBT(tags);
        NBTTagCompound tagEnergy = new NBTTagCompound();
        this.energy.writeToNBT(tagEnergy);
        tags.func_74782_a("Energy", (NBTBase)tagEnergy);
        tags.func_74757_a("hasSignal", this.hasSignal);
        tags.func_74774_a("redstoneBehaviour", this.redstoneBehaviour);
        if (this.owner != null) {
            tags.func_74774_a("security", this.security);
            tags.func_74778_a("owner", this.owner.toString());
        }
    }

    public int getPowerStored() {
        return this.energy.getEnergyStored();
    }

    public void setPowerStored(int pwr) {
        this.energy.setEnergyStored(pwr);
    }

    @SideOnly(value=Side.CLIENT)
    public String getRedstoneModeText() {
        switch (this.redstoneBehaviour) {
            case 0: {
                return "techguns.redstonemode.ignore";
            }
            case 1: {
                return "techguns.redstonemode.high";
            }
            case 2: {
                return "techguns.redstonemode.low";
            }
        }
        return "invalid";
    }

    @SideOnly(value=Side.CLIENT)
    public String getSignalStateText() {
        if (this.hasSignal) {
            return "techguns.redstonemode.signal.high";
        }
        return "techguns.redstonemode.signal.low";
    }

    @SideOnly(value=Side.CLIENT)
    public int getPowerMax() {
        return this.energy.getMaxEnergyStored();
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.energy.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energy.getMaxEnergyStored();
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energy.receiveEnergy(maxReceive, simulate);
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    protected boolean consumePower(int amount) {
        if (TGConfig.machinesNeedNoPower) {
            return true;
        }
        if (this.energy.getEnergyStored() >= amount) {
            this.energy.modifyEnergyStored(-amount);
            return true;
        }
        return false;
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        if (super.func_70300_a(player)) {
            if (this.owner == null || this.security == 0) {
                return true;
            }
            if (this.isOwnedByPlayer(player)) {
                return true;
            }
            if (this.security == 1) {
                return !TGNpcFactions.isHostile(this.owner, player.func_146103_bH().getId());
            }
        }
        return false;
    }

    @Override
    public void buttonClicked(int id, EntityPlayer ply) {
        if (id == 2 && this.func_70300_a(ply)) {
            this.redstoneBehaviour = (byte)(this.redstoneBehaviour + 1);
            this.redstoneBehaviour = (byte)(this.redstoneBehaviour % 3);
            if (!this.field_145850_b.field_72995_K) {
                this.needUpdate();
            }
        } else if (id == 1 && this.isOwnedByPlayer(ply)) {
            this.security = (byte)(this.security + 1);
            this.security = (byte)(this.security % 3);
            if (!this.field_145850_b.field_72995_K) {
                this.needUpdate();
            }
        }
    }

    public byte getRedstoneBehaviour() {
        return this.redstoneBehaviour;
    }
}

