/*
 * Decompiled with CFR 0.152.
 */
package techguns.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import techguns.TGConfig;
import techguns.TGPackets;
import techguns.Techguns;
import techguns.client.ClientProxy;
import techguns.client.DeathEffect;
import techguns.client.audio.TGSoundCategory;
import techguns.util.EntityDeathUtils;

public class PacketEntityDeathType
implements IMessage {
    int entityId;
    int deathtypeId;
    float motionX;
    float motionY;
    float motionZ;

    public PacketEntityDeathType() {
    }

    public PacketEntityDeathType(EntityLivingBase entity, EntityDeathUtils.DeathType deathtype) {
        this.entityId = entity.func_145782_y();
        this.deathtypeId = deathtype != null ? deathtype.getValue() : EntityDeathUtils.DeathType.DEFAULT.getValue();
        this.motionX = (float)entity.field_70159_w;
        this.motionY = (float)entity.field_70181_x;
        this.motionZ = (float)entity.field_70179_y;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.deathtypeId = buf.readInt();
        this.motionX = buf.readFloat();
        this.motionY = buf.readFloat();
        this.motionZ = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.deathtypeId);
        buf.writeFloat(this.motionX);
        buf.writeFloat(this.motionY);
        buf.writeFloat(this.motionZ);
    }

    public static class Handler
    implements IMessageHandler<PacketEntityDeathType, IMessage> {
        public IMessage onMessage(PacketEntityDeathType message, MessageContext ctx) {
            if (TGConfig.cl_enableDeathFX) {
                EntityPlayer ply = TGPackets.getPlayerFromContext(ctx);
                EntityLivingBase entity = (EntityLivingBase)ply.field_70170_p.func_73045_a(message.entityId);
                EntityDeathUtils.DeathType deathtype = EntityDeathUtils.DeathType.values()[message.deathtypeId];
                if ((deathtype != EntityDeathUtils.DeathType.GORE || deathtype == EntityDeathUtils.DeathType.GORE && TGConfig.cl_enableDeathFX_Gore) && entity != null) {
                    entity.field_70159_w = message.motionX;
                    entity.field_70181_x = message.motionY;
                    entity.field_70179_y = message.motionZ;
                    ClientProxy.get().setEntityDeathType(entity, deathtype);
                    DeathEffect.createDeathEffect(entity, deathtype, message.motionX, message.motionY, message.motionZ);
                    switch (deathtype) {
                        case BIO: {
                            Techguns.proxy.playSoundOnEntity((Entity)entity, "techguns:effects.biodeath", 1.0f, 1.0f, false, false, false, TGSoundCategory.DEATHEFFECT);
                            break;
                        }
                        case DEFAULT: {
                            break;
                        }
                        case GORE: {
                            Techguns.proxy.playSoundOnEntity((Entity)entity, "techguns:effects.gore", 1.0f, 1.0f, false, false, false, TGSoundCategory.DEATHEFFECT);
                            break;
                        }
                        case LASER: {
                            Techguns.proxy.playSoundOnEntity((Entity)entity, "techguns:effects.disintegrate", 1.0f, 1.0f, false, false, false, TGSoundCategory.DEATHEFFECT);
                            break;
                        }
                    }
                }
            }
            return null;
        }
    }
}

