/*
 * Decompiled with CFR 0.152.
 */
package techguns.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.common.Optional;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import techguns.gui.GuiAmmoPress;
import techguns.gui.GuiChemLab;
import techguns.inventory.ChemLabRecipes;
import techguns.util.TextUtil;

@Optional.Interface(iface="codechicken.nei.api.API", modid="NotEnoughItems")
public class TechgunsChemLabNEIRecipeHandler
extends TemplateRecipeHandler {
    private static final String ID = "Techguns:ChemLab";
    public static final int ICON_OFFSET_X = -5;
    public static final int ICON_OFFSET_Y = -11;
    private ResourceLocation texture_gui_elemets = GuiAmmoPress.texture;

    public static String getIDString() {
        return ID;
    }

    @Optional.Method(modid="NotEnoughItems")
    public String getRecipeName() {
        return TextUtil.trans("techguns.container.chemlab");
    }

    @Optional.Method(modid="NotEnoughItems")
    public String getGuiTexture() {
        return GuiChemLab.texture.toString();
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiChemLab.class;
    }

    public boolean isInRect(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(75, 4, 53, 30), TechgunsChemLabNEIRecipeHandler.getIDString(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(ID)) {
            this.loadAllRecipes();
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadAllRecipes() {
        for (ChemLabRecipes.ChemLabRecipe recipe : ChemLabRecipes.getRecipes()) {
            if (recipe == null) continue;
            ArrayList<ItemStack> inputs1 = recipe.slot1.getItemStacks();
            TechgunsChemLabNEIRecipeHandler.setStackSizes(inputs1, recipe.amounts[0]);
            ArrayList<ItemStack> inputs2 = recipe.slot2.getItemStacks();
            TechgunsChemLabNEIRecipeHandler.setStackSizes(inputs2, recipe.amounts[1]);
            ArrayList<ItemStack> inputs3 = new ArrayList<ItemStack>();
            if (recipe.slot3 != null) {
                inputs3.add(recipe.slot3);
                TechgunsChemLabNEIRecipeHandler.setStackSizes(inputs3, recipe.amounts[2]);
            }
            this.arecipes.add(new CachedChemLabRecipe(new ChemLabRecipe(inputs1, inputs2, inputs3, recipe.output, recipe.fluidIn, recipe.fluidOutput, recipe.powerPerTick)));
        }
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        int mx = GuiDraw.getMousePosition().x - (gui.field_146294_l - 176) / 2 - gui.getRecipePosition((int)recipe).x;
        int my = GuiDraw.getMousePosition().y - (gui.field_146295_m - 166) / 2 - gui.getRecipePosition((int)recipe).y;
        CachedChemLabRecipe rec = (CachedChemLabRecipe)((Object)this.arecipes.get(recipe));
        ChemLabRecipe chemrecipe = rec.recipe;
        if (this.isInRect(mx, my, -5 + 18, -11 + 17, 12, 52)) {
            if (chemrecipe.fluidIn != null) {
                currenttip.add(TextUtil.trans(chemrecipe.fluidIn.getFluid().getUnlocalizedName()));
            } else {
                currenttip.add(TextUtil.trans("techguns.chemlab.nofluidin"));
            }
        }
        if (this.isInRect(mx, my, -5 + 157, -11 + 17, 12, 52)) {
            if (chemrecipe.fluidOut != null) {
                currenttip.add(TextUtil.trans(chemrecipe.fluidOut.getFluid().getUnlocalizedName()));
            } else {
                currenttip.add(TextUtil.trans("techguns.chemlab.nofluidout"));
            }
        }
        return super.handleTooltip(gui, currenttip, recipe);
    }

    public void loadCraftingRecipes(ItemStack result) {
        ChemLabRecipes.ChemLabRecipe recipe = ChemLabRecipes.getRecipesFor(result);
        if (recipe != null) {
            ArrayList<ItemStack> inputs1 = recipe.slot1.getItemStacks();
            TechgunsChemLabNEIRecipeHandler.setStackSizes(inputs1, recipe.amounts[0]);
            ArrayList<ItemStack> inputs2 = recipe.slot2.getItemStacks();
            TechgunsChemLabNEIRecipeHandler.setStackSizes(inputs2, recipe.amounts[1]);
            ArrayList<ItemStack> inputs3 = new ArrayList<ItemStack>();
            if (recipe.slot3 != null) {
                inputs3.add(recipe.slot3);
                TechgunsChemLabNEIRecipeHandler.setStackSizes(inputs3, recipe.amounts[2]);
            }
            this.arecipes.add(new CachedChemLabRecipe(new ChemLabRecipe(inputs1, inputs2, inputs3, recipe.output, recipe.fluidIn, recipe.fluidOutput, recipe.powerPerTick)));
        }
    }

    private static void setStackSizes(List<ItemStack> list, int amount) {
        for (int i = 0; i < list.size(); ++i) {
            list.get((int)i).field_77994_a = amount;
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (ChemLabRecipes.hasRecipeUsing(ingredient)) {
            ArrayList<ChemLabRecipes.ChemLabRecipe> recipes = ChemLabRecipes.getRecipesUsing(ingredient);
            for (ChemLabRecipes.ChemLabRecipe r : recipes) {
                ArrayList<ItemStack> slot1 = r.slot1.getItemStacks();
                TechgunsChemLabNEIRecipeHandler.setStackSizes(slot1, r.amounts[0]);
                ArrayList<ItemStack> slot2 = r.slot2.getItemStacks();
                TechgunsChemLabNEIRecipeHandler.setStackSizes(slot2, r.amounts[1]);
                ArrayList<ItemStack> slot3 = new ArrayList<ItemStack>();
                if (r.slot3 != null) {
                    slot3.add(r.slot3);
                    TechgunsChemLabNEIRecipeHandler.setStackSizes(slot3, r.amounts[2]);
                }
                this.arecipes.add(new CachedChemLabRecipe(new ChemLabRecipe(slot1, slot2, slot3, r.output, r.fluidIn, r.fluidOutput, r.powerPerTick)));
            }
        }
    }

    private void drawTexturedModalRect(int p_73729_1_, int p_73729_2_, int p_73729_3_, int p_73729_4_, int p_73729_5_, int p_73729_6_) {
        double zLevel = 0.0;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(p_73729_1_ + 0), (double)(p_73729_2_ + p_73729_6_), zLevel, (double)((float)(p_73729_3_ + 0) * f), (double)((float)(p_73729_4_ + p_73729_6_) * f1));
        tessellator.func_78374_a((double)(p_73729_1_ + p_73729_5_), (double)(p_73729_2_ + p_73729_6_), zLevel, (double)((float)(p_73729_3_ + p_73729_5_) * f), (double)((float)(p_73729_4_ + p_73729_6_) * f1));
        tessellator.func_78374_a((double)(p_73729_1_ + p_73729_5_), (double)(p_73729_2_ + 0), zLevel, (double)((float)(p_73729_3_ + p_73729_5_) * f), (double)((float)(p_73729_4_ + 0) * f1));
        tessellator.func_78374_a((double)(p_73729_1_ + 0), (double)(p_73729_2_ + 0), zLevel, (double)((float)(p_73729_3_ + 0) * f), (double)((float)(p_73729_4_ + 0) * f1));
        tessellator.func_78381_a();
    }

    public void drawExtras(int recipe) {
        int px;
        IIcon tex;
        int color = -1;
        int ticks = 100;
        float prog = (float)(this.cycleticks % ticks) / (float)ticks;
        int k = -5;
        int l = -11;
        int i1 = (int)((prog < 0.2f ? prog * 5.0f : 1.0f) * 25.0f);
        this.drawTexturedModalRect(k + 81, l + 19, 178, 5, 8, i1);
        if (prog >= 0.2f) {
            int i2 = (int)((prog < 0.4f ? (prog - 0.2f) * 5.0f : 1.0f) * 9.0f);
            this.drawTexturedModalRect(k + 88, l + 39, 186, 25, i2, 1);
        }
        if (prog >= 0.4f) {
            int i3 = (int)((prog < 0.6f ? (prog - 0.4f) * 5.0f : 1.0f) * 20.0f);
            this.drawTexturedModalRect(k + 97, l + 23 + (20 - i3), 194, 9 + (20 - i3), 14, i3);
        }
        if (prog >= 0.6f) {
            int i4 = (int)((prog < 0.8f ? (prog - 0.6f) * 5.0f : 1.0f) * 16.0f);
            this.drawTexturedModalRect(k + 108, l + 17, 205, 3, i4, 6);
        }
        if (prog >= 0.8f) {
            int i5 = (int)((prog - 0.8f) * 5.0f * 24.0f);
            this.drawTexturedModalRect(k + 117, l + 20, 214, 6, 14, i5 + 1);
        }
        CachedChemLabRecipe rec = (CachedChemLabRecipe)((Object)this.arecipes.get(recipe));
        ChemLabRecipe chemrecipe = rec.recipe;
        int power = chemrecipe.rftick;
        GuiDraw.gui.func_73732_a(GuiDraw.fontRenderer, power + " RF/t", 100, 39, color);
        if (chemrecipe.fluidIn != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            tex = chemrecipe.fluidIn.getFluid().getIcon();
            px = (int)((float)chemrecipe.fluidIn.amount * 50.0f / 2000.0f);
            TechgunsChemLabNEIRecipeHandler.drawFluidWithTesselator(tex, k + 19, l + 17, 10, 50, px);
            GuiDraw.fontRenderer.func_78261_a(chemrecipe.fluidIn.amount + " mB", 30, 49, color);
        }
        if (chemrecipe.fluidOut != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            tex = chemrecipe.fluidOut.getFluid().getIcon();
            px = (int)((float)chemrecipe.fluidOut.amount * 50.0f / 2000.0f);
            TechgunsChemLabNEIRecipeHandler.drawFluidWithTesselator(tex, k + 158, l + 17, 10, 50, px);
            GuiDraw.fontRenderer.func_78261_a(chemrecipe.fluidOut.amount + " mB", 115, 49, color);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiChemLab.texture);
        this.drawTexturedModalRect(k + 18, l + 17, 176, 32, 12, 52);
        this.drawTexturedModalRect(k + 157, l + 17, 176, 32, 12, 52);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture_gui_elemets);
        this.drawProgressBar(3, 6, 251, 1, 4, 48, 100, 7);
    }

    static void drawFluidWithTesselator(IIcon tex, int x, int y, int width, int height, int px) {
        int len = tex.func_94216_b();
        for (int offset = 0; offset < px; offset += tex.func_94216_b()) {
            if (offset + len > px) {
                len = px - offset;
            }
            TechgunsChemLabNEIRecipeHandler.drawTexturedModelRectFromIconFluidTank(x, y + height - offset - len, tex, width, len);
        }
    }

    private static void drawTexturedModelRectFromIconFluidTank(int x, int y, IIcon icon, int w, int h) {
        double zLevel = 0.0;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + h), zLevel, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)(x + w), (double)(y + h), zLevel, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)(x + w), (double)(y + 0), zLevel, (double)icon.func_94212_f(), (double)icon.func_94207_b((double)(icon.func_94216_b() - h)));
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), zLevel, (double)icon.func_94209_e(), (double)icon.func_94207_b((double)(icon.func_94216_b() - h)));
        tessellator.func_78381_a();
    }

    public class CachedChemLabRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ChemLabRecipe recipe;

        public CachedChemLabRecipe(ChemLabRecipe recipe) {
            super((TemplateRecipeHandler)TechgunsChemLabNEIRecipeHandler.this);
            this.recipe = recipe;
        }

        public PositionedStack getResult() {
            return this.recipe.output;
        }

        public ArrayList<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> recipestacks = new ArrayList<PositionedStack>();
            if (this.recipe.input1 != null) {
                recipestacks.add(this.recipe.input1);
            }
            if (this.recipe.input2 != null) {
                recipestacks.add(this.recipe.input2);
            }
            if (this.recipe.input3 != null) {
                recipestacks.add(this.recipe.input3);
            }
            return (ArrayList)this.getCycledIngredients(TechgunsChemLabNEIRecipeHandler.this.cycleticks / 24, recipestacks);
        }
    }

    public static class ChemLabRecipe {
        public PositionedStack input1;
        public PositionedStack input2;
        public PositionedStack input3;
        public PositionedStack output;
        public FluidStack fluidIn;
        public FluidStack fluidOut;
        public int rftick;

        public ChemLabRecipe(List<ItemStack> input1, List<ItemStack> input2, List<ItemStack> input3, ItemStack output, FluidStack fluidIn, FluidStack fluidOut, int rf) {
            this.input1 = input1.size() > 0 ? new PositionedStack(input1, 30, 6) : null;
            this.input2 = input2.size() > 0 ? new PositionedStack(input2, 52, 6) : null;
            this.input3 = input3.size() > 0 ? new PositionedStack(input3, 30, 29) : null;
            this.output = output != null ? new PositionedStack((Object)new ItemStack(output.func_77973_b(), output.field_77994_a, output.func_77960_j()), 130, 6) : null;
            this.rftick = rf;
            this.fluidIn = fluidIn != null ? new FluidStack(fluidIn, fluidIn.amount) : null;
            this.fluidOut = fluidOut != null ? new FluidStack(fluidOut, fluidOut.amount) : null;
        }
    }
}

