/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.guns;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import techguns.TGPackets;
import techguns.client.ClientProxy;
import techguns.client.audio.TGSoundCategory;
import techguns.damagesystem.DamageType;
import techguns.damagesystem.TGDamageSource;
import techguns.entities.projectiles.PowerHammerProjectile;
import techguns.extendedproperties.TechgunsExtendedPlayerProperties;
import techguns.items.guns.GenericGunCharge;
import techguns.packets.PacketPlaySound;
import techguns.util.EntityDeathUtils;
import techguns.util.MathUtil;

public class PowerHammer
extends GenericGunCharge {
    final float collisionSize = 4.0f;
    float meleeDamagePwr = 6.0f;
    float meleeDamageEmpty = 2.0f;
    static final float POWERHAMMER_SOUNDDISTANCE = 1.0f;

    public PowerHammer(String name, ItemStack ammo, boolean semiAuto, int minFiretime, int clipsize, int reloadtime, float damage, String firesound, String reloadsound) {
        super(name, ammo, semiAuto, minFiretime, clipsize, reloadtime, damage, firesound, reloadsound, 2, 0.0f, 20.0f);
        this.ammoConsumedOnFullCharge = 10;
    }

    public PowerHammer setMeleeDmg(float dmgFull, float dmgEmpty) {
        this.meleeDamagePwr = dmgFull;
        this.meleeDamageEmpty = dmgEmpty;
        return this;
    }

    @Override
    public void spawnChargedProjectile(World world, EntityLivingBase player, ItemStack itemStack, float spread, float charge, int ammoConsumed) {
        float dmg = (float)ammoConsumed * this.damage;
        world.func_72838_d((Entity)new PowerHammerProjectile(world, player, dmg, this.speed, this.ticksToLive, this.collisionSize, charge, this.damageDropStart, this.damageDropEnd, this.damageMin, this.penetration, PowerHammer.getDoBlockDamage(player)));
    }

    @Override
    public void startCharge(ItemStack item, World world, EntityPlayer player) {
        world.func_72956_a((Entity)player, "techguns:guns.powerhammerCharge", 1.0f, 1.0f);
    }

    @Override
    protected TGDamageSource getMeleeDamageSource(EntityPlayer player, ItemStack stack) {
        TGDamageSource src = new TGDamageSource("player", (Entity)player, (Entity)player, DamageType.PHYSICAL, EntityDeathUtils.DeathType.GORE);
        if (this.getCurrentAmmo(stack) > 0) {
            src.goreChance = 1.0f;
            src.armorPenetration = 0.25f;
            src.knockbackMultiplier = 1.5f;
        } else {
            src.deathType = EntityDeathUtils.DeathType.DEFAULT;
        }
        return src;
    }

    @Override
    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        boolean openingContainer = false;
        if (!entityLiving.field_70170_p.field_72995_K && entityLiving instanceof EntityPlayer) {
            EntityPlayer ply = (EntityPlayer)entityLiving;
            if (ply.field_71070_bA != null && ply.field_71070_bA.getClass() != ContainerPlayer.class) {
                openingContainer = true;
            }
        }
        if (this.getCurrentAmmo(stack) > 0) {
            if (entityLiving.field_70170_p.field_72995_K) {
                ClientProxy cp = ClientProxy.get();
                if (cp.getplayerRecoiltime(entityLiving) < System.currentTimeMillis()) {
                    cp.setplayerRecoiltime(entityLiving, System.currentTimeMillis() + 250L, 250, (byte)0);
                }
                return true;
            }
            boolean sendSound = true;
            if (entityLiving instanceof EntityPlayer) {
                TechgunsExtendedPlayerProperties props = TechgunsExtendedPlayerProperties.get((EntityPlayer)entityLiving);
                if (props.swingSoundDelay > 0) {
                    sendSound = false;
                } else {
                    props.swingSoundDelay = (byte)5;
                }
            }
            if (!openingContainer && sendSound) {
                TGPackets.network.sendToAllAround((IMessage)new PacketPlaySound("techguns:guns.powerhammerSwing", (Entity)entityLiving, 1.0f, 1.0f, false, false, true, true, TGSoundCategory.GUN_FIRE), new NetworkRegistry.TargetPoint(entityLiving.field_70170_p.field_73011_w.field_76574_g, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, 50.0));
            }
            return true;
        }
        return false;
    }

    @Override
    public int consumeAmmoCharge(ItemStack item, float f, boolean creative) {
        int consume = (int)((float)this.ammoConsumedOnFullCharge * f);
        consume = MathUtil.clamp(consume, 1, this.ammoConsumedOnFullCharge);
        if (this.getCurrentAmmo(item) < consume) {
            consume = this.getCurrentAmmo(item);
        }
        if (!creative) {
            this.useAmmo(item, consume);
        }
        return consume;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        double meleedmg = this.meleeDamagePwr;
        int ammoleft = this.getCurrentAmmo(stack);
        if (ammoleft <= 0) {
            meleedmg = this.meleeDamageEmpty;
        }
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", meleedmg, 0));
        return multimap;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block b, int x, int y, int z, EntityLivingBase ent) {
        if (this.getCurrentAmmo(stack) > 0) {
            this.useAmmo(stack, 1);
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "techguns:guns.powerhammerImpactGround", 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public DamageType getDamageType() {
        return DamageType.PHYSICAL;
    }
}

