/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.guns;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import techguns.TGArmorBonus;
import techguns.TGItems;
import techguns.TGPackets;
import techguns.Techguns;
import techguns.client.ClientProxy;
import techguns.client.audio.TGSoundCategory;
import techguns.damagesystem.DamageType;
import techguns.damagesystem.TGDamageSource;
import techguns.entities.ai.EntityAIRangedAttack;
import techguns.entities.npc.NPCTurret;
import techguns.entities.projectiles.GenericProjectile;
import techguns.extendedproperties.TechgunsExtendedPlayerProperties;
import techguns.items.GenericItem;
import techguns.items.armors.GenericArmor;
import techguns.items.armors.ICamoChangeable;
import techguns.packets.GunFiredMessage;
import techguns.packets.ReloadStartedMessage;
import techguns.util.EntityDeathUtils;
import techguns.util.SoundUtil;
import techguns.util.TextUtil;

public class GenericGun
extends GenericItem
implements ICamoChangeable {
    protected static final float SOUND_DISTANCE = 4.0f;
    public HashMap<String, Integer> mininglevels;
    boolean shootWithLeftClick = true;
    boolean semiAuto;
    int minFiretime;
    int clipsize;
    int reloadtime;
    float damage;
    String firesound = "techguns:guns.assaultRifleFire";
    String reloadsound = "techguns:guns.assaultRifleReload";
    String firesoundStart = "techguns:guns.assaultRifleFire";
    String rechamberSound = "";
    int ammoCount;
    float zoomMult = 1.0f;
    boolean canZoom = false;
    boolean toggleZoom = false;
    int ticksToLive = 10;
    float speed = 1.5f;
    float damageMin;
    int damageDropStart;
    int damageDropEnd;
    float penetration = 0.0f;
    ItemStack ammo;
    ItemStack emptyMag;
    ItemStack bullet;
    boolean shotgun = false;
    boolean burst = false;
    float spread = 1.0f;
    int bulletcount = 7;
    float accuracy = 0.0f;
    int maxLoopDelay = 0;
    int recoiltime = 5;
    int muzzleFlashtime = 5;
    boolean silenced = false;
    private Class projectileClass;
    boolean checkRecoil = false;
    float zoombonus = 1.0f;
    float AI_attackRange = 15.0f;
    int AI_attackTime = 60;
    int AI_burstCount = 0;
    int AI_burstAttackTime = 0;
    int camoCount = 1;
    public float turretPosOffsetX = 0.0f;
    public float turretPosOffsetY = 0.0f;
    public float turretPosOffsetZ = 0.0f;
    public float muzzleFlashOffsetX = 0.0f;
    public float muzzleFlashOffsetY = 0.0f;
    public float muzzleFlashOffsetZ = 0.0f;
    public float digSpeed = 1.0f;
    public float muzzleFlashOffsetTurretY = 0.0f;
    public float muzzleFlashOffsetTurretX = 0.0f;
    public float muzzleFlashOffsetTurretZ = 0.0f;
    private static String[] muzzleflash = new String[]{null, "MuzzleFlashYellow", "MuzzleFlashExp", "MuzzleFlashBlue", "MuzzleFlashLaser"};
    private byte muzzleflashIndex = 0;
    protected int meleeHitAmmoConsumption = 1;
    protected int miningAmmoConsumption = 1;
    protected float shotsPerBullet;
    public ArrayList<ResourceLocation> textures = new ArrayList();
    private static ArrayList<GenericGun> guns = new ArrayList();

    public GenericGun() {
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77656_e(this.clipsize);
        this.func_77637_a(Techguns.tabTechgun);
        this.func_77655_b("testGun");
        this.func_111206_d("techguns:testGun");
        this.semiAuto = false;
        this.minFiretime = 0;
        this.clipsize = 10;
        this.shotsPerBullet = this.clipsize;
        this.reloadtime = 40;
        this.damage = 10.0f;
        this.ammoCount = 1;
        this.ticksToLive = 40;
        this.damageDropStart = 40;
        this.damageDropEnd = 40;
        this.damageMin = 10.0f;
        guns.add(this);
    }

    public GenericGun(ItemStack ammo) {
        this();
        this.ammo = ammo;
        guns.add(this);
    }

    public GenericGun(String name, ItemStack ammo, boolean semiAuto, int minFiretime, int clipsize, int reloadtime, float damage, String firesound, String reloadsound, int TTL, float accuracy) {
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77656_e(clipsize);
        this.func_77637_a(Techguns.tabTechgun);
        this.func_77655_b(name);
        this.ammo = ammo;
        this.semiAuto = semiAuto;
        this.minFiretime = minFiretime;
        this.clipsize = clipsize;
        this.reloadtime = reloadtime;
        this.damage = damage;
        this.firesound = firesound;
        this.reloadsound = reloadsound;
        this.emptyMag = null;
        this.ammoCount = 1;
        this.shotsPerBullet = clipsize;
        this.ticksToLive = TTL;
        this.accuracy = accuracy;
        this.damageDropStart = TTL;
        this.damageDropEnd = TTL;
        this.damageMin = damage;
        guns.add(this);
    }

    public static void loadStatsFromFileForAllGuns() {
        for (int i = 0; i < guns.size(); ++i) {
            guns.get(i).loadStatsFromFile();
        }
    }

    public void loadStatsFromFile() {
        Properties props = new Properties();
        String path = System.getProperty("file.separator", "/") + "config" + System.getProperty("file.separator", "/") + "Techguns" + System.getProperty("file.separator", "/") + this.func_77658_a() + ".txt";
        try {
            System.out.println(path);
            FileInputStream in = new FileInputStream(path);
            props.load(in);
            in.close();
            this.minFiretime = Integer.parseInt(props.getProperty("minFiretime"));
            this.reloadtime = Integer.parseInt(props.getProperty("reloadtime"));
            this.clipsize = Integer.parseInt(props.getProperty("clipsize"));
            this.damage = Float.parseFloat(props.getProperty("damage"));
            this.damageMin = Float.parseFloat(props.getProperty("damageMin"));
            this.damageDropStart = Integer.parseInt(props.getProperty("damageDropStart"));
            this.damageDropEnd = Integer.parseInt(props.getProperty("damageDropEnd"));
            this.ticksToLive = Integer.parseInt(props.getProperty("ticksToLive"));
            this.accuracy = Float.parseFloat(props.getProperty("accuracy"));
            this.penetration = Float.parseFloat(props.getProperty("penetration"));
        }
        catch (FileNotFoundException e) {
            props.setProperty("minFiretime", "" + this.minFiretime);
            props.setProperty("reloadtime", "" + this.reloadtime);
            props.setProperty("clipsize", "" + this.clipsize);
            props.setProperty("damage", "" + this.damage);
            props.setProperty("damageMin", "" + this.damageMin);
            props.setProperty("damageDropStart", "" + this.damageDropStart);
            props.setProperty("damageDropEnd", "" + this.damageDropEnd);
            props.setProperty("ticksToLive", "" + this.ticksToLive);
            props.setProperty("accuracy", "" + this.accuracy);
            props.setProperty("penetration", "" + this.penetration);
            try {
                FileOutputStream out = new FileOutputStream(path);
                props.store(out, "Weaponstats for" + this.func_77658_a());
                out.close();
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
                System.out.println(e1.getMessage());
            }
            catch (IOException e1) {
                e1.printStackTrace();
                System.out.println(e1.getMessage());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
    }

    public DamageType getDamageType() {
        return DamageType.PROJECTILE;
    }

    public GenericGun setDigSpeed(float speed) {
        this.digSpeed = speed;
        return this;
    }

    public GenericGun setEmptyMag(ItemStack emptyMag, ItemStack bullet, int bulletsPerMag) {
        this.emptyMag = emptyMag;
        this.bullet = bullet;
        this.shotsPerBullet = (float)this.clipsize * 1.0f / ((float)bulletsPerMag * 1.0f);
        return this;
    }

    public GenericGun setAmmoCount(int count) {
        this.ammoCount = count;
        this.shotsPerBullet = (float)this.clipsize * 1.0f / ((float)this.ammoCount * 1.0f);
        return this;
    }

    public GenericGun setZoom(float mult, boolean toggle, float bonus) {
        this.canZoom = true;
        this.zoomMult = mult;
        this.toggleZoom = toggle;
        this.zoombonus = bonus;
        return this;
    }

    public GenericGun setShotgunSpred(int count, float spread) {
        return this.setShotgunSpread(count, spread, false);
    }

    public GenericGun setShotgunSpread(int count, float spread, boolean burst) {
        this.shotgun = true;
        this.spread = spread;
        this.bulletcount = count;
        this.burst = burst;
        return this;
    }

    public GenericGun setPenetration(float pen) {
        this.penetration = pen;
        return this;
    }

    public GenericGun setMuzzleFlashTime(int time) {
        this.muzzleFlashtime = time;
        return this;
    }

    @Deprecated
    public GenericGun setProjectileClass(Class projectileClass) {
        this.projectileClass = projectileClass;
        return this;
    }

    public GenericGun setFiresoundStart(String firesoundStart) {
        this.firesoundStart = firesoundStart;
        return this;
    }

    public GenericGun setMaxLoopDelay(int maxLoopDelay) {
        this.maxLoopDelay = maxLoopDelay;
        return this;
    }

    public GenericGun setRecoiltime(int recoiltime) {
        this.recoiltime = recoiltime;
        return this;
    }

    public GenericGun setRechamberSound(String rechamberSound) {
        this.rechamberSound = rechamberSound;
        return this;
    }

    public boolean hasZoom() {
        return this.canZoom;
    }

    public boolean isZooming() {
        return ClientProxy.get().player_zoom == this.zoomMult;
    }

    public boolean isHoldZoom() {
        return !this.toggleZoom && this.hasZoom();
    }

    public GenericGun setCheckRecoil() {
        this.checkRecoil = true;
        return this;
    }

    public float getZoomMult() {
        return this.zoomMult;
    }

    public GenericGun setSpeed(float speedMult) {
        this.speed *= speedMult;
        return this;
    }

    public GenericGun setDamageDrop(int start, int end, float minDamage) {
        this.damageDropStart = start;
        this.damageDropEnd = end;
        this.damageMin = minDamage;
        return this;
    }

    public GenericGun setSilenced(boolean s) {
        this.silenced = s;
        return this;
    }

    public void func_77615_a(ItemStack p_item, World p_world, EntityPlayer p_player, int p_itemInUseCount) {
    }

    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        if (this.canZoom && this.toggleZoom && world.field_72995_K) {
            ClientProxy cp = ClientProxy.get();
            cp.player_zoom = cp.player_zoom != 1.0f ? 1.0f : this.zoomMult;
        }
        return super.func_77659_a(item, world, player);
    }

    public void shootGunLeftClick(ItemStack item, World world, EntityPlayer player, boolean isZooming) {
        TechgunsExtendedPlayerProperties extendedPlayer = TechgunsExtendedPlayerProperties.get(player);
        int ammo = this.getCurrentAmmo(item);
        if (ammo > 0) {
            int firedelay = extendedPlayer.fireDelay;
            if (firedelay <= 0) {
                extendedPlayer.fireDelay = this.minFiretime;
                if (!player.field_71075_bZ.field_75098_d) {
                    this.useAmmo(item, 1);
                }
                if (!world.field_72995_K) {
                    float accuracybonus = 1.0f - GenericArmor.getArmorBonusForPlayer(player, TGArmorBonus.GUN_ACCURACY, false);
                    if (isZooming) {
                        accuracybonus *= this.zoombonus;
                    }
                    this.shootGun(world, (EntityLivingBase)player, item, accuracybonus, 1.0f);
                } else {
                    int recoiltime_l = (int)((float)this.recoiltime / 20.0f * 1000.0f);
                    long muzzleFlashtime_l = (long)((float)this.muzzleFlashtime / 20.0f * 1000.0f);
                    ClientProxy cp = ClientProxy.get();
                    if (!this.checkRecoil || !cp.isStillRecoiling((EntityLivingBase)player, (byte)0)) {
                        cp.setplayerRecoiltime((EntityLivingBase)player, System.currentTimeMillis() + (long)recoiltime_l, recoiltime_l, (byte)0);
                    }
                    cp.player_muzzleFlashtime = System.currentTimeMillis() + muzzleFlashtime_l;
                    cp.player_muzzleFlashtime_total = muzzleFlashtime_l;
                    this.client_weaponFired();
                }
                if (this.maxLoopDelay > 0 && extendedPlayer.loopSoundDelay <= 0) {
                    SoundUtil.playSoundOnEntityGunPosition(world, (Entity)player, this.firesoundStart, 4.0f, 1.0f, false, false, TGSoundCategory.GUN_FIRE);
                    extendedPlayer.loopSoundDelay = this.maxLoopDelay;
                } else {
                    SoundUtil.playSoundOnEntityGunPosition(world, (Entity)player, this.firesound, 4.0f, 1.0f, false, false, TGSoundCategory.GUN_FIRE);
                    if (this.maxLoopDelay > 0) {
                        extendedPlayer.loopSoundDelay = this.maxLoopDelay;
                    }
                }
                if (!this.rechamberSound.isEmpty()) {
                    SoundUtil.playSoundOnEntityGunPosition(world, (Entity)player, this.rechamberSound, 1.0f, 1.0f, false, false, TGSoundCategory.RELOAD);
                }
            }
        } else if (Techguns.consumeAmmoPlayer(player, this.ammo)) {
            int amount;
            if (this.emptyMag != null && (amount = Techguns.addAmmoToPlayerInventory(player, TGItems.newStack(this.emptyMag, 1))) > 0 && !world.field_72995_K) {
                player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, TGItems.newStack(this.emptyMag, amount)));
            }
            if (world.field_72995_K && this.canZoom && this.toggleZoom) {
                ClientProxy cp = ClientProxy.get();
                if (cp.player_zoom != 1.0f) {
                    cp.player_zoom = 1.0f;
                }
            }
            extendedPlayer.fireDelay = this.reloadtime - this.minFiretime;
            if (this.ammoCount > 1) {
                int i;
                for (i = 1; i < this.ammoCount && Techguns.consumeAmmoPlayer(player, this.ammo); ++i) {
                }
                this.reloadAmmo(item, i);
            } else {
                this.reloadAmmo(item);
            }
            SoundUtil.playReloadSoundOnEntity(world, (Entity)player, this.reloadsound, 1.0f, 1.0f, false, true, TGSoundCategory.RELOAD);
            if (world.field_72995_K) {
                int time = (int)((float)this.reloadtime / 20.0f * 1000.0f);
                ClientProxy.get().setplayerReloadtime((EntityLivingBase)player, System.currentTimeMillis() + (long)time, time, (byte)0);
                this.client_startReload();
            } else {
                int msg_reloadtime = (int)((float)this.reloadtime / 20.0f * 1000.0f);
                TGPackets.network.sendToAllAround((IMessage)new ReloadStartedMessage((EntityLivingBase)player, msg_reloadtime, 0), new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 100.0));
            }
        } else if (!world.field_72995_K) {
            world.func_72956_a((Entity)player, "mob.villager.idle", 1.0f, 1.0f);
        }
    }

    public void tryForcedReload(ItemStack item, World world, EntityPlayer player) {
        TechgunsExtendedPlayerProperties extendedPlayer = TechgunsExtendedPlayerProperties.get(player);
        if (extendedPlayer.fireDelay <= 0 && !this.isFullyLoaded(item)) {
            int oldAmmo = this.getCurrentAmmo(item);
            if (Techguns.consumeAmmoPlayer(player, this.ammo)) {
                if (this.ammoCount <= 1) {
                    this.useAmmo(item, oldAmmo);
                }
                if (this.emptyMag != null) {
                    int amount2;
                    int bulletsBack;
                    int amount = Techguns.addAmmoToPlayerInventory(player, TGItems.newStack(this.emptyMag, 1));
                    if (amount > 0 && !world.field_72995_K) {
                        player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, TGItems.newStack(this.emptyMag, amount)));
                    }
                    if ((bulletsBack = (int)Math.floor((float)oldAmmo / this.shotsPerBullet)) > 0 && (amount2 = Techguns.addAmmoToPlayerInventory(player, TGItems.newStack(this.bullet, bulletsBack))) > 0 && !world.field_72995_K) {
                        player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, TGItems.newStack(this.bullet, amount2)));
                    }
                }
                if (world.field_72995_K && this.canZoom && this.toggleZoom) {
                    ClientProxy cp = ClientProxy.get();
                    if (cp.player_zoom != 1.0f) {
                        cp.player_zoom = 1.0f;
                    }
                }
                extendedPlayer.fireDelay = this.reloadtime - this.minFiretime;
                if (this.ammoCount > 1) {
                    int i;
                    for (i = 1; i < this.ammoCount - oldAmmo && Techguns.consumeAmmoPlayer(player, this.ammo); ++i) {
                    }
                    this.reloadAmmo(item, i);
                } else {
                    this.reloadAmmo(item);
                }
                SoundUtil.playReloadSoundOnEntity(world, (Entity)player, this.reloadsound, 1.0f, 1.0f, false, true, TGSoundCategory.RELOAD);
                if (world.field_72995_K) {
                    int time = (int)((float)this.reloadtime / 20.0f * 1000.0f);
                    ClientProxy.get().setplayerReloadtime((EntityLivingBase)player, System.currentTimeMillis() + (long)time, time, (byte)0);
                    this.client_startReload();
                } else {
                    int msg_reloadtime = (int)((float)this.reloadtime / 20.0f * 1000.0f);
                    TGPackets.network.sendToAllAround((IMessage)new ReloadStartedMessage((EntityLivingBase)player, msg_reloadtime, 0), new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 100.0));
                }
            } else if (!world.field_72995_K) {
                world.func_72956_a((Entity)player, "mob.villager.idle", 1.0f, 1.0f);
            }
        }
    }

    public float getDamage() {
        return this.damage;
    }

    protected void shootGun(World world, EntityLivingBase player, ItemStack itemstack, float accuracybonus, float damagebonus) {
        if (!world.field_72995_K) {
            int msg_recoiltime = (int)((float)this.recoiltime / 20.0f * 1000.0f);
            TGPackets.network.sendToAllAround((IMessage)new GunFiredMessage(player, msg_recoiltime, 0, this.checkRecoil), new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 100.0));
        }
        this.spawnProjectile(world, player, itemstack, this.accuracy * accuracybonus, 0.0f, damagebonus);
        if (this.shotgun) {
            float offset = 0.0f;
            if (this.burst) {
                offset = 1.0f / (float)this.bulletcount;
            }
            for (int i = 0; i < this.bulletcount; ++i) {
                this.spawnProjectile(world, player, itemstack, this.spread * accuracybonus, offset * ((float)i + 1.0f), damagebonus);
            }
        }
    }

    protected void client_startReload() {
    }

    protected void client_weaponFired() {
    }

    protected static boolean getDoBlockDamage(EntityLivingBase elb) {
        TechgunsExtendedPlayerProperties props;
        boolean blockdamage = false;
        if (elb instanceof EntityPlayer && (props = TechgunsExtendedPlayerProperties.get((EntityPlayer)elb)) != null) {
            blockdamage = !props.enableSafemode;
        }
        return blockdamage;
    }

    protected void spawnProjectile(World world, EntityLivingBase player, ItemStack itemstack, float spread, float offset, float damagebonus) {
        GenericProjectile proj = new GenericProjectile(world, player, this.damage * damagebonus, this.speed, this.ticksToLive, spread, this.damageDropStart, this.damageDropEnd, this.damageMin * damagebonus, this.penetration, GenericGun.getDoBlockDamage(player));
        if (this.silenced) {
            proj.setSilenced();
        }
        if (offset > 0.0f) {
            proj.shiftForward(offset);
        }
        world.func_72838_d((Entity)proj);
    }

    public void fireWeaponFromNPC(EntityLivingBase shooter, float dmgscale, float accscale) {
        SoundUtil.playSoundOnEntityGunPosition(shooter.field_70170_p, (Entity)shooter, this.firesound, 4.0f, 1.0f, false, false, TGSoundCategory.GUN_FIRE);
        float dmg = 0.5f;
        float acc = 1.0f;
        if (shooter instanceof NPCTurret) {
            dmg = 1.0f;
            acc = 1.0f;
        } else {
            EnumDifficulty difficulty = shooter.field_70170_p.field_73013_u;
            switch (difficulty) {
                case EASY: {
                    dmg = 0.5f;
                    acc = 1.3f;
                    break;
                }
                case NORMAL: {
                    dmg = 0.6f;
                    acc = 1.15f;
                    break;
                }
                case HARD: {
                    dmg = 0.75f;
                    acc = 1.0f;
                    break;
                }
                case PEACEFUL: {
                    dmg = 0.0f;
                    acc = 1.3f;
                }
            }
        }
        if (!shooter.field_70170_p.field_72995_K) {
            this.shootGun(shooter.field_70170_p, shooter, null, this.zoombonus * accscale * acc, dmgscale * dmg);
        }
    }

    public void func_77624_a(ItemStack item, EntityPlayer player, List list, boolean b) {
        super.func_77624_a(item, player, list, b);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextUtil.trans("techguns.gun.tooltip.ammo") + ": " + (this.ammoCount > 1 ? this.ammoCount + "x " : "") + EnumChatFormatting.WHITE + TextUtil.trans(this.getAmmo().func_77977_a() + ".name"));
            list.add(TextUtil.trans("techguns.gun.tooltip.damageType") + ": " + this.getDamageType().toString());
            list.add(TextUtil.trans("techguns.gun.tooltip.damage") + (this.shotgun ? "(x" + (this.bulletcount + 1) + ")" : "") + ": " + this.damage + (this.damageMin < this.damage ? "-" + this.damageMin : ""));
            list.add(TextUtil.trans("techguns.gun.tooltip.range") + ": " + this.damageDropStart + "," + this.damageDropEnd + "," + this.ticksToLive);
            list.add(TextUtil.trans("techguns.gun.tooltip.spread") + ": " + this.accuracy);
            list.add(TextUtil.trans("techguns.gun.tooltip.clipsize") + ": " + this.clipsize);
            list.add(TextUtil.trans("techguns.gun.tooltip.reloadTime") + ": " + (float)this.reloadtime * 0.05f + "s");
            if (this.penetration > 0.0f) {
                list.add(TextUtil.trans("techguns.gun.tooltip.armorPen") + ": " + this.penetration * 100.0f + "%");
            }
            if (this.canZoom) {
                list.add(TextUtil.trans("techguns.gun.tooltip.zoom") + ":" + (this.toggleZoom ? "(" + TextUtil.trans("techguns.gun.tooltip.zoom.toogle") + ")" : "(" + TextUtil.trans("techguns.gun.tooltip.zoom.hold") + ")") + " " + TextUtil.trans("techguns.gun.tooltip.zoom.multiplier") + ":" + this.zoomMult);
            }
        } else {
            list.add(TextUtil.trans("techguns.gun.tooltip.ammo") + ": " + (this.ammoCount > 1 ? this.ammoCount + "x " : "") + EnumChatFormatting.WHITE + TextUtil.trans(this.getAmmo().func_77977_a() + ".name"));
            list.add(TextUtil.trans("techguns.gun.tooltip.damage") + (this.shotgun ? "(x" + (this.bulletcount + 1) + ")" : "") + ": " + this.damage + "-" + this.damageMin);
            list.add(TextUtil.trans("techguns.gun.tooltip.shift1") + " " + EnumChatFormatting.GREEN + TextUtil.trans("techguns.gun.tooltip.shift2") + " " + EnumChatFormatting.GRAY + TextUtil.trans("techguns.gun.tooltip.shift3"));
        }
    }

    public GenericGun setAIStats(float attackRange, int attackTime, int burstCount, int burstAttackTime) {
        this.AI_attackRange = attackRange;
        this.AI_attackTime = attackTime;
        this.AI_burstCount = burstCount;
        this.AI_burstAttackTime = burstAttackTime;
        return this;
    }

    public EntityAIRangedAttack getAIAttack(IRangedAttackMob shooter) {
        return new EntityAIRangedAttack(shooter, 1.0, this.AI_attackTime / 3, this.AI_attackTime, this.AI_attackRange, this.AI_burstCount, this.AI_burstAttackTime);
    }

    public ItemStack getAmmo() {
        return this.ammo;
    }

    public ItemStack getEmptyMag() {
        return this.emptyMag;
    }

    public int getAmmoCount() {
        return this.ammoCount;
    }

    public float getAI_attackRange() {
        return this.AI_attackRange;
    }

    public GenericGun setCamoCount(byte count) {
        this.camoCount = count;
        return this;
    }

    public GenericGun setTexture(String path) {
        return this.setTextures(path, 1);
    }

    public GenericGun setTextures(String path, int variations) {
        Techguns.proxy.setGunTextures(this, path, variations);
        this.camoCount = variations;
        return this;
    }

    @Override
    public int getCamoCount() {
        return this.camoCount;
    }

    @Override
    public String getCurrentCamoName(ItemStack item) {
        NBTTagCompound tags = item.func_77978_p();
        int camoID = 0;
        if (tags != null && tags.func_74764_b("camo")) {
            camoID = tags.func_74771_c("camo");
        }
        if (camoID > 0) {
            return TextUtil.trans(this.func_77658_a() + ".camoname." + camoID);
        }
        return TextUtil.trans("techguns.item.defaultcamo");
    }

    @Override
    public int getCurrentCamoIndex(ItemStack item) {
        NBTTagCompound tags = item.func_77978_p();
        int camoID = 0;
        if (tags != null && tags.func_74764_b("camo")) {
            camoID = tags.func_74771_c("camo");
        }
        return camoID;
    }

    @Override
    public int switchCamo(ItemStack item) {
        return this.switchCamo(item, false);
    }

    @Override
    public int switchCamo(ItemStack item, boolean back) {
        byte camoID = 0;
        NBTTagCompound tags = item.func_77978_p();
        if (tags != null && tags.func_74764_b("camo")) {
            camoID = tags.func_74771_c("camo");
        }
        if (tags == null) {
            tags = new NBTTagCompound();
            tags.func_74774_a("camo", (byte)0);
            item.func_77982_d(tags);
        }
        if (this.camoCount > 1) {
            camoID = !back ? (byte)(camoID + 1) : (byte)(camoID - 1);
            if (camoID >= this.camoCount) {
                camoID = 0;
            } else if (camoID < 0) {
                camoID = (byte)(this.camoCount - 1);
            }
            tags.func_74774_a("camo", camoID);
            return camoID;
        }
        return 0;
    }

    public int getAmmoLeftCountTooltip(ItemStack item) {
        int ammo = this.getCurrentAmmo(item);
        if (this.burst) {
            return ammo * (this.bulletcount + 1);
        }
        return ammo;
    }

    public int getClipsizeTooltip() {
        if (this.burst) {
            return this.clipsize * (this.bulletcount + 1);
        }
        return this.clipsize;
    }

    public int getAmmoLeftCount(int mags) {
        int count = this.clipsize / this.ammoCount * mags;
        if (this.burst) {
            return count * (this.bulletcount + 1);
        }
        return count;
    }

    public GenericGun setTurretPosOffset(float x, float y, float z) {
        this.turretPosOffsetX = x;
        this.turretPosOffsetY = y;
        this.turretPosOffsetZ = z;
        return this;
    }

    public GenericGun setMuzzleParticle(int i) {
        this.muzzleflashIndex = (byte)i;
        return this;
    }

    public GenericGun setMuzzleParticle(int i, float z) {
        this.muzzleflashIndex = (byte)i;
        this.muzzleFlashOffsetZ = z;
        return this;
    }

    public GenericGun setMuzzleParticle(int i, float x, float y, float z) {
        this.muzzleflashIndex = (byte)i;
        this.muzzleFlashOffsetX = x;
        this.muzzleFlashOffsetY = y;
        this.muzzleFlashOffsetZ = z;
        return this;
    }

    public GenericGun setMuzzleParticleOffsetTurret(float x, float y, float z) {
        this.muzzleFlashOffsetTurretX = x;
        this.muzzleFlashOffsetTurretY = y;
        this.muzzleFlashOffsetTurretZ = z;
        return this;
    }

    public String getMuzzleflashParticle() {
        return muzzleflash[this.muzzleflashIndex];
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (this.shootWithLeftClick) {
            return true;
        }
        return this.getCurrentAmmo(stack) >= this.miningAmmoConsumption;
    }

    protected TGDamageSource getMeleeDamageSource(EntityPlayer player, ItemStack stack) {
        TGDamageSource src = new TGDamageSource("player", (Entity)player, (Entity)player, DamageType.PHYSICAL, EntityDeathUtils.DeathType.GORE);
        return src;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (this.shootWithLeftClick) {
            return true;
        }
        if (player.field_70170_p.field_72995_K) {
            int time = (int)((float)this.recoiltime / 20.0f * 1000.0f);
            ClientProxy.get().setplayerRecoiltime((EntityLivingBase)player, System.currentTimeMillis() + (long)time, time, (byte)0);
        }
        if (player.func_70075_an() && !entity.func_85031_j((Entity)player)) {
            float f = (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            int i = 0;
            float f1 = 0.0f;
            if (entity instanceof EntityLivingBase) {
                f1 = EnchantmentHelper.func_77512_a((EntityLivingBase)player, (EntityLivingBase)((EntityLivingBase)entity));
                i += EnchantmentHelper.func_77507_b((EntityLivingBase)player, (EntityLivingBase)((EntityLivingBase)entity));
            }
            if (player.func_70051_ag()) {
                ++i;
            }
            if (f > 0.0f || f1 > 0.0f) {
                boolean flag;
                boolean bl = flag = player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Potion.field_76440_q) && player.field_70154_o == null && entity instanceof EntityLivingBase;
                if (flag && f > 0.0f) {
                    f *= 1.5f;
                }
                f += f1;
                boolean flag1 = false;
                int j = EnchantmentHelper.func_90036_a((EntityLivingBase)player);
                if (entity instanceof EntityLivingBase && j > 0 && !entity.func_70027_ad()) {
                    flag1 = true;
                    entity.func_70015_d(1);
                }
                TGDamageSource src = this.getMeleeDamageSource(player, stack);
                boolean flag2 = entity.func_70097_a((DamageSource)src, f);
                if (this.getCurrentAmmo(stack) >= this.meleeHitAmmoConsumption) {
                    this.useAmmo(stack, this.meleeHitAmmoConsumption);
                }
                if (flag2) {
                    IEntityMultiPart ientitymultipart;
                    if (i > 0) {
                        entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                        player.field_70159_w *= 0.6;
                        player.field_70179_y *= 0.6;
                        player.func_70031_b(false);
                    }
                    if (flag) {
                        player.func_71009_b(entity);
                    }
                    if (f1 > 0.0f) {
                        player.func_71047_c(entity);
                    }
                    if (f >= 18.0f) {
                        player.func_71029_a((StatBase)AchievementList.field_75999_E);
                    }
                    player.func_130011_c(entity);
                    if (entity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)entity), (Entity)player);
                    }
                    EnchantmentHelper.func_151385_b((EntityLivingBase)player, (Entity)entity);
                    ItemStack itemstack = player.func_71045_bC();
                    Entity object = entity;
                    if (entity instanceof EntityDragonPart && (ientitymultipart = ((EntityDragonPart)entity).field_70259_a) != null && ientitymultipart instanceof EntityLivingBase) {
                        object = (EntityLivingBase)ientitymultipart;
                    }
                    if (itemstack != null && object instanceof EntityLivingBase) {
                        itemstack.func_77961_a((EntityLivingBase)object, player);
                        if (itemstack.field_77994_a <= 0) {
                            player.func_71028_bD();
                        }
                    }
                    if (entity instanceof EntityLivingBase) {
                        player.func_71064_a(StatList.field_75951_w, Math.round(f * 10.0f));
                        if (j > 0) {
                            entity.func_70015_d(j * 4);
                        }
                    }
                    player.func_71020_j(0.3f);
                } else if (flag1) {
                    entity.func_70066_B();
                }
            }
        }
        return true;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int X, int Y, int Z, EntityPlayer player) {
        return this.shootWithLeftClick;
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
            stack.func_77982_d(tags);
            int dmg = stack.func_77960_j();
            tags.func_74774_a("camo", (byte)0);
            tags.func_74777_a("ammo", dmg == 0 ? (short)this.clipsize : (short)(this.clipsize - dmg));
            stack.func_77964_b(0);
        }
    }

    public int getCurrentAmmo(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags == null) {
            this.func_77622_d(stack, null, null);
            tags = stack.func_77978_p();
        }
        return tags.func_74765_d("ammo");
    }

    public void useAmmo(ItemStack stack, int amount) {
        int ammo = this.getCurrentAmmo(stack);
        NBTTagCompound tags = stack.func_77978_p();
        if (ammo - amount >= 0) {
            tags.func_74777_a("ammo", (short)(ammo - amount));
        } else {
            tags.func_74777_a("ammo", (short)0);
        }
    }

    public void reloadAmmo(ItemStack stack) {
        this.reloadAmmo(stack, this.clipsize);
    }

    public void reloadAmmo(ItemStack stack, int amount) {
        int ammo = this.getCurrentAmmo(stack);
        NBTTagCompound tags = stack.func_77978_p();
        tags.func_74777_a("ammo", (short)(ammo + amount));
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        ItemStack gun = new ItemStack(item, 1, 0);
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74774_a("camo", (byte)0);
        tags.func_74777_a("ammo", (short)this.clipsize);
        gun.func_77982_d(tags);
        list.add(gun);
    }

    public boolean isFullyLoaded(ItemStack stack) {
        return this.clipsize == this.getCurrentAmmo(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags == null) {
            return (float)stack.func_77960_j() * 1.0f / ((float)stack.func_77958_k() * 1.0f);
        }
        int ammo = this.getCurrentAmmo(stack);
        float percent = (float)ammo * 1.0f / (1.0f * (float)this.clipsize);
        return 1.0f - percent;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public boolean isSemiAuto() {
        return this.semiAuto;
    }

    public boolean isShootWithLeftClick() {
        return this.shootWithLeftClick;
    }

    public GenericGun setShootWithLeftClick(boolean shootWithLeftClick) {
        this.shootWithLeftClick = shootWithLeftClick;
        return this;
    }

    public GenericGun setTool(String toolclass, int harvestLevel) {
        if (this.mininglevels == null) {
            this.mininglevels = new HashMap();
            this.mininglevels.put("default", harvestLevel);
        }
        this.mininglevels.put(toolclass, harvestLevel);
        return this;
    }

    public float getDigSpeed(ItemStack itemstack, Block block, int metadata) {
        if (this.getCurrentAmmo(itemstack) >= this.miningAmmoConsumption) {
            if (this.mininglevels == null) {
                return 1.0f;
            }
            String toolclass = block.getHarvestTool(metadata);
            if (toolclass != null) {
                if (this.mininglevels.containsKey(toolclass)) {
                    return this.digSpeed;
                }
                return 1.0f;
            }
            return this.digSpeed;
        }
        return 1.0f;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (this.mininglevels == null) {
            return 0;
        }
        if (toolClass == null) {
            return this.mininglevels.get("default");
        }
        if (this.mininglevels.containsKey(toolClass)) {
            return this.mininglevels.get(toolClass);
        }
        return 0;
    }

    public boolean canHarvestBlock(Block block, ItemStack itemStack) {
        int harvestLevel = block.getHarvestLevel(0);
        String tool = block.getHarvestTool(0);
        return this.getHarvestLevel(itemStack, tool) >= harvestLevel;
    }

    public int getMeleeHitAmmoConsumption() {
        return this.meleeHitAmmoConsumption;
    }

    public GenericGun setMeleeHitAmmoConsumption(int meleeHitAmmoConsumption) {
        this.meleeHitAmmoConsumption = meleeHitAmmoConsumption;
        return this;
    }
}

