/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.armors;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import techguns.TGArmorBonus;
import techguns.TGItems;
import techguns.Techguns;
import techguns.damagesystem.TGArmorMaterial;
import techguns.items.armors.ArmorPowerType;
import techguns.items.armors.GenericArmorMultiCamo;
import techguns.util.TextUtil;

public class PoweredArmor
extends GenericArmorMultiCamo {
    protected ArmorPowerType powerType;
    protected ItemStack battery = null;
    protected ItemStack battery_empty = null;
    public int maxpower;
    protected float SpeedBonusUnpowered = 0.0f;
    protected float JumpBonusUnpowered = 0.0f;
    protected float FallDMGUnpowered = 0.0f;
    protected float FallFreeHeightUnpowered = 0.0f;
    protected float MiningSpeedBonusUnpowered = 0.0f;
    protected float WaterMiningBonusUnpowered = 0.0f;
    protected int armorValueUnpowered = 0;
    protected float GunAccuracyUnpowered = 0.0f;
    protected float extraHeartsUnpowered = 0.0f;
    protected float nightvisionUnpowered = 0.0f;
    protected float knockbackresistanceUnpowered = 0.0f;
    protected float stepassistUnpowerd = 0.0f;
    protected float oxygen_gearUnpowered = 0.0f;
    protected float water_electrolyzerUnpowered = 0.0f;
    protected float coolingsystemUnpowered = 0.0f;
    protected float waterspeedbonusUnpowered = 0.0f;

    public PoweredArmor(String unlocalizedName, TGArmorMaterial material, String[] textureNames, int type, ArmorPowerType powerType, int maxpower) {
        super(unlocalizedName, material, textureNames, type);
        this.powerType = powerType;
        this.maxpower = maxpower;
    }

    public PoweredArmor setBattery(ItemStack battery) {
        this.battery = battery;
        return this;
    }

    public PoweredArmor setEmptyBattery(ItemStack emptyBattery) {
        this.battery_empty = emptyBattery;
        return this;
    }

    public ItemStack getBattery() {
        return this.battery;
    }

    public ItemStack getBattery_empty() {
        return this.battery_empty;
    }

    public float getBonusUnpowered(TGArmorBonus type) {
        switch (type) {
            case SPEED: {
                return this.SpeedBonusUnpowered;
            }
            case JUMP: {
                return this.JumpBonusUnpowered;
            }
            case FALLDMG: {
                return this.FallDMGUnpowered;
            }
            case FREEHEIGHT: {
                return this.FallFreeHeightUnpowered;
            }
            case BREAKSPEED: {
                return this.MiningSpeedBonusUnpowered;
            }
            case BREAKSPEED_WATER: {
                return this.WaterMiningBonusUnpowered;
            }
            case GUN_ACCURACY: {
                return this.GunAccuracyUnpowered;
            }
            case EXTRA_HEART: {
                return this.extraHeartsUnpowered;
            }
            case NIGHTVISION: {
                return this.nightvisionUnpowered;
            }
            case KNOCKBACK_RESISTANCE: {
                return this.knockbackresistanceUnpowered;
            }
            case STEPASSIST: {
                return this.stepassistUnpowerd;
            }
            case OXYGEN_GEAR: {
                return this.oxygen_gearUnpowered;
            }
            case WATER_ELECTROLYZER: {
                return this.water_electrolyzerUnpowered;
            }
            case COOLING_SYSTEM: {
                return this.coolingsystemUnpowered;
            }
            case SPEED_WATER: {
                return this.waterspeedbonusUnpowered;
            }
        }
        return 0.0f;
    }

    public PoweredArmor setSpeedBoni(float speed, float jump, float speed_unpowered, float jump_unpowered) {
        this.SpeedBonus = speed;
        this.JumpBonus = jump;
        this.SpeedBonusUnpowered = speed_unpowered;
        this.JumpBonusUnpowered = jump_unpowered;
        return this;
    }

    public PoweredArmor setFallProtection(float multiplier, float freeheight, float multiplier_unpowered, float freeheight_unpowered) {
        this.FallDMG = multiplier;
        this.FallFreeHeight = freeheight;
        this.FallDMGUnpowered = multiplier_unpowered;
        this.FallFreeHeightUnpowered = freeheight_unpowered;
        return this;
    }

    public PoweredArmor setMiningBoni(float bonus, float bonus_unpowered) {
        this.MiningSpeedBonus = bonus;
        this.MiningSpeedBonusUnpowered = bonus_unpowered;
        return this;
    }

    public PoweredArmor setMiningBoniWater(float bonus, float bonus_unpowered) {
        this.WaterMiningBonus = bonus;
        this.WaterMiningBonusUnpowered = bonus_unpowered;
        return this;
    }

    public PoweredArmor setGunBonus(float acc, float acc_unpowered) {
        this.GunAccuracy = acc;
        this.GunAccuracyUnpowered = acc_unpowered;
        return this;
    }

    public PoweredArmor setHealthBonus(int bonusHearts, int bonusHeartsUnpowered) {
        this.extraHearts = bonusHearts;
        this.extraHeartsUnpowered = bonusHeartsUnpowered;
        return this;
    }

    public PoweredArmor setKnockbackResistance(float resistpercent, float resistpercent_unpowered) {
        this.knockbackresistance = resistpercent;
        this.knockbackresistanceUnpowered = resistpercent_unpowered;
        return this;
    }

    public PoweredArmor setStepAssist(float stepassist, float stepassist_unpowered) {
        this.stepassist = stepassist;
        this.stepassistUnpowerd = stepassist_unpowered;
        return this;
    }

    public PoweredArmor setOxygenGear(float value, float unpowered_value) {
        this.oxygen_gear = value;
        this.oxygen_gearUnpowered = unpowered_value;
        return this;
    }

    public PoweredArmor setCoolingSystem(float value, float unpowered_value) {
        this.coolingsystem = value;
        this.coolingsystemUnpowered = unpowered_value;
        return this;
    }

    public PoweredArmor setWaterspeedBonus(float value, float unpowered_value) {
        this.waterspeedbonus = value;
        this.waterspeedbonusUnpowered = unpowered_value;
        return this;
    }

    public static void consumePower(ItemStack armor, int amount) {
        NBTTagCompound tags = armor.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
            armor.func_77982_d(tags);
            tags.func_74768_a("maxpower", ((PoweredArmor)armor.func_77973_b()).maxpower);
        }
        int power = tags.func_74762_e("power");
        if ((power -= amount) < 0) {
            power = 0;
        }
        tags.func_74768_a("power", power);
    }

    public static int setPowered(ItemStack armor, int max) {
        NBTTagCompound tags = armor.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
            armor.func_77982_d(tags);
            tags.func_74768_a("maxpower", ((PoweredArmor)armor.func_77973_b()).maxpower);
        }
        int power = tags.func_74762_e("power");
        int maxpower = tags.func_74762_e("maxpower");
        int missing = maxpower - power;
        if (missing > max) {
            tags.func_74768_a("power", power + max);
            return max;
        }
        tags.func_74768_a("power", maxpower);
        return missing;
    }

    protected static void setFullyPowered(ItemStack armor) {
        NBTTagCompound tags = armor.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
            armor.func_77982_d(tags);
            tags.func_74768_a("maxpower", ((PoweredArmor)armor.func_77973_b()).maxpower);
        }
        int maxpower = tags.func_74762_e("maxpower");
        tags.func_74768_a("power", maxpower);
    }

    protected static boolean hasPower(ItemStack armor) {
        return PoweredArmor.getPower(armor) > 0;
    }

    public static int getPower(ItemStack armor) {
        NBTTagCompound tags = armor.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
            armor.func_77982_d(tags);
        }
        return tags.func_74762_e("power");
    }

    protected static void powerSlots(EntityPlayer player, ArmorPowerType power, ItemStack chest, boolean consumeTick) {
        for (int i = 0; i < 4; ++i) {
            ItemStack armor = player.field_71071_by.func_70440_f(i);
            if (armor == null || !(armor.func_77973_b() instanceof PoweredArmor)) continue;
            if (i != 2) {
                if (((PoweredArmor)armor.func_77973_b()).powerType == power) {
                    int max = PoweredArmor.getPower(chest);
                    int dmg = PoweredArmor.setPowered(armor, max);
                    PoweredArmor.consumePower(chest, dmg);
                }
                if (!consumeTick) continue;
                PoweredArmor.consumePower(armor, 1);
                continue;
            }
            if (!consumeTick) continue;
            PoweredArmor.consumePower(armor, 1);
        }
    }

    public int applyPowerConsumptionOnAction(TGArmorBonus type, EntityPlayer player) {
        if (type == TGArmorBonus.JUMP) {
            if (this.field_77881_a == 2) {
                if (!player.field_70170_p.field_72995_K) {
                    player.field_70170_p.func_72956_a((Entity)player, "techguns:effects.steamarmorJump", 0.66f, 1.0f);
                }
                return 5;
            }
        } else if (type == TGArmorBonus.FALLDMG) {
            if (this.field_77881_a == 3) {
                return 5;
            }
        } else if (type == TGArmorBonus.COOLING_SYSTEM && this.field_77881_a == 1) {
            return 1;
        }
        return 0;
    }

    public static void calculateConsumptionTick(EntityPlayer player) {
        int modTick;
        boolean moving = false;
        float f = 0.001f;
        if (player.field_70159_w > (double)f || player.field_70179_y > (double)f || player.field_70159_w < (double)(-f) || player.field_70179_y < (double)(-f)) {
            moving = true;
        }
        ArmorPowerType power = null;
        ItemStack chest = player.field_71071_by.func_70440_f(2);
        if (chest != null && chest.func_77973_b() instanceof PoweredArmor) {
            power = ((PoweredArmor)chest.func_77973_b()).powerType;
        }
        PoweredArmor.powerSlots(player, power, chest, (modTick = (int)(player.field_70170_p.func_82737_E() % 20L)) == 0 && moving);
        if (chest != null && chest.func_77973_b() instanceof PoweredArmor) {
            PoweredArmor powerChest = (PoweredArmor)chest.func_77973_b();
            if (!PoweredArmor.hasPower(chest) && Techguns.consumeAmmoPlayer(player, powerChest.battery)) {
                int amount;
                if (powerChest.battery_empty != null && (amount = Techguns.addAmmoToPlayerInventory(player, TGItems.newStack(powerChest.battery_empty, 1))) > 0 && !player.field_70170_p.field_72995_K) {
                    player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, TGItems.newStack(powerChest.battery_empty, amount)));
                }
                PoweredArmor.setFullyPowered(chest);
                PoweredArmor.powerSlots(player, power, chest, false);
            }
        }
    }

    @Override
    public void func_77624_a(ItemStack item, EntityPlayer player, List list, boolean b) {
        NBTTagCompound tags = item.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
            item.func_77982_d(tags);
            tags.func_74768_a("power", 0);
            tags.func_74768_a("maxpower", ((PoweredArmor)item.func_77973_b()).maxpower);
        }
        int power = tags.func_74762_e("power");
        int maxpower = tags.func_74762_e("maxpower");
        list.add(EnumChatFormatting.AQUA + "Power: " + power + "/" + maxpower);
        if (this.field_77881_a == 1) {
            list.add(EnumChatFormatting.AQUA + "PowerType: " + this.powerType.toString() + " (" + TextUtil.trans(this.battery.func_77977_a() + ".name") + ")");
        } else {
            list.add(EnumChatFormatting.AQUA + "PowerType: " + this.powerType.toString());
        }
        super.func_77624_a(item, player, list, b);
    }

    @Override
    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        NBTTagCompound tags = stack.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
            stack.func_77982_d(tags);
        }
        tags.func_74768_a("power", 0);
        tags.func_74768_a("maxpower", this.maxpower);
    }
}

