/*
 * Decompiled with CFR 0.152.
 */
package techguns.items;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.items.GenericItem;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.util.TextUtil;
import techguns.worldgen.AlienBugNest;
import techguns.worldgen.structures.CityBuilding;
import techguns.worldgen.structures.CityBuildingType;
import techguns.worldgen.structures.Structure;

public class StructureTestTool
extends GenericItem {
    static String[] modes = new String[]{"Structure", "Camp", "Smooth", "Flatten", "Remove Junk", "Sphere", "Cylinder"};

    public StructureTestTool() {
        this.func_77625_d(1);
    }

    public boolean func_77648_a(ItemStack item, EntityPlayer player, World world, int x, int y, int z, int p_77648_7_, float p_77648_8_, float p_77648_9_, float p_77648_10_) {
        if (!item.func_77942_o()) {
            item.func_77982_d(new NBTTagCompound());
        }
        if (player.func_70093_af()) {
            int mode = 1;
            if (item.func_77978_p().func_74764_b("mode")) {
                mode = (item.func_77978_p().func_74762_e("mode") + 1) % modes.length;
            }
            item.func_77978_p().func_74768_a("mode", mode);
            if (world.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText("structure tool mode set to \"" + modes[mode] + "\"."));
            }
        } else if (item.func_77978_p().func_74764_b("x1") && item.func_77978_p().func_74764_b("y1") && item.func_77978_p().func_74764_b("z1")) {
            if (world.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText("Position2 set (" + x + "/" + y + "/" + z + ")."));
            }
            int x1 = item.func_77978_p().func_74762_e("x1");
            int y1 = item.func_77978_p().func_74762_e("y1");
            int z1 = item.func_77978_p().func_74762_e("z1");
            int sizeX = Math.abs(x1 - x) + 1;
            int sizeY = Math.abs(y1 - y) + 1;
            int sizeZ = Math.abs(z1 - z) + 1;
            if (world.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText("Size: (" + sizeX + "/" + sizeY + "/" + sizeZ + ")."));
            }
            if (!world.field_72995_K) {
                int mode = 0;
                if (item.func_77978_p().func_74764_b("mode")) {
                    mode = item.func_77978_p().func_74762_e("mode");
                }
                switch (mode) {
                    case 6: {
                        BlockUtils.fillCylinder(world, x1, y1, z1, x, y, z, 3.0f, new MBlock(TGBlocks.airMarker, 0), new MBlock(Blocks.field_150359_w, 0));
                        break;
                    }
                    default: {
                        this.doOperation(world, Math.min(x, x1), Math.min(y, y1), Math.min(z, z1), sizeX, sizeY, sizeZ, mode);
                    }
                }
            }
            item.func_77978_p().func_82580_o("x1");
            item.func_77978_p().func_82580_o("y1");
            item.func_77978_p().func_82580_o("z1");
        } else {
            item.func_77978_p().func_74768_a("x1", x);
            item.func_77978_p().func_74768_a("y1", y);
            item.func_77978_p().func_74768_a("z1", z);
            if (world.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText("Position1 set (" + x + "/" + y + "/" + z + ")."));
            }
        }
        return true;
    }

    private void doOperation(World world, int x, int y, int z, int sizeX, int sizeY, int sizeZ, int mode) {
        switch (mode) {
            case 0: {
                Random r = new Random();
                CityBuilding s = new CityBuilding(CityBuildingType.building2, 0, 0, 0, 0, 0, 0);
                ((Structure)s).setBlocks(world, x, y, z, sizeX, sizeX + sizeZ, sizeZ, r.nextInt(4), BlockUtils.BiomeColorType.WOODLAND);
                break;
            }
            case 1: {
                new AlienBugNest(x, y, z, sizeX, sizeY, sizeZ, new Random()).setBlocks(world);
                break;
            }
            case 2: {
                BlockUtils.apply2DHeightmapFilter(world, x, z, sizeX, sizeZ, BlockUtils.FILTER_GAUSSIAN_5x5);
                break;
            }
            case 3: {
                BlockUtils.flattenArea(world, x, z, sizeX, sizeZ, 2);
                break;
            }
            case 4: {
                BlockUtils.removeJunkInArea(world, x, z, sizeX, sizeZ);
                break;
            }
            case 5: {
                float radius = (float)(sizeX + sizeZ) / 4.0f;
                BlockUtils.fillSphere2(world, x + sizeX / 2, y + (int)radius + 1, z + sizeZ / 2, radius, new MBlock(TGBlocks.airMarker, 0), new MBlock(Blocks.field_150359_w, 0));
            }
        }
    }

    public void func_77624_a(ItemStack item, EntityPlayer player, List list, boolean b) {
        super.func_77624_a(item, player, list, b);
        list.add(TextUtil.trans("techguns.structureTestTool.Tooltip"));
    }
}

