/*
 * Decompiled with CFR 0.152.
 */
package techguns.inventory;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import techguns.inventory.ItemStackOreDict;
import techguns.inventory.ReactionBeamFocus;
import techguns.util.ItemUtil;

public class ReactionChamberRecipe {
    public short ID;
    public ItemStackOreDict input;
    public ReactionBeamFocus beamFocus;
    public Fluid liquidIn;
    public ArrayList<ItemStack> outputs;
    public byte ticks;
    public byte requiredCompletion;
    public byte preferredIntensity;
    public byte intensityMargin;
    public byte liquidLevel;
    public int liquidConsumtion;
    public float instability;
    public RiskType risk;
    public int RFTick;
    private static ArrayList<ReactionChamberRecipe> recipes = new ArrayList();

    public static ReactionChamberRecipe getById(short id) {
        ReactionChamberRecipe rec = recipes.get(id);
        return rec;
    }

    public static ArrayList<ReactionChamberRecipe> getRecipes() {
        return recipes;
    }

    public static void addRecipe(ItemStackOreDict input, ItemStack beamFocus, Fluid liquidIn, ItemStack output, int ticks, int requiredCompletion, int preferredIntensity, int intensityMargin, int liquidLevel, int liquidConsumtion, float instability, RiskType risk, int RFTick) {
        recipes.add(new ReactionChamberRecipe(input, beamFocus, liquidIn, output, ticks, requiredCompletion, preferredIntensity, intensityMargin, liquidLevel, (short)liquidConsumtion, instability, risk, RFTick));
    }

    public static void addRecipe(ItemStackOreDict input, ItemStack beamFocus, Fluid liquidIn, ItemStack[] outputs, int ticks, int requiredCompletion, int preferredIntensity, int intensityMargin, int liquidLevel, int liquidConsumtion, float instability, RiskType risk, int RFTick) {
        recipes.add(new ReactionChamberRecipe(input, beamFocus, liquidIn, outputs, ticks, requiredCompletion, preferredIntensity, intensityMargin, liquidLevel, (short)liquidConsumtion, instability, risk, RFTick));
    }

    private ReactionChamberRecipe(ItemStackOreDict input, ItemStack beamFocus, Fluid liquidIn, ItemStack output, int ticks, int requiredCompletion, int preferredIntensity, int intensityMargin, int liquidLevel, short liquidConsumtion, float instability, RiskType risk, int RFTick) {
        this.input = input;
        this.beamFocus = ReactionBeamFocus.getBeamFocus(beamFocus);
        this.liquidIn = liquidIn;
        this.outputs = new ArrayList();
        this.outputs.add(output);
        this.ticks = (byte)ticks;
        this.requiredCompletion = (byte)requiredCompletion;
        this.preferredIntensity = (byte)preferredIntensity;
        this.intensityMargin = (byte)intensityMargin;
        this.liquidLevel = (byte)liquidLevel;
        this.liquidConsumtion = liquidConsumtion;
        this.instability = instability;
        this.risk = risk;
        this.RFTick = RFTick;
        this.ID = (short)recipes.size();
    }

    private ReactionChamberRecipe(ItemStackOreDict input, ItemStack beamFocus, Fluid liquidIn, ItemStack[] outputs, int ticks, int requiredCompletion, int preferredIntensity, int intensityMargin, int liquidLevel, short liquidConsumtion, float instability, RiskType risk, int RFTick) {
        this.input = input;
        this.beamFocus = ReactionBeamFocus.getBeamFocus(beamFocus);
        this.liquidIn = liquidIn;
        this.outputs = new ArrayList();
        for (ItemStack item : outputs) {
            this.outputs.add(item);
        }
        this.ticks = (byte)ticks;
        this.requiredCompletion = (byte)requiredCompletion;
        this.preferredIntensity = (byte)preferredIntensity;
        this.intensityMargin = (byte)intensityMargin;
        this.liquidLevel = (byte)liquidLevel;
        this.liquidConsumtion = liquidConsumtion;
        this.instability = instability;
        this.risk = risk;
        this.RFTick = RFTick;
        this.ID = (short)recipes.size();
    }

    public static ReactionChamberRecipe getMatchingRecipe(ItemStack input, ItemStack focus, FluidStack tank, byte liquidLevel, byte intensity) {
        for (int i = 0; i < recipes.size(); ++i) {
            ReactionChamberRecipe rec = recipes.get(i);
            if (!rec.matches(input, focus, tank, liquidLevel, intensity)) continue;
            return rec;
        }
        return null;
    }

    public boolean matches(ItemStack input, ItemStack focus, FluidStack tank, byte liquidLevel, byte intensity) {
        ReactionBeamFocus f;
        return input != null && this.input.isEqualWithOreDict(input) && (f = ReactionBeamFocus.getBeamFocus(focus)) != null && f == this.beamFocus && tank != null && tank.getFluid() == this.liquidIn && liquidLevel == this.liquidLevel && tank.amount == this.liquidLevel * 1000 && intensity == this.preferredIntensity;
    }

    public short getID() {
        return this.ID;
    }

    public void addOutput(ItemStack output) {
        this.outputs.add(output);
    }

    public boolean hasResult(ItemStack result) {
        for (int i = 0; i < this.outputs.size(); ++i) {
            if (!ItemUtil.isItemEqual(result, this.outputs.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean usesItem(ItemStack itm) {
        return this.input.isEqualWithOreDict(itm);
    }

    public static enum RiskType {
        NONE,
        BREAK_ITEM,
        RAD_LOW,
        RAD_MEDIUM,
        RAD_HIGH,
        EXPLOSION_LOW,
        EXPLOSION_MEDIUM,
        EXPLOSION_HIGH,
        UNFORSEEN_CONSEQUENCES;

    }
}

