/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import techguns.TGPackets;
import techguns.damagesystem.DamageSystem;
import techguns.damagesystem.DamageType;
import techguns.damagesystem.TGDamageSource;
import techguns.entities.projectiles.GenericProjectile;
import techguns.packets.PacketSpawnParticle;
import techguns.util.EntityDeathUtils;

public class SonicShotgunProjectile
extends GenericProjectile
implements IEntityAdditionalSpawnData {
    public ArrayList<Entity> entitiesHit;
    public boolean mainProjectile = false;

    public SonicShotgunProjectile(World par2World, double posX, double posY, double posZ, float yaw, float pitch, float damage, float speed, int TTL, float spread, int dmgDropStart, int dmgDropEnd, float dmgMin, float penetration, boolean blockdamage) {
        super(par2World, posX, posY, posZ, yaw, pitch, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage);
    }

    public SonicShotgunProjectile(World par2World, double posX, double posY, double posZ, float damage, float speed, int TTL, float spread, int dmgDropStart, int dmgDropEnd, float dmgMin, float penetration, boolean blockdamage) {
        super(par2World, posX, posY, posZ, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage);
    }

    public SonicShotgunProjectile(World par2World, EntityLivingBase par3Player, float damage, float speed, int TTL, float spread, int dmgDropStart, int dmgDropEnd, float dmgMin, float penetration, boolean blockdamage) {
        super(par2World, par3Player, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage);
    }

    public SonicShotgunProjectile(World par1World) {
        super(par1World);
    }

    @Override
    protected TGDamageSource getProjectileDamageSource() {
        TGDamageSource src = new TGDamageSource("tg_sonic", this, (Entity)this.shooter, DamageType.PHYSICAL, EntityDeathUtils.DeathType.GORE);
        src.ignoreHurtresistTime = true;
        src.armorPenetration = this.penetration;
        src.setKnockback(2.0f);
        src.goreChance = 1.0f;
        return src;
    }

    @Override
    protected void onImpact(MovingObjectPosition par1MovingObjectPosition) {
        if (par1MovingObjectPosition.field_72308_g != null) {
            if (this.entitiesHit != null && !this.entitiesHit.contains(par1MovingObjectPosition.field_72308_g)) {
                TGDamageSource src = this.getProjectileDamageSource();
                TGDamageSource knockback = TGDamageSource.getKnockbackDummyDmgSrc(this, (Entity)this.shooter);
                if (par1MovingObjectPosition.field_72308_g instanceof EntityLivingBase) {
                    EntityLivingBase ent = (EntityLivingBase)par1MovingObjectPosition.field_72308_g;
                    float dmg = DamageSystem.getDamageFactor(this.shooter, ent);
                    if (dmg > 0.0f) {
                        ent.func_70097_a((DamageSource)knockback, 0.01f);
                        ent.func_70097_a((DamageSource)src, this.getDamage() * dmg);
                        this.onHitEffect(ent);
                        if (ent instanceof EntityLiving) {
                            this.setAIRevengeTarget((EntityLiving)ent);
                        }
                    }
                } else {
                    par1MovingObjectPosition.field_72308_g.func_70097_a((DamageSource)src, this.getDamage());
                }
                this.entitiesHit.add(par1MovingObjectPosition.field_72308_g);
            }
        } else if (par1MovingObjectPosition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            this.hitBlock(par1MovingObjectPosition);
            this.func_70106_y();
        }
    }

    public boolean shouldRenderInPass(int pass) {
        if (pass == 1) {
            return this.mainProjectile;
        }
        return !this.mainProjectile;
    }

    @Override
    protected void spawnImpactParticle(Material mat) {
        if (this.mainProjectile && !this.field_70170_p.field_72995_K) {
            TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle("SonicShotgunImpact", this.field_70165_t, this.field_70163_u, this.field_70161_v), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0));
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.mainProjectile);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.mainProjectile = additionalData.readBoolean();
    }
}

