/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import techguns.Techguns;
import techguns.damagesystem.TGDamageSource;
import techguns.entities.npc.NPCTurret;
import techguns.entities.projectiles.GenericProjectile;
import techguns.util.EntityDeathUtils;
import techguns.util.MathUtil;

public class MovingBeam
extends GenericProjectile
implements IEntityAdditionalSpawnData {
    public int shooterID;
    public double beamlength;
    private double distance = 0.0;

    public MovingBeam(World worldObj) {
        super(worldObj);
        this.field_70158_ak = true;
        this.lifetime = 10;
        this.ticksToLive = 10;
        if (worldObj.field_72995_K) {
            Techguns.proxy.createFXOnEntity("BeamGunMuzzleFX", this);
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (this.shooter != null) {
            buffer.writeInt(this.shooter.func_145782_y());
        } else {
            buffer.writeInt(0);
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.shooterID = additionalData.readInt();
    }

    public MovingBeam(World par2World, double posX, double posY, double posZ, float yaw, float pitch, float damage, float speed, int TTL, float spread, int dmgDropStart, int dmgDropEnd, float dmgMin, float penetration, boolean blockdamage) {
        super(par2World, posX, posY, posZ, yaw, pitch, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage);
    }

    public MovingBeam(World par2World, EntityLivingBase p, float damage, float speed, int TTL, float spread, int dmgDropStart, int dmgDropEnd, float dmgMin, float penetration, boolean blockdamage) {
        super(par2World, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage);
    }

    @Override
    protected TGDamageSource getProjectileDamageSource() {
        TGDamageSource src = TGDamageSource.causeRadiationDamage(this, (Entity)this.shooter, EntityDeathUtils.DeathType.LASER);
        src.setNoKnockback();
        src.armorPenetration = this.penetration;
        src.goreChance = 1.0f;
        return src;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    public void func_70071_h_() {
        Vec3 vec3;
        double dy;
        double dz;
        double dx;
        double targetX = 0.0;
        double targetY = 0.0;
        double targetZ = 0.0;
        float f = 100.0f;
        if (this.shooter == null) {
            this.shooter = (EntityLivingBase)this.field_70170_p.func_73045_a(this.shooterID);
        }
        if (this.shooter != null) {
            Vec3 offset;
            dx = -MathHelper.func_76126_a((float)(this.shooter.field_70759_as / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.shooter.field_70125_A / 180.0f * (float)Math.PI)) * f;
            dz = MathHelper.func_76134_b((float)(this.shooter.field_70759_as / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.shooter.field_70125_A / 180.0f * (float)Math.PI)) * f;
            dy = -MathHelper.func_76126_a((float)(this.shooter.field_70125_A / 180.0f * (float)Math.PI)) * f;
            this.field_70165_t = this.shooter.field_70165_t;
            this.field_70163_u = this.shooter.field_70163_u;
            this.field_70161_v = this.shooter.field_70161_v;
            if (Techguns.proxy.isClientPlayerAndIn1stPerson(this.shooter)) {
                offset = Vec3.func_72443_a((double)0.0, (double)-0.08, (double)0.12);
                MathUtil.rotateAroundZ(offset, (double)this.shooter.field_70125_A * (Math.PI / 180));
                MathUtil.rotateAroundY(offset, (-90.0 - (double)this.shooter.field_70759_as) * (Math.PI / 180));
                this.field_70165_t += offset.field_72450_a;
                this.field_70163_u += offset.field_72448_b;
                this.field_70161_v += offset.field_72449_c;
            } else if (this.shooter instanceof NPCTurret) {
                offset = Vec3.func_72443_a((double)0.0, (double)((double)this.shooter.func_70047_e() - (double)0.1f), (double)-0.1);
                MathUtil.rotateAroundZ(offset, (double)this.shooter.field_70125_A * (Math.PI / 180));
                MathUtil.rotateAroundY(offset, (-90.0 - (double)this.shooter.field_70759_as) * (Math.PI / 180));
                this.field_70165_t += offset.field_72450_a;
                this.field_70163_u += offset.field_72448_b;
                this.field_70161_v += offset.field_72449_c;
            } else {
                this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.shooter.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
                this.field_70163_u += (double)this.shooter.func_70047_e() - (double)0.1f;
                this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.shooter.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            }
            vec3 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            this.field_70125_A = this.shooter.field_70125_A;
            this.field_70177_z = this.shooter.field_70759_as;
        } else {
            dx = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
            dz = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
            dy = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
            vec3 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        }
        Vec3 vec31 = Vec3.func_72443_a((double)dx, (double)dy, (double)dz);
        vec31.func_72432_b();
        MovingObjectPosition movingobjectposition = MathUtil.traceVector(this.field_70170_p, vec3, vec31, 12.0, 4, this, this.shooter);
        if (movingobjectposition != null) {
            switch (movingobjectposition.field_72313_a) {
                case BLOCK: {
                    targetX = movingobjectposition.field_72307_f.field_72450_a;
                    targetY = movingobjectposition.field_72307_f.field_72448_b;
                    targetZ = movingobjectposition.field_72307_f.field_72449_c;
                    break;
                }
                case ENTITY: {
                    targetX = movingobjectposition.field_72307_f.field_72450_a;
                    targetY = movingobjectposition.field_72307_f.field_72448_b;
                    targetZ = movingobjectposition.field_72307_f.field_72449_c;
                    if (this.field_70170_p.field_72995_K) break;
                    this.distance = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v).func_72438_d(movingobjectposition.field_72307_f);
                    this.onImpact(movingobjectposition);
                    this.field_70128_L = false;
                    break;
                }
                case MISS: {
                    targetX = dx;
                    targetY = dy;
                    targetZ = dz;
                }
            }
        } else {
            targetX = dx;
            targetY = dy;
            targetZ = dz;
        }
        if (this.getParticleName() != null) {
            Techguns.proxy.createFX(this.getParticleName(), this.field_70170_p, targetX, targetY, targetZ, 0.0, 0.0, 0.0);
        }
        Vec3 pos = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        this.beamlength = pos.func_72438_d(Vec3.func_72443_a((double)targetX, (double)targetY, (double)targetZ));
        --this.ticksToLive;
        if (this.ticksToLive <= 0) {
            this.func_70106_y();
        }
    }

    @Override
    protected double getDistanceTravelled() {
        return this.distance;
    }

    private String getParticleName() {
        return "BeamGunImpactFX";
    }

    public boolean func_70067_L() {
        return false;
    }
}

