/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.damagesystem.TGDamageSource;
import techguns.entities.projectiles.GenericProjectile;
import techguns.tileentities.BioblobTileEnt;
import techguns.util.EntityDeathUtils;
import techguns.util.ProjectileExplosion;

public class BiogunProjectile
extends GenericProjectile
implements IEntityAdditionalSpawnData {
    float gravity = 0.01f;
    float speed = 0.75f;
    public int level;

    public BiogunProjectile(World par2World, EntityLivingBase player, float damage, float speed, int TTL, float spread, int dmgDropStart, int dmgDropEnd, float dmgMin, float penetration, int level, boolean blockdamage) {
        super(par2World, player, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage);
        this.field_70159_w *= (double)speed;
        this.field_70181_x *= (double)speed;
        this.field_70179_y *= (double)speed;
        this.level = level;
    }

    public BiogunProjectile(World par1World) {
        super(par1World);
        this.field_70159_w *= (double)this.speed;
        this.field_70181_x *= (double)this.speed;
        this.field_70179_y *= (double)this.speed;
    }

    @Override
    protected float getGravityVelocity() {
        return this.gravity;
    }

    @Override
    protected void onHitEffect(EntityLivingBase ent) {
        ent.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 100, 3, false));
    }

    @Override
    protected TGDamageSource getProjectileDamageSource() {
        TGDamageSource src = TGDamageSource.causePoisonDamage(this, (Entity)this.shooter, EntityDeathUtils.DeathType.BIO);
        src.goreChance = 1.0f;
        src.armorPenetration = this.penetration;
        src.setNoKnockback();
        return src;
    }

    @Override
    protected void hitBlock(MovingObjectPosition mop) {
        Block blockHit = this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
        if (blockHit == TGBlocks.bioBlobSmall) {
            TileEntity tile = this.field_70170_p.func_147438_o(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            if (tile != null && tile instanceof BioblobTileEnt) {
                ((BioblobTileEnt)tile).hitBlob(this.level, this.shooter);
            }
        } else if (!this.field_70170_p.field_72995_K) {
            int side = mop.field_72310_e;
            int[] offset = new int[]{0, 0, 0};
            if (side == 0) {
                offset[1] = -1;
            } else if (side == 1) {
                offset[1] = 1;
            } else if (side == 2) {
                offset[2] = -1;
            } else if (side == 3) {
                offset[2] = 1;
            } else if (side == 4) {
                offset[0] = -1;
            } else if (side == 5) {
                offset[0] = 1;
            }
            int[] blobPos = new int[]{mop.field_72311_b + offset[0], mop.field_72312_c + offset[1], mop.field_72309_d + offset[2]};
            if (this.field_70170_p.func_147437_c(blobPos[0], blobPos[1], blobPos[2])) {
                TileEntity tile;
                this.field_70170_p.func_147449_b(blobPos[0], blobPos[1], blobPos[2], TGBlocks.bioBlobSmall);
                if (this.level > 1 && (tile = this.field_70170_p.func_147438_o(blobPos[0], blobPos[1], blobPos[2])) != null && tile instanceof BioblobTileEnt) {
                    ((BioblobTileEnt)tile).hitBlob(this.level - 1, this.shooter);
                }
                this.field_70170_p.func_72921_c(blobPos[0], blobPos[1], blobPos[2], side, 3);
            } else {
                TileEntity tile = this.field_70170_p.func_147438_o(blobPos[0], blobPos[1], blobPos[2]);
                if (tile != null && tile instanceof BioblobTileEnt) {
                    ((BioblobTileEnt)tile).hitBlob(this.level, this.shooter);
                }
            }
        }
        this.field_70170_p.func_72869_a("slime", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
    }

    private void updateBlockLevel(int x, int y, int z, int level) {
        switch (level) {
            case 1: {
                this.field_70170_p.func_147449_b(x, y, z, TGBlocks.bioBlobSmall);
            }
        }
    }

    private void setBlockForLevel(int x, int y, int z, int level) {
        if (level == 0) {
            if (this.field_70170_p.func_147437_c(x, y + 1, z)) {
                this.updateBlockLevel(x, y + 1, z, this.level);
            }
        } else {
            int newlvl = level + this.level;
            if (newlvl > 3) {
                new ProjectileExplosion(this.field_70170_p, x, y, z, this, 1.5f, 30, 1.0f, 2.0f).doExplosion(false, this.shooter);
                this.field_70170_p.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
            } else {
                this.updateBlockLevel(x, y, z, newlvl);
            }
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound tags) {
        super.func_70037_a(tags);
    }

    @Override
    protected void func_70014_b(NBTTagCompound tags) {
        super.func_70014_b(tags);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70090_H()) {
            for (int l = 0; l < 4; ++l) {
                float f4 = 0.25f;
                this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            this.func_70106_y();
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeByte((int)((byte)this.level));
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.level = additionalData.readByte();
    }
}

