/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.TGPackets;
import techguns.damagesystem.TGDamageSource;
import techguns.entities.projectiles.GenericProjectile;
import techguns.packets.PacketSpawnParticle;
import techguns.util.EntityDeathUtils;
import techguns.util.ProjectileExplosion;

public class AlienBlasterProjectile
extends GenericProjectile {
    boolean ignite = false;
    float chanceToIgnite = 1.0f;
    int entityIgniteTime = 3;

    public AlienBlasterProjectile(World par1World) {
        super(par1World);
    }

    public AlienBlasterProjectile(World par2World, double posX, double posY, double posZ, float damage, float speed, int TTL, float spread, int dmgDropStart, int dmgDropEnd, float dmgMin, boolean ignite, float penetration, boolean blockdamage) {
        super(par2World, posX, posY, posZ, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage);
        this.ignite = ignite;
    }

    public AlienBlasterProjectile(World par2World, EntityLivingBase par3Player, float damage, float speed, int TTL, float spread, int dmgDropStart, int dmgDropEnd, float dmgMin, boolean ignite, float penetration, boolean blockdamage) {
        super(par2World, par3Player, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage);
        this.ignite = ignite;
    }

    @Override
    protected TGDamageSource getProjectileDamageSource() {
        TGDamageSource src = TGDamageSource.causeFireDamage(this, (Entity)this.shooter, EntityDeathUtils.DeathType.LASER);
        src.armorPenetration = this.penetration;
        src.goreChance = 0.5f;
        src.setNoKnockback();
        return src;
    }

    private void doExplosion() {
        if (!this.field_70170_p.field_72995_K) {
            TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle("AlienExplosion", this.field_70165_t, this.field_70163_u, this.field_70161_v), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0));
        }
        float radius = 0.5f;
        ProjectileExplosion explosion = new ProjectileExplosion(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this, radius, (int)this.getDamage(), radius * 0.5f, radius * 1.5f);
        explosion.doExplosion(false, this.shooter);
    }

    @Override
    protected void hitBlock(MovingObjectPosition mop) {
        if (this.blockdamage) {
            this.burnblock(mop, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
        }
        this.doExplosion();
    }

    @Override
    protected void onHitEffect(EntityLivingBase ent) {
        ent.func_70015_d(this.entityIgniteTime);
        this.doExplosion();
    }

    private void burnblock(MovingObjectPosition par1MovingObjectPosition, int x, int y, int z) {
        if (Math.random() <= (double)this.chanceToIgnite) {
            switch (par1MovingObjectPosition.field_72310_e) {
                case 0: {
                    if (!this.field_70170_p.func_147437_c(x, y - 1, z)) break;
                    this.field_70170_p.func_147449_b(x, y - 1, z, (Block)Blocks.field_150480_ab);
                    break;
                }
                case 1: {
                    if (!this.field_70170_p.func_147437_c(x, y + 1, z)) break;
                    if (this.field_70170_p.func_147439_a(x, y, z) == Blocks.field_150458_ak) {
                        this.field_70170_p.func_147449_b(x, y, z, Blocks.field_150346_d);
                    }
                    this.field_70170_p.func_147449_b(x, y + 1, z, (Block)Blocks.field_150480_ab);
                    break;
                }
                case 2: {
                    if (!this.field_70170_p.func_147437_c(x, y, z - 1)) break;
                    this.field_70170_p.func_147449_b(x, y, z - 1, (Block)Blocks.field_150480_ab);
                    break;
                }
                case 3: {
                    if (!this.field_70170_p.func_147437_c(x, y, z + 1)) break;
                    this.field_70170_p.func_147449_b(x, y, z + 1, (Block)Blocks.field_150480_ab);
                    break;
                }
                case 4: {
                    if (!this.field_70170_p.func_147437_c(x - 1, y, z)) break;
                    this.field_70170_p.func_147449_b(x - 1, y, z, (Block)Blocks.field_150480_ab);
                    break;
                }
                case 5: {
                    if (!this.field_70170_p.func_147437_c(x + 1, y, z)) break;
                    this.field_70170_p.func_147449_b(x + 1, y, z, (Block)Blocks.field_150480_ab);
                }
            }
            Block b = this.field_70170_p.func_147439_a(x, y, z);
            if (b == TGBlocks.camoNetRoof || b == TGBlocks.camoNetPane) {
                this.field_70170_p.func_72869_a("lava", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
                this.field_70170_p.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
            } else if (this.field_70170_p.func_147439_a(x, y - 1, z) == Blocks.field_150458_ak) {
                this.field_70170_p.func_147449_b(x, y - 1, z, Blocks.field_150346_d);
                this.field_70170_p.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
            }
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70090_H()) {
            for (int l = 0; l < 4; ++l) {
                float f4 = 0.25f;
                this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
        } else {
            float f5 = 0.1f;
            float f = 0.2f;
        }
    }
}

