/*
 * Decompiled with CFR 0.152.
 */
package techguns.damagesystem;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import techguns.damagesystem.DamageType;
import techguns.util.EntityDeathUtils;

public class TGDamageSource
extends EntityDamageSource {
    public Entity attacker = null;
    public DamageType field_76373_n;
    public EntityDeathUtils.DeathType deathType;
    public float goreChance = 0.5f;
    public float armorPenetration = 0.0f;
    public boolean ignoreHurtresistTime = false;
    public float knockbackMultiplier = 1.0f;
    public boolean wasConverted = false;
    protected static ArrayList<String> unresistableTypes = new ArrayList();

    public static TGDamageSource causeBulletDamage(Entity projectile, Entity shooter, EntityDeathUtils.DeathType deathType) {
        TGDamageSource src = new TGDamageSource("tg_bullet", projectile, shooter, DamageType.PROJECTILE, deathType);
        src.ignoreHurtresistTime = true;
        return src;
    }

    public static TGDamageSource causeExplosionDamage(Entity projectile, Entity shooter, EntityDeathUtils.DeathType deathType) {
        return new TGDamageSource("tg_explosion", projectile, shooter, DamageType.EXPLOSION, deathType);
    }

    public static TGDamageSource causePoisonDamage(Entity projectile, Entity shooter, EntityDeathUtils.DeathType deathType) {
        TGDamageSource src = new TGDamageSource("tg_poison", projectile, shooter, DamageType.POISON, deathType);
        src.ignoreHurtresistTime = true;
        return src;
    }

    public static TGDamageSource causeFireDamage(Entity projectile, Entity shooter, EntityDeathUtils.DeathType deathType) {
        TGDamageSource src = new TGDamageSource("tg_fire", projectile, shooter, DamageType.FIRE, deathType);
        src.ignoreHurtresistTime = true;
        return src;
    }

    public static TGDamageSource getKnockbackDummyDmgSrc(Entity projectile, Entity shooter) {
        return new TGDamageSource("tg_knockback", projectile, shooter, DamageType.PHYSICAL, EntityDeathUtils.DeathType.DEFAULT);
    }

    public static TGDamageSource causeEnergyDamage(Entity projectile, Entity shooter, EntityDeathUtils.DeathType deathType) {
        TGDamageSource src = new TGDamageSource("tg_energy", projectile, shooter, DamageType.ENERGY, deathType);
        src.ignoreHurtresistTime = true;
        return src;
    }

    public static TGDamageSource causeRadiationDamage(Entity projectile, Entity shooter, EntityDeathUtils.DeathType deathType) {
        TGDamageSource src = new TGDamageSource("tg_rad", projectile, shooter, DamageType.RADIATION, deathType);
        src.ignoreHurtresistTime = true;
        return src;
    }

    public static TGDamageSource causeLightningDamage(Entity projectile, Entity shooter, EntityDeathUtils.DeathType deathType) {
        TGDamageSource src = new TGDamageSource("tg_lightning", projectile, shooter, DamageType.LIGHTNING, deathType);
        src.ignoreHurtresistTime = true;
        return src;
    }

    public static TGDamageSource getFromGenericDamageSource(DamageSource src) {
        if (src instanceof TGDamageSource) {
            return (TGDamageSource)src;
        }
        return new TGDamageSource(src);
    }

    public TGDamageSource setNoKnockback() {
        this.knockbackMultiplier = 0.0f;
        return this;
    }

    public TGDamageSource setKnockback(float mult) {
        this.knockbackMultiplier = mult;
        return this;
    }

    public boolean hasKnockback() {
        return this.knockbackMultiplier > 0.0f;
    }

    public IChatComponent func_151519_b(EntityLivingBase p_151519_1_) {
        Object ichatcomponent = this.attacker == null && this.field_76386_o == null ? new ChatComponentText(p_151519_1_.func_70005_c_()) : (this.attacker == null ? this.field_76386_o.func_145748_c_() : this.attacker.func_145748_c_());
        ItemStack itemstack = this.attacker instanceof EntityLivingBase ? ((EntityLivingBase)this.attacker).func_70694_bm() : null;
        String s = "death.attack." + this.func_76355_l();
        String s1 = s + ".item";
        return itemstack != null && itemstack.func_82837_s() && StatCollector.func_94522_b((String)s1) ? new ChatComponentTranslation(s1, new Object[]{p_151519_1_.func_145748_c_(), ichatcomponent, itemstack.func_151000_E()}) : new ChatComponentTranslation(s, new Object[]{p_151519_1_.func_145748_c_(), ichatcomponent});
    }

    public TGDamageSource(String name, Entity damagingEntity, Entity attacker, DamageType damageType, EntityDeathUtils.DeathType deathType) {
        super(name, damagingEntity);
        this.attacker = attacker;
        this.field_76373_n = damageType;
        this.deathType = deathType;
        this.setBehaviourForVanilla();
    }

    public void setBehaviourForVanilla() {
        switch (this.field_76373_n) {
            case ENERGY: {
                this.func_82726_p();
                break;
            }
            case EXPLOSION: {
                this.func_94540_d();
                break;
            }
            case FIRE: {
                this.func_82726_p();
                break;
            }
            case ICE: {
                this.func_82726_p();
                break;
            }
            case LIGHTNING: {
                this.func_82726_p();
                break;
            }
            case PHYSICAL: {
                break;
            }
            case POISON: {
                this.func_82726_p();
                break;
            }
            case PROJECTILE: {
                this.func_76349_b();
                break;
            }
            case RADIATION: {
                this.func_82726_p();
                break;
            }
            case UNRESISTABLE: {
                this.func_76348_h();
                this.func_151518_m();
                break;
            }
        }
    }

    public TGDamageSource(EntityDamageSource dmg) {
        super(dmg.field_76373_n, dmg.func_76346_g());
        this.field_76386_o = dmg.func_76364_f();
        this.determineTGDamageType((DamageSource)dmg);
        this.wasConverted = true;
        if (dmg.func_76357_e()) {
            this.func_76359_i();
        }
        if (dmg.func_151517_h()) {
            this.func_151518_m();
        }
        if (dmg.func_76350_n()) {
            this.func_151518_m();
        }
        if (dmg.func_94541_c()) {
            this.func_94540_d();
        }
        if (dmg.func_76347_k()) {
            this.func_76361_j();
        }
        if (dmg.func_82725_o()) {
            this.func_82726_p();
        }
        if (dmg.func_76352_a()) {
            this.func_76349_b();
        }
        if (dmg.func_76363_c()) {
            this.func_76348_h();
        }
    }

    public TGDamageSource(DamageSource dmg) {
        super(dmg.field_76373_n, dmg.func_76364_f());
        this.field_76386_o = dmg.func_76364_f();
        this.determineTGDamageType(dmg);
        this.wasConverted = true;
        if (dmg.func_76357_e()) {
            this.func_76359_i();
        }
        if (dmg.func_151517_h()) {
            this.func_151518_m();
        }
        if (dmg.func_76350_n()) {
            this.func_151518_m();
        }
        if (dmg.func_94541_c()) {
            this.func_94540_d();
        }
        if (dmg.func_76347_k()) {
            this.func_76361_j();
        }
        if (dmg.func_82725_o()) {
            this.func_82726_p();
        }
        if (dmg.func_76352_a()) {
            this.func_76349_b();
        }
        if (dmg.func_76363_c()) {
            this.func_76348_h();
        }
    }

    private void determineTGDamageType(DamageSource dmg) {
        this.field_76373_n = dmg.func_94541_c() ? DamageType.EXPLOSION : (dmg.func_82725_o() ? DamageType.ENERGY : (dmg.func_76347_k() ? DamageType.FIRE : (dmg.func_76352_a() ? DamageType.PROJECTILE : (dmg.func_76355_l().equals("wither") ? DamageType.POISON : (dmg.func_76357_e() || unresistableTypes.contains(dmg.field_76373_n) ? DamageType.UNRESISTABLE : DamageType.PHYSICAL)))));
    }

    public Entity getAttacker() {
        return this.attacker;
    }

    public Entity func_76364_f() {
        return this.field_76386_o;
    }

    public Entity func_76346_g() {
        if (this.attacker != null) {
            return this.attacker;
        }
        return this.field_76386_o;
    }

    static {
        unresistableTypes.add("inWall");
        unresistableTypes.add("drown");
        unresistableTypes.add("starve");
        unresistableTypes.add("fall");
        unresistableTypes.add("outOfWorld");
    }
}

