/*
 * Decompiled with CFR 0.152.
 */
package techguns.damagesystem;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Random;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ISpecialArmor;
import techguns.TGConfig;
import techguns.damagesystem.DamageType;
import techguns.damagesystem.INpcTGDamageSystem;
import techguns.damagesystem.TGDamageSource;
import techguns.entities.npc.NPCTurret;
import techguns.items.armors.GenericArmor;
import techguns.util.EntityDeathUtils;
import techguns.util.MathUtil;

public class DamageSystem {
    private static Random rnd = new Random();
    private static Field ELB_EntityAge = ReflectionHelper.findField(EntityLivingBase.class, (String[])new String[]{"entityAge", "field_70708_bq"});
    private static Field ELB_lastDamage = ReflectionHelper.findField(EntityLivingBase.class, (String[])new String[]{"lastDamage", "field_110153_bc"});
    private static Field ELB_recentlyHit = ReflectionHelper.findField(EntityLivingBase.class, (String[])new String[]{"recentlyHit", "field_70718_bc"});
    private static Field ELB_attackingPlayer = ReflectionHelper.findField(EntityLivingBase.class, (String[])new String[]{"attackingPlayer", "field_70717_bb"});
    private static Method ELB_Method_setBeenAttacked = ReflectionHelper.findMethod(EntityLivingBase.class, null, (String[])new String[]{"setBeenAttacked", "func_70018_K"}, (Class[])new Class[0]);
    private static Method ELB_Method_getDeathSound = ReflectionHelper.findMethod(EntityLivingBase.class, null, (String[])new String[]{"getDeathSound", "func_70673_aS"}, (Class[])new Class[0]);
    private static Method ELB_Method_getHurtSound = ReflectionHelper.findMethod(EntityLivingBase.class, null, (String[])new String[]{"getHurtSound", "func_70621_aR"}, (Class[])new Class[0]);
    private static Method ELB_Method_getSoundVolume = ReflectionHelper.findMethod(EntityLivingBase.class, null, (String[])new String[]{"getSoundVolume", "func_70599_aP"}, (Class[])new Class[0]);
    private static Method ELB_Method_getSoundPitch = ReflectionHelper.findMethod(EntityLivingBase.class, null, (String[])new String[]{"getSoundPitch", "func_70647_i"}, (Class[])new Class[0]);
    private static Method ELB_Method_applyPotionDamageCalculations = ReflectionHelper.findMethod(EntityLivingBase.class, null, (String[])new String[]{"applyPotionDamageCalculations", "func_70672_c"}, (Class[])new Class[]{DamageSource.class, Float.TYPE});
    private static Method ELB_Method_damageArmor = ReflectionHelper.findMethod(EntityLivingBase.class, null, (String[])new String[]{"damageArmor", "func_70675_k"}, (Class[])new Class[]{Float.TYPE});

    public static float getDamageFactor(EntityLivingBase attacker, EntityLivingBase target) {
        if (attacker instanceof EntityPlayer && target instanceof EntityPlayer) {
            if (MinecraftServer.func_71276_C().func_71219_W()) {
                return TGConfig.damagePvP;
            }
            return 0.0f;
        }
        if (target instanceof EntityPlayer) {
            if (attacker instanceof NPCTurret) {
                return TGConfig.damageTurretToPlayer;
            }
            return TGConfig.damageFactorNPC;
        }
        if (attacker instanceof EntityPlayer) {
            return 1.0f;
        }
        return TGConfig.damageFactorNPC;
    }

    public static float getTotalArmorAgainstType(EntityPlayer ply, DamageType type) {
        float value = 0.0f;
        for (int i = 0; i < 4; ++i) {
            ItemStack armor = ply.field_71071_by.field_70460_b[i];
            if (armor == null) continue;
            Item item = armor.func_77973_b();
            if (item instanceof GenericArmor) {
                value += ((GenericArmor)item).getArmorValue(armor, type);
                continue;
            }
            if (!(item instanceof ItemArmor) || type != DamageType.PHYSICAL) continue;
            value += (float)((ItemArmor)item).func_82812_d().func_78044_b(((ItemArmor)item).field_77881_a);
        }
        return value;
    }

    public static float getAdditionalReduction(EntityLivingBase target, DamageType damageType) {
        if (damageType == DamageType.FIRE && target.func_70045_F()) {
            return 0.5f;
        }
        return 1.0f;
    }

    public static double getReduction(TGDamageSource src, double damage, float armorValue) {
        double damageUnblocked = damage * (double)src.armorPenetration;
        double damageBlocked = damage * (1.0 - (double)src.armorPenetration);
        damageBlocked = damage * (25.0 - (double)armorValue) * 0.04;
        return (damage - damageUnblocked - damageBlocked) / damage;
    }

    public static void damageEntity(EntityClientPlayerMP clientply, TGDamageSource dmgsrc, float damage) {
        if (!clientply.func_85032_ar()) {
            clientply.func_70606_j(clientply.func_110143_aJ() - damage);
        }
    }

    public static void damageEntityPlayer(EntityPlayer ply, TGDamageSource dmgsrc, float damage) {
        if (!ply.func_85032_ar()) {
            if ((damage = ForgeHooks.onLivingHurt((EntityLivingBase)ply, (DamageSource)dmgsrc, (float)damage)) <= 0.0f) {
                return;
            }
            if (dmgsrc.field_76373_n == DamageType.PHYSICAL && ply.func_70632_aY() && damage > 0.0f) {
                damage = (1.0f + damage) * 0.5f;
            }
            if ((damage = ISpecialArmor.ArmorProperties.ApplyArmor((EntityLivingBase)ply, (ItemStack[])ply.field_71071_by.field_70460_b, (DamageSource)dmgsrc, (double)damage)) <= 0.0f) {
                return;
            }
            try {
                damage = ((Float)ELB_Method_applyPotionDamageCalculations.invoke((Object)ply, new Object[]{dmgsrc, Float.valueOf(damage)})).floatValue();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            float f1 = damage;
            damage = Math.max(damage - ply.func_110139_bj(), 0.0f);
            ply.func_110149_m(ply.func_110139_bj() - (f1 - damage));
            if (damage != 0.0f) {
                ply.func_71020_j(dmgsrc.func_76345_d());
                float f2 = ply.func_110143_aJ();
                ply.func_70606_j(ply.func_110143_aJ() - damage);
                ply.func_110142_aN().func_94547_a((DamageSource)dmgsrc, f2, damage);
            }
        }
    }

    public static void damageEntity(EntityLivingBase elb, TGDamageSource dmgsrc, float damage) {
        if (!elb.func_85032_ar()) {
            if ((damage = ForgeHooks.onLivingHurt((EntityLivingBase)elb, (DamageSource)dmgsrc, (float)damage)) <= 0.0f) {
                return;
            }
            damage = (float)DamageSystem.getDamage(dmgsrc, damage, (Entity)elb);
            try {
                damage = ((Float)ELB_Method_applyPotionDamageCalculations.invoke((Object)elb, new Object[]{dmgsrc, Float.valueOf(damage)})).floatValue();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            float f1 = damage;
            damage = Math.max(damage - elb.func_110139_bj(), 0.0f);
            elb.func_110149_m(elb.func_110139_bj() - (f1 - damage));
            if (damage != 0.0f) {
                float f2 = elb.func_110143_aJ();
                elb.func_70606_j(f2 - damage);
                elb.func_110142_aN().func_94547_a((DamageSource)dmgsrc, f2, damage);
                elb.func_110149_m(elb.func_110139_bj() - damage);
            }
        }
    }

    public static double getDamage(TGDamageSource src, float damage, Entity ent) {
        if (ent instanceof EntityLivingBase) {
            float armor;
            EntityLivingBase target = (EntityLivingBase)ent;
            float penetration = 0.0f;
            if (src.field_76373_n == DamageType.UNRESISTABLE) {
                return damage;
            }
            if (ent instanceof INpcTGDamageSystem) {
                armor = ((INpcTGDamageSystem)ent).getTotalArmorAgainstType(src);
                penetration = MathUtil.clamp(src.armorPenetration - ((INpcTGDamageSystem)ent).getPenetrationResistance(src), 0.0f, 1.0f);
            } else {
                armor = MathUtil.clamp(target.func_70658_aO(), 0, (int)GenericArmor.MAX_ARMOR);
                armor = DamageSystem.getArmorAgainstDamageTypeDefault(target, armor, src.field_76373_n);
            }
            double damageBlocked = damage * (1.0f - penetration) * (25.0f - armor);
            try {
                ELB_Method_damageArmor.invoke((Object)ent, Float.valueOf(damage));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            double totaldmg = (double)(damage * penetration) + (damageBlocked *= 0.04);
            return totaldmg;
        }
        return damage;
    }

    public static float getArmorAgainstDamageTypeDefault(EntityLivingBase elb, float armor, DamageType damageType) {
        switch (damageType) {
            case PHYSICAL: 
            case PROJECTILE: {
                return armor;
            }
            case EXPLOSION: 
            case ENERGY: 
            case ICE: 
            case LIGHTNING: {
                return Math.round(armor * 0.5f);
            }
            case FIRE: {
                if (elb.func_70045_F()) {
                    return armor * 2.0f;
                }
                return armor * 0.5f;
            }
            case POISON: {
                return 0.0f;
            }
            case RADIATION: {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    public static void onLivingAttackEntityLivingBase(EntityLivingBase elb, DamageSource src, float damage) {
        TGDamageSource dmgsrc = TGDamageSource.getFromGenericDamageSource(src);
        if (elb.func_85032_ar()) {
            return;
        }
        if (elb.field_70170_p.field_72995_K) {
            return;
        }
        try {
            String s;
            ELB_EntityAge.setInt(elb, 0);
            if (elb.func_110143_aJ() <= 0.0f) {
                return;
            }
            if (dmgsrc.func_76347_k() && elb.func_70644_a(Potion.field_76426_n)) {
                return;
            }
            if ((dmgsrc.func_76355_l().equals(DamageSource.field_82728_o.func_76355_l()) || dmgsrc.func_76355_l().equals(DamageSource.field_82729_p.func_76355_l())) && elb.func_71124_b(4) != null) {
                elb.func_71124_b(4).func_77972_a((int)(damage * 4.0f + rnd.nextFloat() * damage * 2.0f), elb);
                damage *= 0.75f;
            }
            elb.field_70721_aZ = 1.5f;
            boolean flag = true;
            if (!dmgsrc.ignoreHurtresistTime && (float)elb.field_70172_ad > (float)elb.field_70771_an / 2.0f) {
                if (damage <= ELB_lastDamage.getFloat(elb)) {
                    return;
                }
                if (elb instanceof EntityPlayer) {
                    DamageSystem.damageEntityPlayer((EntityPlayer)elb, dmgsrc, damage);
                } else {
                    DamageSystem.damageEntity(elb, dmgsrc, damage);
                }
                ELB_lastDamage.setFloat(elb, damage);
                flag = false;
            } else {
                elb.field_70735_aL = elb.func_110143_aJ();
                if (!dmgsrc.ignoreHurtresistTime) {
                    ELB_lastDamage.setFloat(elb, damage);
                    elb.field_70172_ad = elb.field_70771_an;
                }
                if (elb instanceof EntityPlayer) {
                    DamageSystem.damageEntityPlayer((EntityPlayer)elb, dmgsrc, damage);
                } else {
                    DamageSystem.damageEntity(elb, dmgsrc, damage);
                }
                if (!dmgsrc.ignoreHurtresistTime) {
                    elb.field_70738_aO = 10;
                    elb.field_70737_aN = 10;
                }
            }
            elb.field_70739_aP = 0.0f;
            Entity entity = dmgsrc.func_76346_g();
            if (entity != null) {
                EntityTameable entitywolf;
                if (entity instanceof EntityLivingBase) {
                    elb.func_70604_c((EntityLivingBase)entity);
                }
                if (entity instanceof EntityPlayer) {
                    ELB_recentlyHit.setInt(elb, 100);
                    ELB_attackingPlayer.set(elb, (EntityPlayer)entity);
                } else if (entity instanceof EntityTameable && (entitywolf = (EntityTameable)entity).func_70909_n()) {
                    ELB_recentlyHit.setInt(elb, 100);
                    ELB_attackingPlayer.set(elb, null);
                }
            }
            if (flag) {
                elb.field_70170_p.func_72960_a((Entity)elb, (byte)2);
                if (dmgsrc != DamageSource.field_76369_e) {
                    ELB_Method_setBeenAttacked.invoke((Object)elb, new Object[0]);
                }
                if (dmgsrc.hasKnockback() && entity != null) {
                    double d1 = entity.field_70165_t - elb.field_70165_t;
                    double d0 = entity.field_70161_v - elb.field_70161_v;
                    while (d1 * d1 + d0 * d0 < 1.0E-4) {
                        d1 = (Math.random() - Math.random()) * 0.01;
                        d0 = (Math.random() - Math.random()) * 0.01;
                    }
                    elb.field_70739_aP = (float)(Math.atan2(d0, d1) * 180.0 / Math.PI) - elb.field_70177_z;
                    elb.func_70653_a(entity, damage * dmgsrc.knockbackMultiplier, d1, d0);
                } else {
                    elb.field_70739_aP = (int)(Math.random() * 2.0) * 180;
                }
            }
            if (elb.func_110143_aJ() <= 0.0f) {
                s = (String)ELB_Method_getDeathSound.invoke((Object)elb, new Object[0]);
                if (flag && s != null) {
                    float volume = ((Float)ELB_Method_getSoundVolume.invoke((Object)elb, new Object[0])).floatValue();
                    float pitch = ((Float)ELB_Method_getSoundPitch.invoke((Object)elb, new Object[0])).floatValue();
                    elb.func_85030_a(s, volume, pitch);
                }
                if (rnd.nextFloat() > dmgsrc.goreChance) {
                    dmgsrc.deathType = EntityDeathUtils.DeathType.DEFAULT;
                }
                elb.func_70645_a((DamageSource)dmgsrc);
            } else {
                s = (String)ELB_Method_getHurtSound.invoke((Object)elb, new Object[0]);
                if (flag && s != null) {
                    float volume = ((Float)ELB_Method_getSoundVolume.invoke((Object)elb, new Object[0])).floatValue();
                    float pitch = ((Float)ELB_Method_getSoundPitch.invoke((Object)elb, new Object[0])).floatValue();
                    elb.func_85030_a(s, volume, pitch);
                }
            }
            return;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void onLivingAttackPlayer(EntityPlayer player, DamageSource dmgsrc, float damage) {
        if (player.func_85032_ar()) {
            return;
        }
        if (player.field_71075_bZ.field_75102_a && !dmgsrc.func_76357_e()) {
            return;
        }
        try {
            ELB_EntityAge.setInt(player, 0);
            if (player.func_110143_aJ() <= 0.0f) {
                return;
            }
            if (player.func_70608_bn() && !player.field_70170_p.field_72995_K) {
                player.func_70999_a(true, true, false);
            }
            if (dmgsrc.func_76350_n()) {
                if (player.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
                    damage = 0.0f;
                }
                if (player.field_70170_p.field_73013_u == EnumDifficulty.EASY) {
                    damage = damage / 2.0f + 1.0f;
                }
                if (player.field_70170_p.field_73013_u == EnumDifficulty.HARD) {
                    damage = damage * 3.0f / 2.0f;
                }
            }
            if (damage == 0.0f) {
                return;
            }
            Entity entity = dmgsrc.func_76346_g();
            if (entity instanceof EntityArrow && ((EntityArrow)entity).field_70250_c != null) {
                entity = ((EntityArrow)entity).field_70250_c;
            }
            player.func_71064_a(StatList.field_75961_x, Math.round(damage * 10.0f));
            DamageSystem.onLivingAttackEntityLivingBase((EntityLivingBase)player, dmgsrc, damage);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }
}

