/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.renderer.item;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import techguns.client.ClientProxy;
import techguns.client.models.ModelMultipart;

public abstract class RenderGunMultipart
implements IItemRenderer {
    ResourceLocation texture;
    ModelMultipart model;
    float scale;
    float x;
    float y;
    float z;
    boolean handleDamageValue = false;
    boolean handleProgress = false;
    int parts;

    public RenderGunMultipart(ModelMultipart model, ResourceLocation texture, float scale, float x, float y, float z, boolean handledamage, boolean handleprogress, int parts) {
        this.parts = parts;
        this.model = model;
        this.texture = texture;
        this.scale = scale;
        this.x = x;
        this.y = y;
        this.z = z;
        this.handleDamageValue = handledamage;
        this.handleProgress = handleprogress;
    }

    protected abstract void GL_Transform_FirstPerson(int var1, float var2);

    protected abstract void GL_Transform_Equipped(int var1, float var2);

    protected abstract void GL_Transform_Ground(int var1);

    protected abstract void GL_Transform_Icon(int var1);

    protected abstract void GL_Transform_reloading(int var1, float var2);

    protected abstract void GL_Transform_reload_done(int var1);

    protected abstract void GL_Transform_firing(int var1, float var2);

    protected abstract void GL_Transform_Translate(int var1);

    protected abstract void drawMuzzleFX(float var1);

    protected void GL_TransformRecoil_Equipped(int part, float prog) {
        if (prog < 0.3f) {
            GL11.glRotatef((float)(prog / 0.3f * -30.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        boolean showMuzzleFX = false;
        float muzzleFXprogress = 0.0f;
        ClientProxy cp = ClientProxy.get();
        for (int i = 0; i < this.parts; ++i) {
            GL11.glPushMatrix();
            float reloadProgress = 10.0f;
            if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
                float prog = 0.0f;
                if (this.handleProgress) {
                    int maxdur;
                    int dur = Minecraft.func_71410_x().field_71439_g.func_71057_bx();
                    prog = (float)dur / ((float)(maxdur = 20) * 1.0f);
                    if (prog < 0.0f) {
                        prog = 0.0f;
                    } else if (prog > 1.0f) {
                        prog = 1.0f;
                    }
                }
                this.GL_Transform_FirstPerson(i, prog);
                if (cp.getplayerReloadtime((EntityLivingBase)ClientProxy.get().getPlayerClient()) > 0L) {
                    long diff = cp.getplayerReloadtime((EntityLivingBase)ClientProxy.get().getPlayerClient()) - System.currentTimeMillis();
                    if (diff <= 0L) {
                        cp.setplayerReloadtime((EntityLivingBase)ClientProxy.get().getPlayerClient(), 0L, 0, (byte)0);
                        this.GL_Transform_reload_done(i);
                    } else {
                        long reloadtimeTotal = cp.getplayerReloadtimeTotal();
                        reloadProgress = 1.0f - (float)diff / (float)reloadtimeTotal;
                        this.GL_Transform_reloading(i, reloadProgress);
                    }
                } else if (cp.getplayerRecoiltime((EntityLivingBase)ClientProxy.get().getPlayerClient()) > 0L) {
                    long diff = cp.getplayerRecoiltime((EntityLivingBase)ClientProxy.get().getPlayerClient()) - System.currentTimeMillis();
                    if (diff <= 0L || diff > cp.getplayerRecoiltimeTotal()) {
                        cp.setplayerRecoiltime((EntityLivingBase)ClientProxy.get().getPlayerClient(), 0L, 0, (byte)0);
                        this.GL_Transform_Translate(i);
                    } else {
                        float fireProgress = 1.0f - (float)diff / (float)cp.getplayerRecoiltimeTotal();
                        this.GL_Transform_firing(i, fireProgress);
                    }
                } else {
                    this.GL_Transform_Translate(i);
                    showMuzzleFX = false;
                }
                if (cp.player_muzzleFlashtime > 0L) {
                    long diff = cp.player_muzzleFlashtime - System.currentTimeMillis();
                    if (diff <= 0L || diff > cp.player_muzzleFlashtime_total) {
                        cp.player_muzzleFlashtime = 0L;
                        cp.player_muzzleFlashtime_total = 0L;
                    } else {
                        showMuzzleFX = true;
                        muzzleFXprogress = 1.0f - (float)diff / (float)cp.player_muzzleFlashtime_total;
                    }
                }
            } else if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
                EntityLivingBase shooter = (EntityLivingBase)data[1];
                float progress = 0.0f;
                if (cp.getplayerRecoiltime(shooter) > 0L) {
                    long diff = cp.getplayerRecoiltime(shooter) - System.currentTimeMillis();
                    if (diff <= 0L || diff > cp.getplayerRecoiltimeTotal(shooter)) {
                        cp.setplayerRecoiltime(shooter, 0L, 0, (byte)0);
                    } else {
                        progress = 1.0f - (float)diff / (float)cp.getplayerRecoiltimeTotal(shooter);
                    }
                }
                this.GL_Transform_Equipped(i, progress);
                this.GL_TransformRecoil_Equipped(i, progress);
            } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
                this.GL_Transform_Ground(i);
            } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
                this.GL_Transform_Icon(i);
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
            this.model.render(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, item.func_77958_k() - item.func_77960_j(), reloadProgress, type, i, 0.0f);
            GL11.glPopMatrix();
        }
        if (showMuzzleFX) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)1.5f, (float)-1.0f, (float)-0.5f);
            this.drawMuzzleFX(muzzleFXprogress);
            GL11.glPopMatrix();
        }
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }
}

