/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.renderer.item;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import techguns.client.ClientProxy;
import techguns.client.models.ModelMultipart;
import techguns.entities.npc.GenericNPC;
import techguns.entities.npc.NPCTurret;
import techguns.items.armors.ICamoChangeable;
import techguns.items.guns.GenericGun;
import techguns.items.guns.GenericGunCharge;

public abstract class RenderGunBase
implements IItemRenderer {
    ResourceLocation texture;
    ModelMultipart model;
    float scale;
    float x;
    float y;
    float z;
    boolean handleDamageValue = false;
    boolean handleProgress = false;
    boolean hasZoom = false;
    int parts;

    public RenderGunBase(ModelMultipart model, ResourceLocation texture, float scale, float x, float y, float z, boolean handledamage, boolean handleprogress, int parts, boolean hasZoom) {
        this.parts = parts;
        this.model = model;
        this.texture = texture;
        this.scale = scale;
        this.x = x;
        this.y = y;
        this.z = z;
        this.handleDamageValue = handledamage;
        this.handleProgress = handleprogress;
        this.hasZoom = hasZoom;
    }

    private boolean isZooming() {
        return this.hasZoom && ClientProxy.get().player_zoom != 1.0f;
    }

    public abstract void renderScope();

    protected abstract void GL_Transform_FirstPerson(int var1, float var2, byte var3);

    protected abstract void GL_Transform_Equipped(int var1, float var2, byte var3);

    protected abstract void GL_Transform_Ground(int var1);

    protected abstract void GL_Transform_Icon(int var1);

    protected abstract void GL_Transform_reloading(int var1, float var2, byte var3);

    protected abstract void GL_Transform_firing(int var1, float var2, byte var3);

    protected abstract void GL_Transform_Translate(int var1);

    protected abstract void drawMuzzleFX(float var1);

    protected void GL_TransformRecoil_Equipped(int part, float prog, byte attackType) {
        if (prog < 0.3f) {
            GL11.glRotatef((float)(prog / 0.3f * -30.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected abstract void GL_TransformReload_Equipped(int var1, float var2, byte var3);

    protected void transformEquippedAimedRotation(int part) {
        GL11.glRotated((double)-45.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)-18.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)45.0, (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.transformEquippedAimed(part);
        GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
    }

    protected void transformEquippedAimed(int part) {
        GL11.glTranslatef((float)0.0f, (float)-1.3f, (float)-0.4f);
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        boolean showMuzzleFX = false;
        float muzzleFXprogress = 0.0f;
        boolean renderScope = false;
        boolean reloading = false;
        ClientProxy cp = ClientProxy.get();
        float prog = 0.0f;
        byte attackType = 0;
        for (int i = 0; i < this.parts; ++i) {
            long diff;
            prog = 0.0f;
            attackType = 0;
            GL11.glPushMatrix();
            float reloadProgress = 10.0f;
            if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
                attackType = cp.getplayerAttackType((EntityLivingBase)data[1]);
                if (this.handleProgress && Minecraft.func_71410_x().field_71439_g.func_71011_bu() != null) {
                    int dur = Minecraft.func_71410_x().field_71439_g.func_71057_bx();
                    prog = item.func_77973_b() instanceof GenericGunCharge ? (float)dur / ((GenericGunCharge)item.func_77973_b()).fullChargeTime : (float)dur / 20.0f;
                    if (prog < 0.0f) {
                        prog = 0.0f;
                    } else if (prog > 1.0f) {
                        prog = 1.0f;
                    }
                }
                this.GL_Transform_FirstPerson(i, prog, attackType);
                if (cp.getplayerReloadtime((EntityLivingBase)ClientProxy.get().getPlayerClient()) > 0L) {
                    long diff2 = cp.getplayerReloadtime((EntityLivingBase)ClientProxy.get().getPlayerClient()) - System.currentTimeMillis();
                    if (diff2 <= 0L) {
                        cp.setplayerReloadtime((EntityLivingBase)ClientProxy.get().getPlayerClient(), 0L, 0, (byte)0);
                        this.GL_Transform_Translate(i);
                    } else {
                        long reloadtimeTotal = cp.getplayerReloadtimeTotal();
                        reloadProgress = 1.0f - (float)diff2 / (float)reloadtimeTotal;
                        this.GL_Transform_reloading(i, reloadProgress, attackType);
                    }
                } else if (cp.getplayerRecoiltime((EntityLivingBase)ClientProxy.get().getPlayerClient()) > 0L) {
                    if (!this.isZooming()) {
                        long diff3 = cp.getplayerRecoiltime((EntityLivingBase)ClientProxy.get().getPlayerClient()) - System.currentTimeMillis();
                        if (diff3 <= 0L || diff3 > cp.getplayerRecoiltimeTotal()) {
                            cp.setplayerRecoiltime((EntityLivingBase)ClientProxy.get().getPlayerClient(), 0L, 0, (byte)0);
                            this.GL_Transform_Translate(i);
                        } else {
                            float fireProgress = 1.0f - (float)diff3 / (float)cp.getplayerRecoiltimeTotal();
                            this.GL_Transform_firing(i, fireProgress, attackType);
                            prog = fireProgress;
                        }
                    } else {
                        renderScope = true;
                    }
                } else if (!this.isZooming()) {
                    this.GL_Transform_Translate(i);
                    showMuzzleFX = false;
                } else {
                    renderScope = true;
                }
                if (cp.player_muzzleFlashtime > 0L) {
                    long diff4 = cp.player_muzzleFlashtime - System.currentTimeMillis();
                    if (diff4 <= 0L || diff4 > cp.player_muzzleFlashtime_total) {
                        cp.player_muzzleFlashtime = 0L;
                        cp.player_muzzleFlashtime_total = 0L;
                    } else {
                        showMuzzleFX = true;
                        muzzleFXprogress = 1.0f - (float)diff4 / (float)cp.player_muzzleFlashtime_total;
                    }
                }
            } else if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
                boolean aimed;
                EntityLivingBase shooter = (EntityLivingBase)data[1];
                attackType = cp.getplayerAttackType(shooter);
                prog = 0.0f;
                if (cp.getplayerReloadtime(shooter) > 0L) {
                    long diff5 = cp.getplayerReloadtime(shooter) - System.currentTimeMillis();
                    if (diff5 <= 0L) {
                        cp.setplayerReloadtime(shooter, 0L, 0, (byte)0);
                    } else {
                        long reloadtimeTotal = cp.getplayerReloadtimeTotal(shooter);
                        reloadProgress = 1.0f - (float)diff5 / (float)reloadtimeTotal;
                        reloading = true;
                    }
                } else if (cp.getplayerRecoiltime(shooter) > 0L) {
                    long diff6 = cp.getplayerRecoiltime(shooter) - System.currentTimeMillis();
                    if (diff6 <= 0L || diff6 > cp.getplayerRecoiltimeTotal(shooter)) {
                        cp.setplayerRecoiltime(shooter, 0L, 0, (byte)0);
                    } else {
                        prog = 1.0f - (float)diff6 / (float)cp.getplayerRecoiltimeTotal(shooter);
                    }
                }
                boolean bl = aimed = shooter instanceof EntityPlayer || shooter instanceof GenericNPC && ((GenericNPC)shooter).getHasAimedBowAnim();
                if (aimed) {
                    this.transformEquippedAimedRotation(i);
                }
                this.GL_Transform_Equipped(i, prog, attackType);
                if (shooter instanceof NPCTurret) {
                    prog = 0.0f;
                }
                if (reloading) {
                    this.GL_TransformReload_Equipped(i, reloadProgress, attackType);
                } else {
                    this.GL_TransformRecoil_Equipped(i, prog, attackType);
                }
            } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
                this.GL_Transform_Ground(i);
            } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
                this.GL_Transform_Icon(i);
            }
            if (!renderScope) {
                int camo = 0;
                if (item.func_77973_b() instanceof ICamoChangeable) {
                    ICamoChangeable camoitem = (ICamoChangeable)item.func_77973_b();
                    camo = (byte)camoitem.getCurrentCamoIndex(item);
                }
                ResourceLocation tex = ((GenericGun)item.func_77973_b()).textures.get(camo);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(tex);
                if (this.handleDamageValue) {
                    this.model.render(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, ((GenericGun)item.func_77973_b()).getCurrentAmmo(item), reloadProgress, type, i, prog);
                } else {
                    this.model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                }
                GL11.glPopMatrix();
                if (i != this.parts - 1) continue;
                if (showMuzzleFX) {
                    GL11.glPushMatrix();
                    GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)1.5f, (float)-1.0f, (float)-0.5f);
                    this.drawMuzzleFX(muzzleFXprogress);
                    GL11.glPopMatrix();
                }
                if (type != IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) continue;
                GL11.glPushMatrix();
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)1.5f, (float)-1.0f, (float)-0.5f);
                this.drawExtraEffects();
                GL11.glPopMatrix();
                continue;
            }
            GL11.glPopMatrix();
            if (i != 0) continue;
            GL11.glPushMatrix();
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            if (cp.getplayerRecoiltime((EntityLivingBase)ClientProxy.get().getPlayerClient()) > 0L && (diff = cp.getplayerRecoiltime((EntityLivingBase)ClientProxy.get().getPlayerClient()) - System.currentTimeMillis()) > 0L && diff <= cp.getplayerRecoiltimeTotal()) {
                float fireProgress = 1.0f - (float)diff / (float)cp.getplayerRecoiltimeTotal();
                float recoil = fireProgress < 0.2f ? fireProgress * 5.0f : 1.0f - (fireProgress - 0.2f) * 1.25f;
                this.translateScopeRecoil(recoil);
            }
            this.renderScope();
            GL11.glPopMatrix();
        }
    }

    public void translateScopeRecoil(float recoil) {
        GL11.glTranslatef((float)(0.2f * recoil), (float)(0.25f * recoil), (float)(0.1f * recoil));
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    protected void drawExtraEffects() {
    }
}

