/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.renderer.death;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelQuadruped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.client.renderer.tileentity.TileEntitySkullRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;
import techguns.client.renderer.TGRenderHelper;
import techguns.util.EntityDeathUtils;
import techguns.util.MathUtil;

public class RendererDeadLivingEntity {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final ResourceLocation RES_BIO_EFFECT = new ResourceLocation("techguns", "textures/fx/bio.png");
    private static final ResourceLocation RES_LASER_EFFECT = new ResourceLocation("techguns", "textures/fx/laserDeathfx.png");
    private static final int MAX_DEATH_TIME = 20;
    private static Field R_mainModel = ReflectionHelper.findField(RendererLivingEntity.class, (String[])new String[]{"mainModel", "field_77045_g"});
    private static Field R_renderPassModel = ReflectionHelper.findField(RendererLivingEntity.class, (String[])new String[]{"renderPassModel", "field_77046_h"});
    private static Field R_renderManager = ReflectionHelper.findField(Render.class, (String[])new String[]{"renderManager", "field_76990_c"});
    private static Method R_shouldRenderPass = ReflectionHelper.findMethod(RendererLivingEntity.class, null, (String[])new String[]{"shouldRenderPass", "func_77032_a"}, (Class[])new Class[]{EntityLivingBase.class, Integer.TYPE, Float.TYPE});
    private static Method R_bindTexture = ReflectionHelper.findMethod(Render.class, null, (String[])new String[]{"bindTexture", "func_110776_a"}, (Class[])new Class[]{ResourceLocation.class});
    private static Method R_renderEquippedItems = ReflectionHelper.findMethod(RendererLivingEntity.class, null, (String[])new String[]{"renderEquippedItems", "func_77029_c"}, (Class[])new Class[]{EntityLivingBase.class, Float.TYPE});
    private static Method R_getColorMultiplier = ReflectionHelper.findMethod(RendererLivingEntity.class, null, (String[])new String[]{"getColorMultiplier", "func_77030_a"}, (Class[])new Class[]{EntityLivingBase.class, Float.TYPE, Float.TYPE});
    private static Method R_inheritRenderPass = ReflectionHelper.findMethod(RendererLivingEntity.class, null, (String[])new String[]{"inheritRenderPass", "func_77035_b"}, (Class[])new Class[]{EntityLivingBase.class, Integer.TYPE, Float.TYPE});
    private static Method R_bindEntityTexture = ReflectionHelper.findMethod(Render.class, null, (String[])new String[]{"bindEntityTexture", "func_110777_b"}, (Class[])new Class[]{Entity.class});

    public static void setRenderScalingForEntity(EntityLivingBase elb) {
        if (elb instanceof EntitySlime) {
            EntitySlime slime = (EntitySlime)elb;
            int size = slime.func_70809_q();
            GL11.glScalef((float)size, (float)size, (float)size);
            if (size == 2) {
                GL11.glTranslatef((float)0.0f, (float)-0.8f, (float)0.0f);
            } else if (size == 4) {
                GL11.glTranslatef((float)0.0f, (float)-1.2f, (float)0.0f);
            }
        }
    }

    public static void doRender(RendererLivingEntity renderer, EntityLivingBase entity, double x, double y, double z, float ptt, EntityDeathUtils.DeathType deathType) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        ModelBase mainModel = null;
        ModelBase renderPassModel = null;
        try {
            mainModel = (ModelBase)R_mainModel.get(renderer);
            renderPassModel = (ModelBase)R_renderPassModel.get(renderer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        mainModel.field_78091_s = entity.func_70631_g_();
        if (renderPassModel != null) {
            renderPassModel.field_78091_s = mainModel.field_78091_s;
        }
        try {
            float f2 = MathUtil.interpolateRotation(entity.field_70760_ar, entity.field_70761_aq, ptt);
            float f3 = MathUtil.interpolateRotation(entity.field_70758_at, entity.field_70759_as, ptt);
            float f13 = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * ptt;
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            float f4 = (float)entity.field_70173_aa + ptt;
            float f5 = 0.0625f;
            GL11.glEnable((int)32826);
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)(-24.0f * f5 - 0.0078125f), (float)0.0f);
            float f6 = entity.field_70722_aY + (entity.field_70721_aZ - entity.field_70722_aY) * ptt;
            float f7 = entity.field_70754_ba - entity.field_70721_aZ * (1.0f - ptt);
            if (entity.func_70631_g_()) {
                f7 *= 3.0f;
            }
            if (f6 > 1.0f) {
                f6 = 1.0f;
            }
            GL11.glEnable((int)3008);
            switch (deathType) {
                case BIO: {
                    mainModel.func_78086_a(entity, f7, f6, ptt);
                    RendererDeadLivingEntity.renderModelDeathBio(renderer, entity, f7, f6, f4, f3 - f2, f13, f5);
                    break;
                }
                case LASER: {
                    mainModel.func_78086_a(entity, f7, f6, ptt);
                    RendererDeadLivingEntity.renderModelDeathLaser(renderer, entity, f7, f6, f4, f3 - f2, f13, f5);
                    break;
                }
                case DISMEMBER: {
                    mainModel.func_78086_a(entity, f7, f6, ptt);
                    RendererDeadLivingEntity.renderModelDeathDismember(renderer, entity, f7, f6, f4, f3 - f2, f13, f5, ptt);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glEnable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
    }

    static void renderModelDeathBio(RendererLivingEntity renderer, EntityLivingBase entity, float f7, float f6, float f4, float p_77036_5_, float f13, float f5) {
        ModelRenderer box;
        float prog = (float)entity.field_70725_aQ / 20.0f;
        Random rand = new Random(entity.func_145782_y());
        ResourceLocation texture = RES_BIO_EFFECT;
        TGRenderHelper.RenderType renderType = TGRenderHelper.RenderType.ADDITIVE;
        ModelBase mainModel = null;
        RenderManager renderManager = null;
        try {
            mainModel = (ModelBase)R_mainModel.get(renderer);
            renderManager = (RenderManager)R_renderManager.get(renderer);
            ModelBase renderPassModel = (ModelBase)R_renderPassModel.get(renderer);
            R_bindEntityTexture.invoke((Object)renderer, entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (mainModel instanceof ModelBiped) {
            ((ModelBiped)mainModel).func_78087_a(f7, f6, f4, p_77036_5_, f13, f5, (Entity)entity);
        }
        HashSet childBoxes = new HashSet(64);
        for (Object o : mainModel.field_78092_r) {
            box = (ModelRenderer)o;
            if (box.field_78805_m == null) continue;
            childBoxes.addAll(box.field_78805_m);
        }
        GL11.glPushMatrix();
        GL11.glRotated((double)entity.field_70177_z, (double)0.0, (double)1.0, (double)0.0);
        RendererDeadLivingEntity.setRenderScalingForEntity(entity);
        for (Object o : mainModel.field_78092_r) {
            box = (ModelRenderer)o;
            if (childBoxes.contains(box) || box.field_78807_k || !box.field_78806_j) continue;
            float scale = 1.0f + rand.nextFloat() * prog;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(-box.field_82906_o), (float)(-box.field_82908_p), (float)(-box.field_82907_q));
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glTranslatef((float)box.field_82906_o, (float)box.field_82908_p, (float)box.field_82907_q);
            double mainColor = 1.0 - Math.pow(prog, 2.0);
            double mainAlpha = Math.pow(1.0 - (double)prog, 2.0);
            GL11.glColor4d((double)mainColor, (double)1.0, (double)mainColor, (double)mainAlpha);
            box.func_78785_a(f5);
            renderManager.field_78724_e.func_110577_a(RES_BIO_EFFECT);
            TGRenderHelper.enableBlendMode(renderType);
            double overlayColor = 0.5 + Math.sin((Math.sqrt(prog) + 0.75) * 2.0 * Math.PI) / 2.0;
            GL11.glColor3d((double)overlayColor, (double)overlayColor, (double)overlayColor);
            box.func_78785_a(f5);
            TGRenderHelper.disableBlendMode(renderType);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    static void renderModelDeathLaser(RendererLivingEntity renderer, EntityLivingBase entity, float f7, float f6, float f4, float p_77036_5_, float f13, float f5) {
        float prog = (float)entity.field_70725_aQ / 20.0f;
        Random rand = new Random(entity.func_145782_y());
        TGRenderHelper.RenderType renderType = TGRenderHelper.RenderType.ADDITIVE;
        ModelBase mainModel = null;
        RenderManager renderManager = null;
        try {
            mainModel = (ModelBase)R_mainModel.get(renderer);
            renderManager = (RenderManager)R_renderManager.get(renderer);
            R_bindEntityTexture.invoke((Object)renderer, entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (mainModel instanceof ModelBiped) {
            ((ModelBiped)mainModel).func_78087_a(f7, f6, f4, p_77036_5_, f13, f5, (Entity)entity);
        }
        HashSet childBoxes = new HashSet(64);
        for (Object o : mainModel.field_78092_r) {
            ModelRenderer box = (ModelRenderer)o;
            if (box.field_78805_m == null) continue;
            childBoxes.addAll(box.field_78805_m);
        }
        GL11.glPushMatrix();
        GL11.glRotated((double)entity.field_70177_z, (double)0.0, (double)1.0, (double)0.0);
        RendererDeadLivingEntity.setRenderScalingForEntity(entity);
        GL11.glPushMatrix();
        double mainColor = 1.0 - Math.pow(prog, 2.0);
        double mainAlpha = Math.pow(1.0 - (double)prog, 2.0);
        GL11.glColor4d((double)1.0, (double)mainColor, (double)mainColor, (double)mainAlpha);
        mainModel.func_78088_a((Entity)entity, f7, f6, f4, p_77036_5_, f13, f5);
        renderManager.field_78724_e.func_110577_a(RES_LASER_EFFECT);
        TGRenderHelper.enableBlendMode(renderType);
        double overlayColor = 0.5 + Math.sin((Math.sqrt(prog) + 0.75) * 2.0 * Math.PI) / 2.0;
        GL11.glColor3d((double)overlayColor, (double)overlayColor, (double)overlayColor);
        mainModel.func_78088_a((Entity)entity, f7, f6, f4, p_77036_5_, f13, f5);
        TGRenderHelper.disableBlendMode(renderType);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    static void renderModelDeathDismember(RendererLivingEntity renderer, EntityLivingBase entity, float f7, float f6, float f4, float p_77036_5_, float f13, float f5, float ptt) {
        float prog = ((float)entity.field_70725_aQ - ptt) / 20.0f;
        Random rand = new Random(entity.func_145782_y());
        ResourceLocation texture = RES_BIO_EFFECT;
        TGRenderHelper.RenderType renderType = TGRenderHelper.RenderType.ADDITIVE;
        ModelBase mainModel = null;
        RenderManager renderManager = null;
        try {
            mainModel = (ModelBase)R_mainModel.get(renderer);
            renderManager = (RenderManager)R_renderManager.get(renderer);
            ModelBase renderPassModel = (ModelBase)R_renderPassModel.get(renderer);
            R_bindEntityTexture.invoke((Object)renderer, entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GL11.glPushMatrix();
        GL11.glRotated((double)entity.field_70177_z, (double)0.0, (double)1.0, (double)0.0);
        RendererDeadLivingEntity.setRenderScalingForEntity(entity);
        if (mainModel instanceof ModelBiped) {
            GL11.glPushMatrix();
            RendererDeadLivingEntity.GLTransformDeath_Body(prog, entity, 1.0, 0.0, 0.0);
            ModelBiped modelBiped = (ModelBiped)mainModel;
            modelBiped.func_78087_a(f7, f6, f4, p_77036_5_, f13, f5, (Entity)entity);
            modelBiped.field_78115_e.func_78785_a(f5);
            modelBiped.field_78113_g.func_78785_a(f5);
            modelBiped.field_78112_f.func_78785_a(f5);
            modelBiped.field_78124_i.func_78785_a(f5);
            modelBiped.field_78123_h.func_78785_a(f5);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            RendererDeadLivingEntity.GLTransformDeath_Head(prog, entity, rand, modelBiped.field_78116_c);
            modelBiped.field_78116_c.func_78785_a(f5);
            GL11.glPopMatrix();
        } else if (mainModel instanceof ModelQuadruped) {
            GL11.glPushMatrix();
            RendererDeadLivingEntity.GLTransformDeath_Body(prog, entity, 0.0, 0.0, 1.0);
            ModelQuadruped modelQ = (ModelQuadruped)mainModel;
            modelQ.func_78087_a(f7, f6, f4, p_77036_5_, f13, f5, (Entity)entity);
            modelQ.field_78148_b.func_78785_a(f5);
            modelQ.field_78149_c.func_78785_a(f5);
            modelQ.field_78146_d.func_78785_a(f5);
            modelQ.field_78147_e.func_78785_a(f5);
            modelQ.field_78144_f.func_78785_a(f5);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            RendererDeadLivingEntity.GLTransformDeath_Head(prog, entity, rand, modelQ.field_78150_a);
            modelQ.field_78150_a.func_78785_a(f5);
            GL11.glPopMatrix();
        } else {
            ModelRenderer box;
            HashSet childBoxes = new HashSet(64);
            for (Object o : mainModel.field_78092_r) {
                box = (ModelRenderer)o;
                if (box.field_78805_m == null) continue;
                childBoxes.addAll(box.field_78805_m);
            }
            System.out.println("boxes.size = " + childBoxes.size());
            for (Object o : mainModel.field_78092_r) {
                box = (ModelRenderer)o;
                if (childBoxes.contains(box) || box.field_78807_k || !box.field_78806_j) continue;
                box.func_78785_a(f5);
            }
        }
        GL11.glPopMatrix();
    }

    static void GLTransformDeath_Body(float prog, EntityLivingBase entity, double xdir, double ydir, double zdir) {
        double p = Math.min(1.0, (double)prog * 2.0);
        double y = Math.sin(p * Math.PI);
        double y2 = (1.0 - Math.cos(p * Math.PI)) * 0.5;
        GL11.glTranslated((double)0.0, (double)((double)entity.field_70131_O * 0.75), (double)0.0);
        GL11.glRotated((double)(-90.0 * y2), (double)xdir, (double)ydir, (double)zdir);
        GL11.glTranslated((double)0.0, (double)((double)(-entity.field_70131_O) * 0.75), (double)0.0);
        GL11.glTranslated((double)0.0, (double)(0.25 * y), (double)0.0);
    }

    static void GLTransformDeath_Head(float prog, EntityLivingBase entity, Random rand, ModelRenderer head) {
        double p = Math.min(1.0, (double)prog * 2.0);
        double a = Math.sin(p * Math.PI);
        double a2 = (1.0 - Math.cos(p * Math.PI)) * 0.5;
        double x1 = -1.0;
        double x2 = -1.0;
        double y1 = -1.0;
        double y2 = -1.0;
        double z1 = -1.0;
        double z2 = -1.0;
        for (Object b : head.field_78804_l) {
            ModelBox box = (ModelBox)b;
            if (x1 == -1.0 || (double)box.field_78252_a < x1) {
                x1 = box.field_78252_a;
            }
            if (x2 == -1.0 || (double)box.field_78248_d > x2) {
                x2 = box.field_78248_d;
            }
            if (y1 == -1.0 || (double)box.field_78250_b < y1) {
                y1 = box.field_78250_b;
            }
            if (y2 == -1.0 || (double)box.field_78249_e > y2) {
                y2 = box.field_78249_e;
            }
            if (z1 == -1.0 || (double)box.field_78251_c < z1) {
                z1 = box.field_78251_c;
            }
            if (z2 != -1.0 && !((double)box.field_78246_f > z2)) continue;
            z2 = box.field_78246_f;
        }
        double d = 0.0625;
        double offsetX = (x1 + (x2 - x1) * 0.5) * d;
        double offsetY = (y1 + (y2 - y1) * 0.5) * d;
        double offsetZ = (z1 + (z2 - z1) * 0.5) * d;
        GL11.glTranslated((double)offsetX, (double)offsetY, (double)offsetZ);
        GL11.glRotated((double)(360.0f * prog), (double)rand.nextDouble(), (double)rand.nextDouble(), (double)rand.nextDouble());
        GL11.glTranslated((double)(-offsetX), (double)(-offsetY), (double)(-offsetZ));
    }

    static void renderModel(RendererLivingEntity renderer, EntityLivingBase entity, float f7, float f6, float f4, float p_77036_5_, float f13, float f5, ResourceLocation texture, TGRenderHelper.RenderType renderType) {
        ModelBase mainModel = null;
        RenderManager renderManager = null;
        try {
            mainModel = (ModelBase)R_mainModel.get(renderer);
            renderManager = (RenderManager)R_renderManager.get(renderer);
            ModelBase renderPassModel = (ModelBase)R_renderPassModel.get(renderer);
            if (texture != null) {
                renderManager.field_78724_e.func_110577_a(RES_BIO_EFFECT);
            } else {
                R_bindEntityTexture.invoke((Object)renderer, entity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TGRenderHelper.enableBlendMode(renderType);
        if (!entity.func_82150_aj()) {
            mainModel.func_78088_a((Entity)entity, f7, f6, f4, p_77036_5_, f13, f5);
        } else if (!entity.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
            GL11.glDepthMask((boolean)false);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glAlphaFunc((int)516, (float)0.003921569f);
            mainModel.func_78088_a((Entity)entity, f7, f6, f4, p_77036_5_, f13, f5);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glPopMatrix();
            GL11.glDepthMask((boolean)true);
        } else {
            mainModel.func_78087_a(f7, f6, f4, p_77036_5_, f13, f5, (Entity)entity);
        }
        TGRenderHelper.disableBlendMode(renderType);
    }

    static void renderExtraPasses(RendererLivingEntity renderer, EntityLivingBase entity, float f7, float f6, float f4, float f3f2, float f13, float f5, float ptt) {
        ModelBase mainModel = null;
        ModelBase renderPassModel = null;
        try {
            mainModel = (ModelBase)R_mainModel.get(renderer);
            renderPassModel = (ModelBase)R_renderPassModel.get(renderer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            float f10;
            float f9;
            float f8;
            int j = 0;
            for (int i = 0; i < 4; ++i) {
                try {
                    j = (Integer)R_shouldRenderPass.invoke((Object)renderer, entity, i, Float.valueOf(ptt));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (j <= 0) continue;
                renderPassModel.func_78086_a(entity, f7, f6, ptt);
                renderPassModel.func_78088_a((Entity)entity, f7, f6, f4, f3f2, f13, f5);
                if ((j & 0xF0) == 16) {
                    renderPassModel.func_78088_a((Entity)entity, f7, f6, f4, f3f2, f13, f5);
                }
                if ((j & 0xF) == 15) {
                    f8 = (float)entity.field_70173_aa + ptt;
                    try {
                        R_bindTexture.invoke((Object)renderer, RES_ITEM_GLINT);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    GL11.glEnable((int)3042);
                    f9 = 0.5f;
                    GL11.glColor4f((float)f9, (float)f9, (float)f9, (float)1.0f);
                    GL11.glDepthFunc((int)514);
                    GL11.glDepthMask((boolean)false);
                    for (int k = 0; k < 2; ++k) {
                        GL11.glDisable((int)2896);
                        f10 = 0.76f;
                        GL11.glColor4f((float)(0.5f * f10), (float)(0.25f * f10), (float)(0.8f * f10), (float)1.0f);
                        GL11.glBlendFunc((int)768, (int)1);
                        GL11.glMatrixMode((int)5890);
                        GL11.glLoadIdentity();
                        float f11 = f8 * (0.001f + (float)k * 0.003f) * 20.0f;
                        float f12 = 0.33333334f;
                        GL11.glScalef((float)f12, (float)f12, (float)f12);
                        GL11.glRotatef((float)(30.0f - (float)k * 60.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glTranslatef((float)0.0f, (float)f11, (float)0.0f);
                        GL11.glMatrixMode((int)5888);
                        renderPassModel.func_78088_a((Entity)entity, f7, f6, f4, f3f2, f13, f5);
                    }
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glMatrixMode((int)5890);
                    GL11.glDepthMask((boolean)true);
                    GL11.glLoadIdentity();
                    GL11.glMatrixMode((int)5888);
                    GL11.glEnable((int)2896);
                    GL11.glDisable((int)3042);
                    GL11.glDepthFunc((int)515);
                }
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3008);
            }
            GL11.glDepthMask((boolean)true);
            try {
                R_renderEquippedItems.invoke((Object)renderer, entity, Float.valueOf(ptt));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            float f14 = entity.func_70013_c(ptt);
            try {
                j = (Integer)R_getColorMultiplier.invoke((Object)renderer, entity, Float.valueOf(f14), Float.valueOf(ptt));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
            GL11.glDisable((int)3553);
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
            if ((j >> 24 & 0xFF) > 0 || entity.field_70737_aN > 0 || entity.field_70725_aQ > 0) {
                GL11.glDisable((int)3553);
                GL11.glDisable((int)3008);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glDepthFunc((int)514);
                if (entity.field_70737_aN > 0 || entity.field_70725_aQ > 0) {
                    GL11.glColor4f((float)f14, (float)0.0f, (float)0.0f, (float)0.4f);
                    mainModel.func_78088_a((Entity)entity, f7, f6, f4, f3f2, f13, f5);
                    for (int l = 0; l < 4; ++l) {
                        int iRP = 0;
                        try {
                            iRP = (Integer)R_inheritRenderPass.invoke((Object)renderer, entity, l, Float.valueOf(ptt));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (iRP < 0) continue;
                        GL11.glColor4f((float)f14, (float)0.0f, (float)0.0f, (float)0.4f);
                        renderPassModel.func_78088_a((Entity)entity, f7, f6, f4, f3f2, f13, f5);
                    }
                }
                if ((j >> 24 & 0xFF) > 0) {
                    f8 = (float)(j >> 16 & 0xFF) / 255.0f;
                    f9 = (float)(j >> 8 & 0xFF) / 255.0f;
                    float f15 = (float)(j & 0xFF) / 255.0f;
                    f10 = (float)(j >> 24 & 0xFF) / 255.0f;
                    GL11.glColor4f((float)f8, (float)f9, (float)f15, (float)f10);
                    mainModel.func_78088_a((Entity)entity, f7, f6, f4, f3f2, f13, f5);
                    for (int i1 = 0; i1 < 4; ++i1) {
                        int iRP = 0;
                        try {
                            iRP = (Integer)R_inheritRenderPass.invoke((Object)renderer, entity, i1, Float.valueOf(ptt));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (iRP < 0) continue;
                        GL11.glColor4f((float)f8, (float)f9, (float)f15, (float)f10);
                        renderPassModel.func_78088_a((Entity)entity, f7, f6, f4, f3f2, f13, f5);
                    }
                }
                GL11.glDepthFunc((int)515);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)3553);
            }
            GL11.glDisable((int)32826);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void biped_renderEquippedItems(RendererLivingEntity renderer, RenderManager renderManager, ModelBiped modelBipedMain, EntityLiving p_77029_1_, float p_77029_2_) {
        float f1;
        boolean is3D;
        IItemRenderer customRenderer;
        Item item;
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        ItemStack itemstack = p_77029_1_.func_70694_bm();
        ItemStack itemstack1 = p_77029_1_.func_130225_q(3);
        if (itemstack1 != null) {
            GL11.glPushMatrix();
            modelBipedMain.field_78116_c.func_78794_c(0.0625f);
            item = itemstack1.func_77973_b();
            customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)itemstack1, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.EQUIPPED);
            boolean bl = is3D = customRenderer != null && customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.EQUIPPED, itemstack1, IItemRenderer.ItemRendererHelper.BLOCK_3D);
            if (item instanceof ItemBlock) {
                if (is3D || RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)item).func_149645_b())) {
                    f1 = 0.625f;
                    GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glScalef((float)f1, (float)(-f1), (float)(-f1));
                }
                renderManager.field_78721_f.func_78443_a((EntityLivingBase)p_77029_1_, itemstack1, 0);
            } else if (item == Items.field_151144_bL) {
                f1 = 1.0625f;
                GL11.glScalef((float)f1, (float)(-f1), (float)(-f1));
                GameProfile gameprofile = null;
                if (itemstack1.func_77942_o()) {
                    NBTTagCompound nbttagcompound = itemstack1.func_77978_p();
                    if (nbttagcompound.func_150297_b("SkullOwner", 10)) {
                        gameprofile = NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.func_74775_l("SkullOwner"));
                    } else if (nbttagcompound.func_150297_b("SkullOwner", 8) && !StringUtils.func_151246_b((String)nbttagcompound.func_74779_i("SkullOwner"))) {
                        gameprofile = new GameProfile((UUID)null, nbttagcompound.func_74779_i("SkullOwner"));
                    }
                }
                TileEntitySkullRenderer.field_147536_b.func_152674_a(-0.5f, 0.0f, -0.5f, 1, 180.0f, itemstack1.func_77960_j(), gameprofile);
            }
            GL11.glPopMatrix();
        }
        if (itemstack != null && itemstack.func_77973_b() != null) {
            item = itemstack.func_77973_b();
            GL11.glPushMatrix();
            if (modelBipedMain.field_78091_s) {
                f1 = 0.5f;
                GL11.glTranslatef((float)0.0f, (float)0.625f, (float)0.0f);
                GL11.glRotatef((float)-20.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                GL11.glScalef((float)f1, (float)f1, (float)f1);
            }
            modelBipedMain.field_78112_f.func_78794_c(0.0625f);
            GL11.glTranslatef((float)-0.0625f, (float)0.4375f, (float)0.0625f);
            customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)itemstack, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.EQUIPPED);
            boolean bl = is3D = customRenderer != null && customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.EQUIPPED, itemstack, IItemRenderer.ItemRendererHelper.BLOCK_3D);
            if (item instanceof ItemBlock && (is3D || RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)item).func_149645_b()))) {
                f1 = 0.5f;
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)-0.3125f);
                GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)(-(f1 *= 0.75f)), (float)(-f1), (float)f1);
            } else if (item == Items.field_151031_f) {
                f1 = 0.625f;
                GL11.glTranslatef((float)0.0f, (float)0.125f, (float)0.3125f);
                GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)f1, (float)(-f1), (float)f1);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (item.func_77662_d()) {
                f1 = 0.625f;
                if (item.func_77629_n_()) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)-0.125f, (float)0.0f);
                }
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)0.0f);
                GL11.glScalef((float)f1, (float)(-f1), (float)f1);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                f1 = 0.375f;
                GL11.glTranslatef((float)0.25f, (float)0.1875f, (float)-0.1875f);
                GL11.glScalef((float)f1, (float)f1, (float)f1);
                GL11.glRotatef((float)60.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (itemstack.func_77973_b().func_77623_v()) {
                for (int i = 0; i < itemstack.func_77973_b().getRenderPasses(itemstack.func_77960_j()); ++i) {
                    int j = itemstack.func_77973_b().func_82790_a(itemstack, i);
                    float f5 = (float)(j >> 16 & 0xFF) / 255.0f;
                    float f2 = (float)(j >> 8 & 0xFF) / 255.0f;
                    float f3 = (float)(j & 0xFF) / 255.0f;
                    GL11.glColor4f((float)f5, (float)f2, (float)f3, (float)1.0f);
                    renderManager.field_78721_f.func_78443_a((EntityLivingBase)p_77029_1_, itemstack, i);
                }
            } else {
                int i = itemstack.func_77973_b().func_82790_a(itemstack, 0);
                float f4 = (float)(i >> 16 & 0xFF) / 255.0f;
                float f5 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                GL11.glColor4f((float)f4, (float)f5, (float)f2, (float)1.0f);
                renderManager.field_78721_f.func_78443_a((EntityLivingBase)p_77029_1_, itemstack, 0);
            }
            GL11.glPopMatrix();
        }
    }
}

