/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.renderer;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class TGRenderHelper {
    public static void enableFXLighting() {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
    }

    public static void disableFXLighting() {
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    public static void enableAlphaBlend() {
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
    }

    public static void enableAlphaBlendAdditive() {
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)1);
    }

    public static void disableAlphaBlend() {
        GL11.glPopAttrib();
    }

    public static void enableBlendMode(RenderType renderType) {
        GL11.glPushAttrib((int)8192);
        if (renderType != RenderType.SOLID) {
            GL11.glEnable((int)3042);
        }
        if (renderType == RenderType.ALPHA) {
            GL11.glBlendFunc((int)770, (int)771);
        } else if (renderType == RenderType.ADDITIVE) {
            GL11.glBlendFunc((int)770, (int)1);
        }
        if (renderType != RenderType.ALPHA_SHADED) {
            TGRenderHelper.enableFXLighting();
        }
    }

    public static void disableBlendMode(RenderType renderType) {
        if (renderType != RenderType.ALPHA_SHADED) {
            TGRenderHelper.disableFXLighting();
        }
        if (renderType != RenderType.SOLID) {
            GL11.glDisable((int)3042);
        }
        GL11.glPopAttrib();
    }

    public static float interpolateRotation(float angle1, float angle2, float progress) {
        float f3;
        for (f3 = angle2 - angle1; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return angle1 + progress * f3;
    }

    public static void adjustLightFixture(World world, int i, int j, int k, Block block) {
        Tessellator tess = Tessellator.field_78398_a;
        float brightness = block.getLightValue((IBlockAccess)world, i, j, k);
        int skyLight = world.func_72802_i(i, j, k, 0);
        int modulousModifier = skyLight % 65536;
        int divModifier = skyLight / 65536;
        tess.func_78386_a(brightness, brightness, brightness);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)modulousModifier, (float)divModifier);
    }

    public static enum RenderType {
        ALPHA,
        ADDITIVE,
        SOLID,
        ALPHA_SHADED,
        NO_Z_TEST;

    }
}

