/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.particle;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import techguns.client.particle.EntityParticleSystem;
import techguns.client.particle.ParticleSystemType;
import techguns.client.renderer.TGRenderHelper;
import techguns.util.MathUtil;

public class EntityParticle
extends EntityFX {
    int lifetime;
    float size;
    float sizePrev;
    float sizeRate;
    float sizeRateDamping;
    float animationSpeed;
    double velX;
    double velY;
    double velZ;
    float velocityDamping;
    float velocityDampingOnGround;
    float systemVelocityFactor;
    EntityParticleSystem particleSystem;
    ParticleSystemType type;
    int variationFrame;
    int angle;

    public EntityParticle(World world, double x, double y, double z, double motionX, double motionY, double motionZ, EntityParticleSystem particleSystem) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.field_70159_w = motionX;
        this.field_70181_x = motionY;
        this.field_70179_y = motionZ;
        this.field_70145_X = true;
        this.particleSystem = particleSystem;
        this.type = particleSystem.type;
        this.init();
    }

    private void init() {
        this.field_70547_e = this.lifetime = MathUtil.randomInt(this.field_70146_Z, this.type.lifetimeMin, this.type.lifetimeMax);
        this.size = MathUtil.randomFloat(this.field_70146_Z, this.type.sizeMin, this.type.sizeMax);
        this.size += this.particleSystem.startSize;
        this.sizeRate = MathUtil.randomFloat(this.field_70146_Z, this.type.sizeRateMin, this.type.sizeRateMax);
        this.sizeRateDamping = MathUtil.randomFloat(this.field_70146_Z, this.type.sizeRateDampingMin, this.type.sizeRateDampingMax);
        this.animationSpeed = MathUtil.randomFloat(this.field_70146_Z, this.type.animationSpeedMin, this.type.animationSpeedMax);
        this.velocityDamping = MathUtil.randomFloat(this.field_70146_Z, this.type.velocityDampingMin, this.type.velocityDampingMax);
        this.systemVelocityFactor = MathUtil.randomFloat(this.field_70146_Z, this.type.systemVelocityFactorMin, this.type.systemVelocityFactorMax);
        this.velocityDampingOnGround = MathUtil.randomFloat(this.field_70146_Z, this.type.velocityDampingOnGroundMin, this.type.velocityDampingOnGroundMax);
        this.field_70159_w += (double)this.systemVelocityFactor * this.particleSystem.field_70159_w;
        this.field_70181_x += (double)this.systemVelocityFactor * this.particleSystem.field_70181_x;
        this.field_70179_y += (double)this.systemVelocityFactor * this.particleSystem.field_70179_y;
        this.velX = this.field_70159_w;
        this.velY = this.field_70181_x;
        this.velZ = this.field_70179_y;
        this.variationFrame = this.field_70146_Z.nextInt(this.type.frames);
        if (this.type.randomRotation) {
            this.angle = this.field_70146_Z.nextInt(4);
        }
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.sizePrev = this.size;
        --this.lifetime;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_70106_y();
        }
        this.field_70159_w = this.velX;
        this.field_70181_x = this.velY;
        this.field_70179_y = this.velZ;
        this.field_70181_x -= (double)this.type.gravity;
        this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        this.velX *= (double)this.velocityDamping;
        this.velY *= (double)this.velocityDamping;
        this.velZ *= (double)this.velocityDamping;
        if (this.field_70122_E) {
            this.velX *= (double)this.velocityDampingOnGround;
            this.velY *= (double)this.velocityDampingOnGround;
            this.velZ *= (double)this.velocityDampingOnGround;
            if (this.type.removeOnGround) {
                this.func_70106_y();
            }
        }
        this.size += this.sizeRate;
        this.sizeRate *= this.sizeRateDamping;
    }

    public void func_70539_a(Tessellator tesselator, float partialTickTime, float rotX, float rotXZ, float rotZ, float rotYZ, float rotXY) {
        float vd;
        float ud;
        float vc;
        float uc;
        float vb;
        float ub;
        float va;
        float ua;
        float progress = ((float)this.field_70546_d + partialTickTime) / (float)this.field_70547_e;
        ParticleSystemType.ColorEntry c1 = null;
        ParticleSystemType.ColorEntry c2 = null;
        ParticleSystemType.ColorEntry prevC = null;
        for (ParticleSystemType.ColorEntry c : this.type.colorEntries) {
            if (progress < c.time) {
                c1 = prevC != null ? prevC : c;
                c2 = c;
                break;
            }
            prevC = c;
        }
        if (c1 == null) {
            c1 = this.type.colorEntries.get(this.type.colorEntries.size() - 1);
        }
        if (c2 == null) {
            c2 = c1;
        }
        float p = (progress - c1.time) / (c2.time - c1.time);
        float[] hsb1 = Color.RGBtoHSB((int)(c1.r * 255.0f), (int)(c1.g * 255.0f), (int)(c1.b * 255.0f), null);
        float[] hsb2 = Color.RGBtoHSB((int)(c2.r * 255.0f), (int)(c2.g * 255.0f), (int)(c2.b * 255.0f), null);
        Color color = new Color(Color.HSBtoRGB(hsb1[0] * p + hsb2[0] * (1.0f - p), hsb1[1] * p + hsb2[1] * (1.0f - p), hsb1[2] * p + hsb2[2] * (1.0f - p)));
        this.field_70552_h = (float)color.getRed() / 255.0f;
        this.field_70553_i = (float)color.getGreen() / 255.0f;
        this.field_70551_j = (float)color.getBlue() / 255.0f;
        ParticleSystemType.AlphaEntry a1 = null;
        ParticleSystemType.AlphaEntry a2 = null;
        ParticleSystemType.AlphaEntry prevA = null;
        for (ParticleSystemType.AlphaEntry a : this.type.alphaEntries) {
            if (progress < a.time) {
                a1 = prevA != null ? prevA : a;
                a2 = a;
                break;
            }
            prevA = a;
        }
        if (a1 == null) {
            a1 = this.type.alphaEntries.get(this.type.alphaEntries.size() - 1);
        }
        if (a2 == null) {
            a2 = a1;
        }
        p = (progress - a1.time) / (a2.time - a1.time);
        this.field_82339_as = a1.alpha * p + a2.alpha * (1.0f - p);
        int currentFrame = 0;
        currentFrame = this.type.hasVariations ? this.variationFrame : (int)((float)this.type.frames * (progress * this.animationSpeed)) % this.type.frames;
        this.field_70544_f = this.sizePrev + (this.size - this.sizePrev) * partialTickTime;
        tesselator.func_78381_a();
        this.enableBlendMode();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.type.texture);
        tesselator.func_78382_b();
        float f6 = ((float)this.field_94054_b + this.field_70548_b / 4.0f) / 16.0f;
        float f7 = f6 + 0.015609375f;
        float f8 = ((float)this.field_94055_c + this.field_70549_c / 4.0f) / 16.0f;
        float f9 = f8 + 0.015609375f;
        float fscale = 0.1f * this.field_70544_f;
        float fPosX = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)partialTickTime - field_70556_an);
        float fPosY = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)partialTickTime - field_70554_ao);
        float fPosZ = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)partialTickTime - field_70555_ap);
        float r = fscale;
        int col = currentFrame % this.type.columns;
        int row = currentFrame / this.type.columns;
        float u = 1.0f / (float)this.type.columns;
        float v = 1.0f / (float)this.type.columns;
        float U1 = (float)col * u;
        float V1 = (float)row * v;
        float U2 = (float)(col + 1) * u;
        float V2 = (float)(row + 1) * v;
        switch (this.angle) {
            case 1: {
                ua = U1;
                va = V2;
                ub = U2;
                vb = V2;
                uc = U2;
                vc = V1;
                ud = U1;
                vd = V1;
                break;
            }
            case 2: {
                ua = U1;
                va = V1;
                ub = U1;
                vb = V2;
                uc = U2;
                vc = V2;
                ud = U2;
                vd = V1;
                break;
            }
            case 3: {
                ua = U2;
                va = V1;
                ub = U1;
                vb = V1;
                uc = U1;
                vc = V2;
                ud = U2;
                vd = V2;
                break;
            }
            default: {
                ua = U2;
                va = V2;
                ub = U2;
                vb = V1;
                uc = U1;
                vc = V1;
                ud = U1;
                vd = V2;
            }
        }
        tesselator.func_78375_b(0.0f, 1.0f, 0.0f);
        tesselator.func_78369_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as);
        tesselator.func_78374_a((double)(fPosX - rotX * fscale - rotYZ * fscale), (double)(fPosY - rotXZ * fscale), (double)(fPosZ - rotZ * fscale - rotXY * fscale), (double)ua, (double)va);
        tesselator.func_78374_a((double)(fPosX - rotX * fscale + rotYZ * fscale), (double)(fPosY + rotXZ * fscale), (double)(fPosZ - rotZ * fscale + rotXY * fscale), (double)ub, (double)vb);
        tesselator.func_78374_a((double)(fPosX + rotX * fscale + rotYZ * fscale), (double)(fPosY + rotXZ * fscale), (double)(fPosZ + rotZ * fscale + rotXY * fscale), (double)uc, (double)vc);
        tesselator.func_78374_a((double)(fPosX + rotX * fscale - rotYZ * fscale), (double)(fPosY - rotXZ * fscale), (double)(fPosZ + rotZ * fscale - rotXY * fscale), (double)ud, (double)vd);
        tesselator.func_78381_a();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("textures/particle/particles.png"));
        this.disableBlendMode();
        tesselator.func_78382_b();
    }

    private void enableBlendMode() {
        GL11.glPushAttrib((int)8192);
        if (this.type.renderType != TGRenderHelper.RenderType.SOLID) {
            GL11.glEnable((int)3042);
        }
        if (this.type.renderType == TGRenderHelper.RenderType.ALPHA) {
            GL11.glBlendFunc((int)770, (int)771);
        } else if (this.type.renderType == TGRenderHelper.RenderType.ADDITIVE || this.type.renderType == TGRenderHelper.RenderType.NO_Z_TEST) {
            GL11.glBlendFunc((int)770, (int)1);
        }
        if (this.type.renderType == TGRenderHelper.RenderType.NO_Z_TEST) {
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2929);
        }
        if (this.type.renderType != TGRenderHelper.RenderType.ALPHA_SHADED) {
            TGRenderHelper.enableFXLighting();
        }
    }

    private void disableBlendMode() {
        if (this.type.renderType != TGRenderHelper.RenderType.ALPHA_SHADED) {
            TGRenderHelper.disableFXLighting();
        }
        if (this.type.renderType != TGRenderHelper.RenderType.SOLID) {
            GL11.glDisable((int)3042);
        }
        if (this.type.renderType == TGRenderHelper.RenderType.NO_Z_TEST) {
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2929);
        }
        GL11.glPopAttrib();
    }

    public int func_70537_b() {
        return 2;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }
}

