/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import techguns.Techguns;
import techguns.blocks.IBlockCamoChangeable;

public class GenericBlockPane
extends BlockPane
implements IBlockCamoChangeable {
    int renderType;
    IIcon[] paneIconsSide;
    IIcon[] poleIcons;
    String[] sideTextures;
    String[] poleTextures;
    IIcon paneIconTop;
    final int VARIATIONS;

    public GenericBlockPane(String[] sideTextures, String[] poleTextures, Material mat) {
        super("", "", mat, true);
        this.func_149647_a(Techguns.tabTechgun);
        this.sideTextures = sideTextures;
        this.poleTextures = poleTextures;
        this.VARIATIONS = sideTextures.length;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        float f = 0.4375f;
        float f1 = 0.5625f;
        float f2 = 0.4375f;
        float f3 = 0.5625f;
        boolean north = this.canPaneConnectTo(world, x, y, z - 1, ForgeDirection.NORTH);
        boolean south = this.canPaneConnectTo(world, x, y, z + 1, ForgeDirection.SOUTH);
        boolean west = this.canPaneConnectTo(world, x - 1, y, z, ForgeDirection.WEST);
        boolean east = this.canPaneConnectTo(world, x + 1, y, z, ForgeDirection.EAST);
        if (!(north || east || south || west)) {
            this.func_149676_a(f, 0.0f, f2, f1, 1.0f, f3);
            return;
        }
        if ((!west || !east) && (west || east || north || south)) {
            if (west && !east) {
                f = 0.0f;
            } else if (!west && east) {
                f1 = 1.0f;
            }
        } else {
            f = 0.0f;
            f1 = 1.0f;
        }
        if ((!north || !south) && (west || east || north || south)) {
            if (north && !south) {
                f2 = 0.0f;
            } else if (!north && south) {
                f3 = 1.0f;
            }
        } else {
            f2 = 0.0f;
            f3 = 1.0f;
        }
        this.func_149676_a(f, 0.0f, f2, f1, 1.0f, f3);
    }

    public boolean canPaneConnectTo(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        Block b = world.func_147439_a(x, y, z);
        boolean canConnect = b == this || b instanceof BlockPane;
        return canConnect;
    }

    public GenericBlockPane setRenderType(int renderType) {
        this.renderType = renderType;
        return this;
    }

    public int func_149645_b() {
        return this.renderType;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List subItems) {
        for (int i = 0; i < this.VARIATIONS; ++i) {
            subItems.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.paneIconsSide[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_150097_e() {
        return this.paneIconTop;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.paneIconsSide = new IIcon[this.VARIATIONS];
        this.paneIconTop = reg.func_94245_a("techguns:invisible");
        this.poleIcons = new IIcon[this.VARIATIONS];
        for (int i = 0; i < this.VARIATIONS; ++i) {
            this.paneIconsSide[i] = reg.func_94245_a(this.sideTextures[i]);
            this.poleIcons[i] = reg.func_94245_a(this.poleTextures[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getPoleIcon(int blockMetadata) {
        return this.poleIcons[blockMetadata];
    }

    @Override
    public int getVariationCount() {
        return this.VARIATIONS;
    }

    @Override
    public String getVariationName(int meta) {
        return this.func_149739_a() + ".camo." + meta;
    }

    public String func_149739_a() {
        return "techguns." + super.func_149739_a();
    }

    @Override
    public int getMetaOffset() {
        return 1;
    }
}

