/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import techguns.blocks.GenericBlock;

public class BlockTGLamp
extends GenericBlock {
    public IIcon[] icons = new IIcon[6];

    public BlockTGLamp() {
        super(Material.field_151573_f);
        this.func_149711_c(0.25f);
        this.func_149663_c("Lamp");
        this.func_149672_a(field_149778_k);
        this.func_149715_a(1.0f);
        this.func_149713_g(0);
    }

    public void func_149651_a(IIconRegister reg) {
        this.icons[0] = reg.func_94245_a("techguns:lamp01");
        this.icons[1] = reg.func_94245_a("techguns:lamp02");
        this.icons[2] = reg.func_94245_a("techguns:lantern01_side");
        this.icons[3] = reg.func_94245_a("techguns:lantern02_side");
        this.icons[4] = reg.func_94245_a("techguns:lantern01_top");
        this.icons[5] = reg.func_94245_a("techguns:lantern02_top");
    }

    public int func_149692_a(int meta) {
        if (meta < 7) {
            return 0;
        }
        if (meta == 7) {
            return 7;
        }
        if (meta < 15) {
            return 8;
        }
        return 15;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta < 7) {
            return this.icons[0];
        }
        if (meta == 7) {
            return side <= 1 ? this.icons[4] : this.icons[2];
        }
        if (meta < 15) {
            return this.icons[1];
        }
        return side <= 1 ? this.icons[5] : this.icons[3];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List subItems) {
        subItems.add(new ItemStack(item, 1, 0));
        subItems.add(new ItemStack(item, 1, 8));
        subItems.add(new ItemStack(item, 1, 7));
        subItems.add(new ItemStack(item, 1, 15));
    }

    public AxisAlignedBB func_149668_a(World p_149668_1_, int p_149668_2_, int p_149668_3_, int p_149668_4_) {
        this.func_149719_a((IBlockAccess)p_149668_1_, p_149668_2_, p_149668_3_, p_149668_4_);
        return super.func_149668_a(p_149668_1_, p_149668_2_, p_149668_3_, p_149668_4_);
    }

    public void func_149719_a(IBlockAccess p_149719_1_, int p_149719_2_, int p_149719_3_, int p_149719_4_) {
        this.setBoundingBox(p_149719_1_.func_72805_g(p_149719_2_, p_149719_3_, p_149719_4_));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World p_149633_1_, int p_149633_2_, int p_149633_3_, int p_149633_4_) {
        this.func_149719_a((IBlockAccess)p_149633_1_, p_149633_2_, p_149633_3_, p_149633_4_);
        return super.func_149633_g(p_149633_1_, p_149633_2_, p_149633_3_, p_149633_4_);
    }

    public void setBoundingBox(int meta) {
        int width = 32;
        float px = 0.03125f;
        int w1 = 16;
        int h1 = 6;
        float minW1 = (float)(32 - w1) / 2.0f * px;
        float maxW1 = (32.0f - (float)(32 - w1) / 2.0f) * px;
        float minH1 = (float)h1 * px;
        float maxH1 = (float)(32 - h1) * px;
        if (meta == 1 || meta == 9) {
            this.func_149676_a(minW1, maxH1, minW1, maxW1, 1.0f, maxW1);
        } else if (meta == 2 || meta == 10) {
            this.func_149676_a(minW1, 0.0f, minW1, maxW1, minH1, maxW1);
        } else if (meta == 3 || meta == 11) {
            this.func_149676_a(minW1, minW1, maxH1, maxW1, maxW1, 1.0f);
        } else if (meta == 4 || meta == 12) {
            this.func_149676_a(minW1, minW1, 0.0f, maxW1, maxW1, minH1);
        } else if (meta == 5 || meta == 13) {
            this.func_149676_a(maxH1, minW1, minW1, 1.0f, maxW1, maxW1);
        } else if (meta == 6 || meta == 14) {
            this.func_149676_a(0.0f, minW1, minW1, minH1, maxW1, maxW1);
        } else if (meta == 7 || meta == 15) {
            this.func_149676_a(minW1, 0.125f, minW1, maxW1, 0.875f, maxW1);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return world.isSideSolid(x - 1, y, z, ForgeDirection.EAST, true) || world.isSideSolid(x + 1, y, z, ForgeDirection.WEST, true) || world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH, true) || world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH, true) || world.isSideSolid(x, y - 1, z, ForgeDirection.UP, true) || world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN, true);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (metadata == 7 || metadata == 15) {
            return metadata;
        }
        int meta = metadata;
        int offset = 0;
        if (metadata == 8) {
            offset = 8;
        }
        if (side == 0 && world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN, true)) {
            meta = 1 + offset;
        }
        if (side == 1 && world.isSideSolid(x, y - 1, z, ForgeDirection.UP, true)) {
            meta = 2 + offset;
        }
        if (side == 2 && world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH, true)) {
            meta = 3 + offset;
        }
        if (side == 3 && world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH, true)) {
            meta = 4 + offset;
        }
        if (side == 4 && world.isSideSolid(x + 1, y, z, ForgeDirection.WEST, true)) {
            meta = 5 + offset;
        }
        if (side == 5 && world.isSideSolid(x - 1, y, z, ForgeDirection.EAST, true)) {
            meta = 6 + offset;
        }
        return meta;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        super.func_149674_a(world, x, y, z, rand);
        int m = world.func_72805_g(x, y, z);
        if (m == 0 || m == 8) {
            this.func_149726_b(world, x, y, z);
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        int m = world.func_72805_g(x, y, z);
        if (m == 0 || m == 8) {
            if (world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN, true)) {
                world.func_72921_c(x, y, z, m + 1, 2);
            } else if (world.isSideSolid(x, y - 1, z, ForgeDirection.UP, true)) {
                world.func_72921_c(x, y, z, m + 2, 2);
            } else if (world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH, true)) {
                world.func_72921_c(x, y, z, m + 3, 2);
            } else if (world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH, true)) {
                world.func_72921_c(x, y, z, m + 4, 2);
            } else if (world.isSideSolid(x + 1, y, z, ForgeDirection.WEST, true)) {
                world.func_72921_c(x, y, z, m + 5, 2);
            } else if (world.isSideSolid(x - 1, y, z, ForgeDirection.EAST, true)) {
                world.func_72921_c(x, y, z, m + 6, 2);
            }
        }
        this.checkIfValidBlock(world, x, y, z);
    }

    public void func_149695_a(World p_149695_1_, int p_149695_2_, int p_149695_3_, int p_149695_4_, Block p_149695_5_) {
        this.validateNeighborChange(p_149695_1_, p_149695_2_, p_149695_3_, p_149695_4_, p_149695_5_);
    }

    protected boolean validateNeighborChange(World world, int x, int y, int z, Block block) {
        if (this.checkIfValidBlock(world, x, y, z)) {
            int meta = world.func_72805_g(x, y, z);
            boolean invalid = false;
            if (!(world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN, true) || meta != 1 && meta != 9)) {
                invalid = true;
            }
            if (!(world.isSideSolid(x, y - 1, z, ForgeDirection.UP, true) || meta != 2 && meta != 10)) {
                invalid = true;
            }
            if (!(world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH, true) || meta != 3 && meta != 11)) {
                invalid = true;
            }
            if (!(world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH, true) || meta != 4 && meta != 12)) {
                invalid = true;
            }
            if (!(world.isSideSolid(x + 1, y, z, ForgeDirection.WEST, true) || meta != 5 && meta != 13)) {
                invalid = true;
            }
            if (!(world.isSideSolid(x - 1, y, z, ForgeDirection.EAST, true) || meta != 6 && meta != 14)) {
                invalid = true;
            }
            if (invalid) {
                this.dropBlockAsItem(world, x, y, z, world.func_72805_g(x, y, z));
                world.func_147468_f(x, y, z);
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean checkIfValidBlock(World world, int x, int y, int z) {
        if (!this.func_149742_c(world, x, y, z)) {
            if (world.func_147439_a(x, y, z) == this) {
                this.dropBlockAsItem(world, x, y, z, world.func_72805_g(x, y, z));
                world.func_147468_f(x, y, z);
            }
            return false;
        }
        return true;
    }

    private void dropBlockAsItem(World world, int x, int y, int z, int meta) {
        meta = meta < 7 ? 0 : (meta == 7 ? 7 : (meta < 15 ? 8 : 15));
        this.func_149697_b(world, x, y, z, meta, 0);
    }

    public boolean canConnectTo(IBlockAccess w, int x, int y, int z) {
        Block block = w.func_147439_a(x, y, z);
        return block != this && block.func_149688_o().func_76218_k() && block.func_149686_d() && block.func_149688_o() != Material.field_151572_C;
    }

    @Override
    public int getRotationMeta(int metadata, int rotationOffset) {
        if (metadata <= 2 || metadata > 6 && metadata < 11 || metadata == 15) {
            return metadata;
        }
        int m = metadata;
        int offset = metadata >= 8 ? 8 : 0;
        block6: for (int i = 0; i < rotationOffset; ++i) {
            switch (m % 8) {
                case 5: {
                    m = 4;
                    continue block6;
                }
                case 3: {
                    m = 5;
                    continue block6;
                }
                case 6: {
                    m = 3;
                    continue block6;
                }
                case 4: {
                    m = 6;
                }
            }
        }
        return offset + m;
    }
}

