/*
 * Decompiled with CFR 0.152.
 */
package com.nauktis.core.gui;

import com.google.common.collect.Maps;
import com.nauktis.core.utility.Utils;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class BaseModContainer
extends Container {
    protected static final int MOUSE_LEFT_CLICK = 0;
    protected static final int MOUSE_RIGHT_CLICK = 1;
    protected static final int FAKE_SLOT_ID = -999;
    protected static final int CLICK_MODE_NORMAL = 0;
    protected static final int CLICK_MODE_SHIFT = 1;
    protected static final int CLICK_MODE_KEY = 2;
    protected static final int CLICK_MODE_PICK_ITEM = 3;
    protected static final int CLICK_MODE_OUTSIDE = 4;
    protected static final int CLICK_DRAG_RELEASE = 5;
    protected static final int CLICK_MODE_DOUBLE_CLICK = 6;
    protected static final int CLICK_DRAG_MODE_PRE = 0;
    protected static final int CLICK_DRAG_MODE_SLOT = 1;
    protected static final int CLICK_DRAG_MODE_POST = 2;
    protected static final int PLAYER_INVENTORY_ROWS = 3;
    protected static final int PLAYER_INVENTORY_COLUMNS = 9;
    private final Map<Integer, Integer> mProgressBarValues = Maps.newHashMap();

    protected void sendProgressBarUpdateIfChanged(int pType, int pValue, boolean pForce) {
        if (pForce || !this.mProgressBarValues.containsKey(pType) || !this.mProgressBarValues.get(pType).equals(pValue)) {
            for (ICrafting crafting : this.getCraftings()) {
                crafting.func_71112_a((Container)this, pType, pValue);
            }
            this.mProgressBarValues.put(pType, pValue);
        }
    }

    protected List<ICrafting> getCraftings() {
        return this.field_75149_d;
    }

    public ItemStack func_82846_b(EntityPlayer pPlayer, int pSlotIndex) {
        return null;
    }

    public boolean func_75145_c(EntityPlayer pPlayer) {
        return true;
    }

    protected void addPlayerInventorySlotsToContainer(InventoryPlayer pInventoryPlayer, int pLeft, int pTop) {
        for (int inventoryRowIndex = 0; inventoryRowIndex < 3; ++inventoryRowIndex) {
            for (int inventoryColumnIndex = 0; inventoryColumnIndex < 9; ++inventoryColumnIndex) {
                this.func_75146_a(new Slot((IInventory)pInventoryPlayer, inventoryColumnIndex + inventoryRowIndex * 9 + 9, pLeft + inventoryColumnIndex * 18, pTop + inventoryRowIndex * 18));
            }
        }
    }

    protected void addPlayerActionSlotsToContainer(InventoryPlayer pInventoryPlayer, int pLeft, int pTop) {
        for (int actionBarSlotIndex = 0; actionBarSlotIndex < 9; ++actionBarSlotIndex) {
            this.func_75146_a(new Slot((IInventory)pInventoryPlayer, actionBarSlotIndex, pLeft + actionBarSlotIndex * 18, pTop));
        }
    }

    protected boolean func_75135_a(ItemStack pItemStack, int pSlotMin, int pSlotMax, boolean pAscending) {
        ItemStack stackInSlot;
        Slot slot;
        int currentSlotIndex;
        boolean slotFound = false;
        int n = currentSlotIndex = pAscending ? pSlotMax - 1 : pSlotMin;
        if (pItemStack.func_77985_e()) {
            while (pItemStack.field_77994_a > 0 && (!pAscending && currentSlotIndex < pSlotMax || pAscending && currentSlotIndex >= pSlotMin)) {
                slot = this.func_75139_a(currentSlotIndex);
                stackInSlot = slot.func_75211_c();
                if (slot.func_75214_a(pItemStack) && Utils.itemStacksEqualIgnoreStackSize(pItemStack, stackInSlot)) {
                    int combinedStackSize = stackInSlot.field_77994_a + pItemStack.field_77994_a;
                    int slotStackSizeLimit = Math.min(stackInSlot.func_77976_d(), slot.func_75219_a());
                    if (combinedStackSize <= slotStackSizeLimit) {
                        pItemStack.field_77994_a = 0;
                        stackInSlot.field_77994_a = combinedStackSize;
                        slot.func_75218_e();
                        slotFound = true;
                    } else if (stackInSlot.field_77994_a < slotStackSizeLimit) {
                        pItemStack.field_77994_a -= slotStackSizeLimit - stackInSlot.field_77994_a;
                        stackInSlot.field_77994_a = slotStackSizeLimit;
                        slot.func_75218_e();
                        slotFound = true;
                    }
                }
                currentSlotIndex += pAscending ? -1 : 1;
            }
        }
        if (pItemStack.field_77994_a > 0) {
            int n2 = currentSlotIndex = pAscending ? pSlotMax - 1 : pSlotMin;
            while (!pAscending && currentSlotIndex < pSlotMax || pAscending && currentSlotIndex >= pSlotMin) {
                slot = this.func_75139_a(currentSlotIndex);
                stackInSlot = slot.func_75211_c();
                if (slot.func_75214_a(pItemStack) && stackInSlot == null) {
                    ItemStack placedItemStack = pItemStack.func_77946_l();
                    placedItemStack.field_77994_a = Math.min(pItemStack.field_77994_a, slot.func_75219_a());
                    slot.func_75215_d(placedItemStack);
                    slot.func_75218_e();
                    if (slot.func_75211_c() == null) break;
                    pItemStack.field_77994_a -= slot.func_75211_c().field_77994_a;
                    slotFound = true;
                    break;
                }
                currentSlotIndex += pAscending ? -1 : 1;
            }
        }
        return slotFound;
    }
}

