/*
 * Decompiled with CFR 0.152.
 */
package com.nauktis.core.block;

import com.google.common.base.Preconditions;
import com.nauktis.core.block.icon.IBlockIconHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class BaseModBlock
extends Block {
    private final String mModId;
    private final IBlockIconHandler mBlockIconHandler;

    public BaseModBlock(String pModId, String pName, IBlockIconHandler pBlockIconHandler) {
        super(Material.field_151576_e);
        this.mModId = ((String)Preconditions.checkNotNull((Object)pModId)).toLowerCase();
        this.mBlockIconHandler = (IBlockIconHandler)Preconditions.checkNotNull((Object)pBlockIconHandler);
        this.func_149663_c((String)Preconditions.checkNotNull((Object)pName));
    }

    public String func_149739_a() {
        return String.format("tile.%s:%s", this.mModId, this.unwrapUnlocalizedName(super.func_149739_a()));
    }

    protected String unwrapUnlocalizedName(String pUnlocalizedName) {
        return pUnlocalizedName.substring(pUnlocalizedName.indexOf(".") + 1);
    }

    public IIcon func_149691_a(int pSide, int pMetadata) {
        return this.mBlockIconHandler.getIcon(pSide, pMetadata);
    }

    public IIcon func_149673_e(IBlockAccess pBlockAccess, int pX, int pY, int pZ, int pSide) {
        return this.mBlockIconHandler.getIcon(pBlockAccess, pX, pY, pZ, pSide);
    }

    public void func_149651_a(IIconRegister pIconRegister) {
        this.mBlockIconHandler.registerBlockIcons(pIconRegister);
    }
}

