/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.simple;

import cofh.api.block.IDismantleable;
import cofh.api.core.IInitializer;
import cofh.core.render.IconRegistry;
import cofh.core.util.CoreUtils;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.core.TEProps;
import cofh.thermalexpansion.util.crafting.PulverizerManager;
import cofh.thermalexpansion.util.crafting.TransposerManager;
import cofh.thermalfoundation.fluid.TFFluids;
import cofh.thermalfoundation.item.TFItems;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class BlockFrame
extends Block
implements IDismantleable,
IInitializer {
    public static int renderPass = 0;
    public static final String[] NAMES = new String[]{"machineBasic", "machineHardened", "machineReinforced", "machineResonant", "cellBasic", "cellHardened", "cellReinforcedEmpty", "cellReinforcedFull", "cellResonantEmpty", "cellResonantFull", "tesseractEmpty", "tesseractFull", "illuminator"};
    public static final float[] HARDNESS = new float[]{5.0f, 15.0f, 20.0f, 20.0f, 5.0f, 15.0f, 20.0f, 20.0f, 20.0f, 20.0f, 15.0f, 15.0f, 3.0f};
    public static final int[] RESISTANCE = new int[]{15, 90, 120, 120, 15, 90, 120, 120, 120, 120, 2000, 2000, 150};
    public static boolean[] enable = new boolean[Types.values().length];
    public static boolean[] recipe = new boolean[Types.values().length];
    public static ItemStack frameMachineBasic;
    public static ItemStack frameMachineHardened;
    public static ItemStack frameMachineReinforced;
    public static ItemStack frameMachineResonant;
    public static ItemStack frameCellBasic;
    public static ItemStack frameCellHardened;
    public static ItemStack frameCellReinforcedEmpty;
    public static ItemStack frameCellReinforcedFull;
    public static ItemStack frameCellResonantEmpty;
    public static ItemStack frameCellResonantFull;
    public static ItemStack frameTesseractEmpty;
    public static ItemStack frameTesseractFull;
    public static ItemStack frameIlluminator;

    public static boolean hasCenter(int n) {
        return n < Types.ILLUMINATOR.ordinal();
    }

    public static boolean hasFrame(int n) {
        return n < Types.ILLUMINATOR.ordinal();
    }

    public BlockFrame() {
        super(Material.field_151573_f);
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149647_a(ThermalExpansion.tabBlocks);
        this.func_149663_c("thermalexpansion.frame");
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < Types.values().length; ++i) {
            if (!enable[i]) continue;
            list.add(new ItemStack(item, 1, i));
        }
    }

    public float func_149712_f(World world, int n, int n2, int n3) {
        return HARDNESS[world.func_72805_g(n, n2, n3)];
    }

    public float getExplosionResistance(Entity entity, World world, int n, int n2, int n3, double d, double d2, double d3) {
        return RESISTANCE[world.func_72805_g(n, n2, n3)];
    }

    public int func_149692_a(int n) {
        return n;
    }

    public int func_149701_w() {
        return 1;
    }

    public int func_149645_b() {
        return TEProps.renderIdFrame;
    }

    public boolean canCreatureSpawn(EnumCreatureType enumCreatureType, IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return false;
    }

    public boolean canRenderInPass(int n) {
        renderPass = n;
        return n < 2;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return true;
    }

    public boolean func_149686_d() {
        return false;
    }

    public IIcon func_149691_a(int n, int n2) {
        if (n == 6) {
            return this.getInnerIcon(n2);
        }
        if (n == 7) {
            return this.getCenterIcon(n2);
        }
        return this.getFrameIcon(n, n2);
    }

    private IIcon getFrameIcon(int n, int n2) {
        switch (Types.values()[n2]) {
            case CELL_BASIC: {
                return IconRegistry.getIcon((String)"FrameCellBasic");
            }
            case CELL_HARDENED: {
                return IconRegistry.getIcon((String)"FrameCellHardened");
            }
            case CELL_REINFORCED_EMPTY: 
            case CELL_REINFORCED_FULL: {
                return IconRegistry.getIcon((String)"FrameCellReinforced");
            }
            case CELL_RESONANT_EMPTY: 
            case CELL_RESONANT_FULL: {
                return IconRegistry.getIcon((String)"FrameCellResonant");
            }
            case TESSERACT_EMPTY: 
            case TESSERACT_FULL: {
                return IconRegistry.getIcon((String)"FrameTesseract");
            }
            case ILLUMINATOR: {
                return IconRegistry.getIcon((String)"FrameIlluminator");
            }
        }
        if (n == 0) {
            return IconRegistry.getIcon((String)"FrameMachineBottom");
        }
        if (n == 1) {
            return IconRegistry.getIcon((String)"FrameMachineTop");
        }
        return IconRegistry.getIcon((String)"FrameMachineSide");
    }

    private IIcon getInnerIcon(int n) {
        switch (Types.values()[n]) {
            case CELL_BASIC: {
                return IconRegistry.getIcon((String)"FrameCellBasicInner");
            }
            case CELL_HARDENED: {
                return IconRegistry.getIcon((String)"FrameCellHardenedInner");
            }
            case CELL_REINFORCED_EMPTY: 
            case CELL_REINFORCED_FULL: {
                return IconRegistry.getIcon((String)"FrameCellReinforcedInner");
            }
            case CELL_RESONANT_EMPTY: 
            case CELL_RESONANT_FULL: {
                return IconRegistry.getIcon((String)"FrameCellResonantInner");
            }
            case TESSERACT_EMPTY: 
            case TESSERACT_FULL: {
                return IconRegistry.getIcon((String)"FrameTesseractInner");
            }
            case ILLUMINATOR: {
                return IconRegistry.getIcon((String)"FrameIlluminatorInner");
            }
        }
        return IconRegistry.getIcon((String)"FrameMachineInner");
    }

    private IIcon getCenterIcon(int n) {
        return IconRegistry.getIcon((String)"FrameCenter", (int)n);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        IconRegistry.addIcon((String)"FrameMachineBottom", (String)"thermalexpansion:machine/Machine_Frame_Bottom", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameMachineTop", (String)"thermalexpansion:machine/Machine_Frame_Top", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameMachineSide", (String)"thermalexpansion:machine/Machine_Frame_Side", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameCellBasic", (String)"thermalexpansion:cell/Cell_Basic", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameCellHardened", (String)"thermalexpansion:cell/Cell_Hardened", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameCellReinforced", (String)"thermalexpansion:cell/Cell_Reinforced", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameCellResonant", (String)"thermalexpansion:cell/Cell_Resonant", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameTesseract", (String)"thermalexpansion:tesseract/Tesseract", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameIlluminator", (String)"thermalexpansion:light/Illuminator_Frame", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameMachineInner", (String)"thermalexpansion:machine/Machine_Frame_Inner", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameCellBasicInner", (String)"thermalexpansion:cell/Cell_Basic_Inner", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameCellHardenedInner", (String)"thermalexpansion:cell/Cell_Hardened_Inner", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameCellReinforcedInner", (String)"thermalexpansion:cell/Cell_Reinforced_Inner", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameCellResonantInner", (String)"thermalexpansion:cell/Cell_Resonant_Inner", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameTesseractInner", (String)"thermalexpansion:tesseract/Tesseract_Inner", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameIlluminatorInner", (String)"thermalexpansion:config/Config_None", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameCenter0", (String)"thermalfoundation:storage/Block_Tin", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameCenter1", (String)"thermalfoundation:storage/Block_Electrum", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameCenter2", (String)"thermalfoundation:storage/Block_Signalum", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameCenter3", (String)"thermalfoundation:storage/Block_Enderium", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameCenter4", (String)"thermalexpansion:cell/Cell_Center_Solid", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameCenter5", (String)"thermalexpansion:cell/Cell_Center_Solid", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameCenter6", (String)"thermalexpansion:config/Config_None", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameCenter7", (String)"thermalfoundation:fluid/Fluid_Redstone_Still", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameCenter8", (String)"thermalexpansion:config/Config_None", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameCenter9", (String)"thermalfoundation:fluid/Fluid_Redstone_Still", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameCenter10", (String)"thermalexpansion:config/Config_None", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameCenter11", (String)"thermalfoundation:fluid/Fluid_Ender_Still", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"FrameCenter12", (String)"thermalexpansion:config/Config_None", (IIconRegister)iIconRegister);
    }

    public ArrayList<ItemStack> dismantleBlock(EntityPlayer entityPlayer, World world, int n, int n2, int n3, boolean bl) {
        int n4 = world.func_72805_g(n, n2, n3);
        ItemStack itemStack = new ItemStack((Block)this, 1, n4);
        world.func_147468_f(n, n2, n3);
        if (!bl) {
            float f = 0.3f;
            double d = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d3 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)n + d, (double)n2 + d2, (double)n3 + d3, itemStack);
            entityItem.field_145804_b = 10;
            world.func_72838_d((Entity)entityItem);
            CoreUtils.dismantleLog((String)entityPlayer.func_70005_c_(), (Block)this, (int)n4, (double)n, (double)n2, (double)n3);
        }
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        arrayList.add(itemStack);
        return arrayList;
    }

    public boolean canDismantle(EntityPlayer entityPlayer, World world, int n, int n2, int n3) {
        return true;
    }

    public boolean preInit() {
        return true;
    }

    public boolean initialize() {
        frameMachineBasic = new ItemStack((Block)this, 1, Types.MACHINE_BASIC.ordinal());
        frameMachineHardened = new ItemStack((Block)this, 1, Types.MACHINE_HARDENED.ordinal());
        frameMachineReinforced = new ItemStack((Block)this, 1, Types.MACHINE_REINFORCED.ordinal());
        frameMachineResonant = new ItemStack((Block)this, 1, Types.MACHINE_RESONANT.ordinal());
        frameCellBasic = new ItemStack((Block)this, 1, Types.CELL_BASIC.ordinal());
        frameCellHardened = new ItemStack((Block)this, 1, Types.CELL_HARDENED.ordinal());
        frameCellReinforcedEmpty = new ItemStack((Block)this, 1, Types.CELL_REINFORCED_EMPTY.ordinal());
        frameCellReinforcedFull = new ItemStack((Block)this, 1, Types.CELL_REINFORCED_FULL.ordinal());
        frameCellResonantEmpty = new ItemStack((Block)this, 1, Types.CELL_RESONANT_EMPTY.ordinal());
        frameCellResonantFull = new ItemStack((Block)this, 1, Types.CELL_RESONANT_FULL.ordinal());
        frameTesseractEmpty = new ItemStack((Block)this, 1, Types.TESSERACT_EMPTY.ordinal());
        frameTesseractFull = new ItemStack((Block)this, 1, Types.TESSERACT_FULL.ordinal());
        frameIlluminator = new ItemStack((Block)this, 1, Types.ILLUMINATOR.ordinal());
        GameRegistry.registerCustomItemStack((String)"frameMachineBasic", (ItemStack)frameMachineBasic);
        GameRegistry.registerCustomItemStack((String)"frameMachineHardened", (ItemStack)frameMachineHardened);
        GameRegistry.registerCustomItemStack((String)"frameMachineReinforced", (ItemStack)frameMachineReinforced);
        GameRegistry.registerCustomItemStack((String)"frameMachineResonant", (ItemStack)frameMachineResonant);
        GameRegistry.registerCustomItemStack((String)"frameCellBasic", (ItemStack)frameCellBasic);
        GameRegistry.registerCustomItemStack((String)"frameCellHardened", (ItemStack)frameCellHardened);
        GameRegistry.registerCustomItemStack((String)"frameCellReinforcedEmpty", (ItemStack)frameCellReinforcedEmpty);
        GameRegistry.registerCustomItemStack((String)"frameCellReinforcedFull", (ItemStack)frameCellReinforcedFull);
        GameRegistry.registerCustomItemStack((String)"frameCellResonantEmpty", (ItemStack)frameCellResonantEmpty);
        GameRegistry.registerCustomItemStack((String)"frameCellResonantFull", (ItemStack)frameCellResonantFull);
        GameRegistry.registerCustomItemStack((String)"frameTesseractEmpty", (ItemStack)frameTesseractEmpty);
        GameRegistry.registerCustomItemStack((String)"frameTesseractFull", (ItemStack)frameTesseractFull);
        GameRegistry.registerCustomItemStack((String)"frameIlluminator", (ItemStack)frameIlluminator);
        OreDictionary.registerOre((String)"thermalexpansion:machineFrame", (ItemStack)frameMachineBasic);
        OreDictionary.registerOre((String)"thermalexpansion:machineFrame", (ItemStack)frameMachineHardened);
        OreDictionary.registerOre((String)"thermalexpansion:machineFrame", (ItemStack)frameMachineReinforced);
        OreDictionary.registerOre((String)"thermalexpansion:machineFrame", (ItemStack)frameMachineResonant);
        return true;
    }

    public boolean postInit() {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)frameMachineBasic, (Object[])new Object[]{"IGI", "GXG", "IGI", Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "blockGlass", Character.valueOf('X'), "gearTin"}));
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)frameMachineHardened, (Object[])new Object[]{"IGI", " X ", "I I", Character.valueOf('I'), "ingotInvar", Character.valueOf('G'), "gearElectrum", Character.valueOf('X'), frameMachineBasic}));
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)frameMachineReinforced, (Object[])new Object[]{"IGI", " X ", "I I", Character.valueOf('I'), "blockGlassHardened", Character.valueOf('G'), "gearSignalum", Character.valueOf('X'), frameMachineHardened}));
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)frameMachineResonant, (Object[])new Object[]{"IGI", " X ", "I I", Character.valueOf('I'), "ingotSilver", Character.valueOf('G'), "gearEnderium", Character.valueOf('X'), frameMachineReinforced}));
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)frameCellBasic, (Object[])new Object[]{"IGI", "GXG", "IGI", Character.valueOf('I'), "ingotLead", Character.valueOf('G'), "blockGlass", Character.valueOf('X'), Blocks.field_150451_bX}));
        PulverizerManager.addRecipe(4000, frameCellBasic, ItemHelper.cloneStack((Item)Items.field_151137_ax, (int)8), ItemHelper.cloneStack((ItemStack)TFItems.ingotLead, (int)3));
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)frameCellHardened, (Object[])new Object[]{" I ", "IXI", " I ", Character.valueOf('I'), "ingotInvar", Character.valueOf('X'), frameCellBasic}));
        PulverizerManager.addRecipe(8000, frameCellHardened, ItemHelper.cloneStack((Item)Items.field_151137_ax, (int)8), ItemHelper.cloneStack((ItemStack)TFItems.ingotInvar, (int)3));
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)frameCellReinforcedEmpty, (Object[])new Object[]{"IGI", "GXG", "IGI", Character.valueOf('I'), "ingotElectrum", Character.valueOf('G'), "blockGlassHardened", Character.valueOf('X'), "gemDiamond"}));
        TransposerManager.addTEFillRecipe(16000, frameCellReinforcedEmpty, frameCellReinforcedFull, new FluidStack(TFFluids.fluidRedstone, 4000), false);
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)frameCellResonantEmpty, (Object[])new Object[]{" I ", "IXI", " I ", Character.valueOf('I'), "ingotEnderium", Character.valueOf('X'), frameCellReinforcedEmpty}));
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)frameCellResonantFull, (Object[])new Object[]{" I ", "IXI", " I ", Character.valueOf('I'), "ingotEnderium", Character.valueOf('X'), frameCellReinforcedFull}));
        TransposerManager.addTEFillRecipe(16000, frameCellResonantEmpty, frameCellResonantFull, new FluidStack(TFFluids.fluidRedstone, 4000), false);
        if (recipe[Types.TESSERACT_EMPTY.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)frameTesseractEmpty, (Object[])new Object[]{"IGI", "GXG", "IGI", Character.valueOf('I'), "ingotEnderium", Character.valueOf('G'), "blockGlassHardened", Character.valueOf('X'), "gemDiamond"}));
        }
        if (recipe[Types.TESSERACT_FULL.ordinal()]) {
            TransposerManager.addTEFillRecipe(16000, frameTesseractEmpty, frameTesseractFull, new FluidStack(TFFluids.fluidEnder, 1000), false);
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)frameIlluminator, (int)2), (Object[])new Object[]{" Q ", "G G", " S ", Character.valueOf('G'), "blockGlassHardened", Character.valueOf('Q'), "gemQuartz", Character.valueOf('S'), "ingotSignalum"}));
        return true;
    }

    static {
        for (int i = 0; i < Types.values().length; ++i) {
            BlockFrame.enable[i] = true;
            BlockFrame.recipe[i] = true;
        }
    }

    public static enum Types {
        MACHINE_BASIC,
        MACHINE_HARDENED,
        MACHINE_REINFORCED,
        MACHINE_RESONANT,
        CELL_BASIC,
        CELL_HARDENED,
        CELL_REINFORCED_EMPTY,
        CELL_REINFORCED_FULL,
        CELL_RESONANT_EMPTY,
        CELL_RESONANT_FULL,
        TESSERACT_EMPTY,
        TESSERACT_FULL,
        ILLUMINATOR;

    }
}

