/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.itemblacklist.util;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.doubledoordev.itemblacklist.Helper;
import net.doubledoordev.itemblacklist.data.BanList;
import net.doubledoordev.itemblacklist.data.BanListEntry;
import net.doubledoordev.itemblacklist.data.GlobalBanList;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class CommandBlockItem
extends CommandBase {
    public String func_71517_b() {
        return "blockitem";
    }

    public List func_71514_a() {
        return Arrays.asList("itemblacklist", "blacklist");
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "Use '/blockitem help' for more info.";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            sender.func_145747_a(new ChatComponentText("Possible subcommands:").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GOLD)));
            sender.func_145747_a(this.makeHelpText("reload", "Reloads the config file from disk."));
            sender.func_145747_a(this.makeHelpText("pack [player]", "Lock banned items in targets inventory."));
            sender.func_145747_a(this.makeHelpText("unpack [player]", "Unlock banned items in targets inventory."));
            sender.func_145747_a(this.makeHelpText("list [dim|player]", "List banned items of all, player, or dim"));
            sender.func_145747_a(this.makeHelpText("ban [dim list] [item[:*|meta]]", "Ban an item."));
            sender.func_145747_a(this.makeHelpText("unban [dim list] [item[:*|meta]]", "Unban an item."));
            return;
        }
        String arg0 = args[0].toLowerCase();
        boolean unpack = false;
        switch (arg0) {
            default: {
                throw new WrongUsageException("Unknown subcommand. Use '/blockitem' to get some help.", new Object[0]);
            }
            case "reload": {
                GlobalBanList.init();
                sender.func_145747_a(new ChatComponentText("Reloaded!").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GREEN)));
            }
            case "list": {
                this.list(sender, args);
                break;
            }
            case "unpack": {
                unpack = true;
            }
            case "pack": {
                EntityPlayerMP player = args.length > 1 ? CommandBlockItem.func_82359_c((ICommandSender)sender, (String)args[1]) : CommandBlockItem.func_71521_c((ICommandSender)sender);
                int count = GlobalBanList.process(player.field_71093_bK, (IInventory)player.field_71071_by, unpack);
                sender.func_145747_a((IChatComponent)new ChatComponentText((unpack ? "Unlocked " : "Locked ") + count + " items."));
                break;
            }
            case "ban": {
                try {
                    Pair<String, BanListEntry> toBan = this.parse(sender, args);
                    GlobalBanList.worldInstance.add((String)toBan.k, (BanListEntry)toBan.v);
                    sender.func_145747_a(new ChatComponentText("Banned " + ((BanListEntry)toBan.v).toString() + " in " + (String)toBan.k).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GREEN)));
                    break;
                }
                catch (Exception e) {
                    if (e instanceof CommandException) {
                        throw e;
                    }
                    e.printStackTrace();
                    throw new WrongUsageException(e.getMessage(), new Object[0]);
                }
            }
            case "unban": {
                try {
                    Pair<String, BanListEntry> toBan = this.parse(sender, args);
                    if (GlobalBanList.worldInstance.remove((String)toBan.k, (BanListEntry)toBan.v)) {
                        sender.func_145747_a(new ChatComponentText("Unbanned " + ((BanListEntry)toBan.v).toString() + " in " + (String)toBan.k).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GREEN)));
                        break;
                    }
                    sender.func_145747_a(new ChatComponentText("Can't unban " + ((BanListEntry)toBan.v).toString() + " in " + (String)toBan.k).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
                    break;
                }
                catch (Exception e) {
                    if (e instanceof CommandException) {
                        throw e;
                    }
                    e.printStackTrace();
                    throw new WrongUsageException(e.getMessage(), new Object[0]);
                }
            }
        }
    }

    private Pair<String, BanListEntry> parse(ICommandSender sender, String[] args) {
        String dimensions = null;
        boolean wildcardOverride = false;
        int meta = Short.MAX_VALUE;
        BanListEntry banListEntry = null;
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("__GLOBAL__")) {
                dimensions = "__GLOBAL__";
                continue;
            }
            try {
                Helper.parseDimIds(args[i]);
                if (dimensions != null) {
                    throw new WrongUsageException("Double dimension specifiers: " + dimensions + " AND " + args[i], new Object[0]);
                }
                dimensions = args[i];
                continue;
            }
            catch (Exception exception) {
                try {
                    String[] split = args[i].split(":");
                    if (split.length > 3) {
                        throw new WrongUsageException("Item name not valid.", new Object[0]);
                    }
                    int n = meta = split.length == 3 ? CommandBlockItem.func_71526_a((ICommandSender)sender, (String)split[2]) : Short.MAX_VALUE;
                    if (banListEntry != null) {
                        throw new WrongUsageException("Double item specifiers: " + banListEntry + " AND " + args[i], new Object[0]);
                    }
                    banListEntry = new BanListEntry(split[0] + ":" + split[1], meta);
                    continue;
                }
                catch (Exception split) {
                    if (args[i].equals("*")) {
                        wildcardOverride = true;
                        continue;
                    }
                    throw new IllegalArgumentException("Not a dimension specifier or valid item: " + args[i]);
                }
            }
        }
        if (dimensions == null) {
            dimensions = String.valueOf(CommandBlockItem.func_71521_c((ICommandSender)sender).field_71093_bK);
        }
        if (banListEntry == null) {
            EntityPlayerMP player = CommandBlockItem.func_71521_c((ICommandSender)sender);
            ItemStack stack = player.func_70694_bm();
            if (stack == null) {
                throw new WrongUsageException("No item specified and no item held.", new Object[0]);
            }
            if (wildcardOverride) {
                meta = Short.MAX_VALUE;
            }
            banListEntry = new BanListEntry(GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b()), meta);
        }
        return new Pair<String, Object>(dimensions, banListEntry);
    }

    private void list(ICommandSender sender, HashSet<BanList> set) {
        for (BanList list : set) {
            sender.func_145747_a(new ChatComponentText("Dimension " + list.getDimension()).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.AQUA)));
            for (BanListEntry entry : list.banListEntryMap.values()) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(entry.toString()));
            }
        }
    }

    private void list(ICommandSender sender, String[] args) {
        HashSet<BanList> packSet = new HashSet<BanList>();
        HashSet<BanList> worldSet = new HashSet<BanList>();
        if (args.length == 1) {
            worldSet.addAll(GlobalBanList.worldInstance.dimesionMap.values());
            worldSet.add(GlobalBanList.worldInstance.getGlobal());
            if (GlobalBanList.packInstance != null) {
                packSet.addAll(GlobalBanList.packInstance.dimesionMap.values());
                packSet.add(GlobalBanList.packInstance.getGlobal());
            }
        } else {
            if (args[1].equalsIgnoreCase("__GLOBAL__")) {
                worldSet.add(GlobalBanList.worldInstance.getGlobal());
            } else {
                worldSet.addAll(GlobalBanList.worldInstance.dimesionMap.get((Object)this.getDimension(sender, args[1])));
            }
            if (GlobalBanList.packInstance != null) {
                if (args[1].equalsIgnoreCase("__GLOBAL__")) {
                    packSet.add(GlobalBanList.packInstance.getGlobal());
                } else {
                    packSet.addAll(GlobalBanList.packInstance.dimesionMap.get((Object)this.getDimension(sender, args[1])));
                }
            }
        }
        if (worldSet.isEmpty()) {
            sender.func_145747_a(new ChatComponentText("No world banned items.").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)));
        } else {
            sender.func_145747_a(new ChatComponentText("World banned items:").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)));
            this.list(sender, worldSet);
        }
        if (packSet.isEmpty()) {
            sender.func_145747_a(new ChatComponentText("No pack banned items. ").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)).func_150257_a(new ChatComponentText("[unchangeable]").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED))));
        } else {
            sender.func_145747_a(new ChatComponentText("Pack banned items: ").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)).func_150257_a(new ChatComponentText("[unchangeable]").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED))));
            this.list(sender, packSet);
        }
    }

    private int getDimension(ICommandSender sender, String arg) {
        try {
            return CommandBlockItem.func_71526_a((ICommandSender)sender, (String)arg);
        }
        catch (Exception e) {
            return CommandBlockItem.func_82359_c((ICommandSender)sender, (String)arg).field_71093_bK;
        }
    }

    public IChatComponent makeHelpText(String name, String text) {
        return new ChatComponentText(name).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.AQUA)).func_150257_a(new ChatComponentText(": " + text).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.WHITE)));
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (this.func_82358_a(args, args.length)) {
            return CommandBlockItem.func_71530_a((String[])args, (String[])MinecraftServer.func_71276_C().func_71213_z());
        }
        if (args.length == 1) {
            return CommandBlockItem.func_71530_a((String[])args, (String[])new String[]{"reload", "pack", "unpack", "list", "ban", "unban"});
        }
        if (args[0].equalsIgnoreCase("ban") || args[0].equalsIgnoreCase("unban")) {
            HashSet<String> set = new HashSet<String>();
            set.add("__GLOBAL__");
            set.addAll(Item.field_150901_e.func_148742_b());
            return CommandBlockItem.func_71531_a((String[])args, set);
        }
        return null;
    }

    public boolean func_82358_a(String[] args, int arg) {
        if (args.length == 0) {
            return false;
        }
        switch (args[0].toLowerCase()) {
            case "unpack": 
            case "pack": 
            case "list": {
                return arg == 2;
            }
        }
        return false;
    }

    public static class Pair<K, V> {
        public K k;
        public V v;

        public Pair(K k, V v) {
            this.k = k;
            this.v = v;
        }
    }
}

