/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.itemblacklist.data;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import cpw.mods.fml.common.Loader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import net.doubledoordev.itemblacklist.Helper;
import net.doubledoordev.itemblacklist.ItemBlacklist;
import net.doubledoordev.itemblacklist.data.BanList;
import net.doubledoordev.itemblacklist.data.BanListEntry;
import net.doubledoordev.itemblacklist.util.ItemBlacklisted;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;

public class GlobalBanList {
    public static final String GLOBAL_NAME = "__GLOBAL__";
    public static GlobalBanList worldInstance;
    public static GlobalBanList packInstance;
    public final Multimap<Integer, BanList> dimesionMap = HashMultimap.create();
    private BanList global = new BanList("__GLOBAL__");
    private File file;

    public static void init() {
        String string;
        File file = new File(MinecraftServer.func_71276_C().field_71305_c[0].func_72860_G().func_75765_b(), "ItemBlacklist".concat(".json"));
        if (file.exists()) {
            try {
                string = FileUtils.readFileToString((File)file, (String)"UTF-8");
                worldInstance = (GlobalBanList)Helper.GSON.fromJson(string, GlobalBanList.class);
            }
            catch (Exception e) {
                throw new RuntimeException("There was an error loading your config file. To prevent damage, the server will be closed.", e);
            }
        } else {
            worldInstance = new GlobalBanList();
            ItemBlacklist.logger.warn("No config file present.");
        }
        GlobalBanList.worldInstance.file = file;
        file = new File(Loader.instance().getConfigDir(), "ItemBlacklist".concat(".json"));
        if (file.exists()) {
            try {
                string = FileUtils.readFileToString((File)file, (String)"UTF-8");
                packInstance = (GlobalBanList)Helper.GSON.fromJson(string, GlobalBanList.class);
                GlobalBanList.packInstance.file = file;
            }
            catch (Exception e) {
                throw new RuntimeException("There was an error loading the modpack config file. To prevent damage, the server will be closed.", e);
            }
        } else {
            packInstance = null;
        }
    }

    public void save() {
        try {
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            FileUtils.writeStringToFile((File)this.file, (String)Helper.GSON.toJson((Object)this), (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isBanned(int dimensionId, ItemStack item) {
        if (worldInstance == null) {
            throw new IllegalStateException("Ban list not initialized.");
        }
        if (item == null || item.func_77973_b() == null) {
            return false;
        }
        if (packInstance != null) {
            if (GlobalBanList.packInstance.global.isBanned(item)) {
                return true;
            }
            for (BanList banList : GlobalBanList.packInstance.dimesionMap.get((Object)dimensionId)) {
                if (!banList.isBanned(item)) continue;
                return true;
            }
        }
        if (GlobalBanList.worldInstance.global.isBanned(item)) {
            return true;
        }
        for (BanList banList : GlobalBanList.worldInstance.dimesionMap.get((Object)dimensionId)) {
            if (!banList.isBanned(item)) continue;
            return true;
        }
        return false;
    }

    public static int process(int dim, Container container, EntityPlayer player) {
        return GlobalBanList.process(dim, container, player, false);
    }

    public static int process(int dim, Container container, EntityPlayer player, boolean unpackOnly) {
        int count = 0;
        for (Slot slot : container.field_75151_b) {
            ItemStack oldStack;
            ItemStack newStack;
            if (!slot.func_82869_a(player) || (newStack = GlobalBanList.process(dim, oldStack = slot.func_75211_c(), unpackOnly)) == oldStack) continue;
            if (slot.func_75214_a(oldStack)) {
                slot.func_75215_d(newStack);
            } else {
                slot.func_75215_d(null);
                player.func_71019_a(newStack, false);
            }
            ++count;
        }
        return count;
    }

    public static int process(int dim, IInventory inventory) {
        return GlobalBanList.process(dim, inventory, false);
    }

    public static int process(int dim, IInventory inventory, boolean unpackOnly) {
        int count = 0;
        int size = inventory.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            ItemStack processed;
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack == null || (processed = GlobalBanList.process(dim, itemStack, unpackOnly)) == itemStack) continue;
            ++count;
            inventory.func_70299_a(i, processed);
        }
        return count;
    }

    public static ItemStack process(int dim, ItemStack itemStack) {
        return GlobalBanList.process(dim, itemStack, false);
    }

    public static ItemStack process(int dim, ItemStack itemStack, boolean unpackOnly) {
        boolean banned;
        if (itemStack == null) {
            return null;
        }
        boolean packed = itemStack.func_77973_b() == ItemBlacklisted.I && ItemBlacklisted.canUnpack(itemStack);
        ItemStack unpacked = packed ? ItemBlacklisted.unpack(itemStack) : itemStack;
        boolean bl = banned = !unpackOnly && GlobalBanList.isBanned(dim, unpacked);
        if (packed && !banned) {
            return unpacked;
        }
        if (banned && !packed) {
            return ItemBlacklisted.pack(itemStack);
        }
        return itemStack;
    }

    public BanList checkDuplicate(String dimensions) {
        if (dimensions.equals(GLOBAL_NAME)) {
            return this.global;
        }
        BanList match = null;
        for (BanList banList : new HashSet(this.dimesionMap.values())) {
            if (!banList.getDimension().equals(dimensions)) continue;
            if (match != null) {
                throw new IllegalStateException("Duplicate banlist key. This is a serious issue. You should manually try to fix the json file!");
            }
            match = banList;
        }
        return match;
    }

    public void add(String dimensions, BanListEntry banListEntry) {
        BanList match = this.checkDuplicate(dimensions);
        if (match == null) {
            match = new BanList(dimensions);
            for (int i : match.getDimIds()) {
                this.dimesionMap.put((Object)i, (Object)match);
            }
        }
        if (match.banListEntryMap.containsEntry((Object)banListEntry.getItem(), (Object)banListEntry)) {
            throw new IllegalArgumentException("Duplicate ban list entry.");
        }
        match.banListEntryMap.put((Object)banListEntry.getItem(), (Object)banListEntry);
        this.save();
    }

    public boolean remove(String dimensions, BanListEntry banListEntry) {
        BanList match = this.checkDuplicate(dimensions);
        if (match == null) {
            return false;
        }
        if (!match.banListEntryMap.containsEntry((Object)banListEntry.getItem(), (Object)banListEntry)) {
            return false;
        }
        match.banListEntryMap.remove((Object)banListEntry.getItem(), (Object)banListEntry);
        this.save();
        return true;
    }

    public BanList getGlobal() {
        return this.global;
    }

    public static class Json
    implements JsonSerializer<GlobalBanList>,
    JsonDeserializer<GlobalBanList> {
        public GlobalBanList deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            GlobalBanList list = new GlobalBanList();
            JsonObject object = json.getAsJsonObject();
            for (Map.Entry entry : object.entrySet()) {
                if (list.global.getDimension().equals(entry.getKey())) {
                    list.global = (BanList)context.deserialize((JsonElement)entry.getValue(), BanList.class);
                    list.global.setDimension((String)entry.getKey());
                    continue;
                }
                BanList banList = (BanList)context.deserialize((JsonElement)entry.getValue(), BanList.class);
                banList.setDimension((String)entry.getKey());
                for (int i : banList.getDimIds()) {
                    list.dimesionMap.put((Object)i, (Object)banList);
                }
            }
            return list;
        }

        public JsonElement serialize(GlobalBanList src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject root = new JsonObject();
            root.add(src.global.getDimension(), context.serialize((Object)src.global));
            for (BanList banList : src.dimesionMap.values()) {
                if (root.has(banList.getDimension())) continue;
                root.add(banList.getDimension(), context.serialize((Object)banList));
            }
            return root;
        }
    }
}

