/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.itemblacklist.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Type;
import net.doubledoordev.itemblacklist.util.ItemBlacklisted;
import net.minecraft.item.Item;

public class BanListEntry {
    private Item item;
    private int damage = 0;

    public BanListEntry(GameRegistry.UniqueIdentifier uid, int damage) {
        this.item = GameRegistry.findItem((String)uid.modId, (String)uid.name);
        if (this.item == ItemBlacklisted.I) {
            throw new IllegalArgumentException("You can't ban the banning item.");
        }
        this.damage = damage;
        if (this.item == null) {
            throw new IllegalArgumentException(uid.toString() + " isn't a valid item.");
        }
    }

    public BanListEntry(String name, int damage) {
        this(new GameRegistry.UniqueIdentifier(name), damage);
    }

    public boolean isBanned(int damage) {
        return Short.MAX_VALUE == this.damage || damage == this.damage;
    }

    public Item getItem() {
        return this.item;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BanListEntry that = (BanListEntry)o;
        return this.damage == that.damage && this.item.equals(that.item);
    }

    public int hashCode() {
        int result = this.item.hashCode();
        result = 31 * result + this.damage;
        return result;
    }

    public String toString() {
        return GameRegistry.findUniqueIdentifierFor((Item)this.item).toString() + ' ' + (this.damage == Short.MAX_VALUE ? "*" : String.valueOf(this.damage));
    }

    public static class Json
    implements JsonSerializer<BanListEntry>,
    JsonDeserializer<BanListEntry> {
        public BanListEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String damageString;
            JsonObject object = json.getAsJsonObject();
            int damage = Short.MAX_VALUE;
            if (object.has("damage") && !(damageString = object.get("damage").getAsString()).equals("*")) {
                damage = Integer.parseInt(damageString);
            }
            return new BanListEntry(object.get("item").getAsString(), damage);
        }

        public JsonElement serialize(BanListEntry src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", GameRegistry.findUniqueIdentifierFor((Item)src.item).toString());
            if (src.damage == Short.MAX_VALUE) {
                jsonObject.addProperty("damage", "*");
            } else {
                jsonObject.addProperty("damage", (Number)src.damage);
            }
            return jsonObject;
        }
    }
}

