/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import cofh.api.item.IEmpowerableItem;
import cofh.api.item.IInventoryContainerItem;
import cofh.core.util.CoreUtils;
import cofh.core.util.KeyBindingEmpower;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.util.LexiconManager;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemLexicon
extends Item
implements IInventoryContainerItem,
IEmpowerableItem,
IBauble {
    public String modName = "thermalfoundation";
    public final String itemName;

    public ItemLexicon(String string) {
        this.itemName = string;
        this.func_77656_e(1);
        this.func_77625_d(1);
        this.func_77637_a(ThermalFoundation.tabCommon);
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        ItemStack itemStack = new ItemStack(item, 1, 0);
        this.setEmpoweredState(itemStack, false);
        list.add(itemStack);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean bl) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        list.add(StringHelper.getInfoText((String)"info.thermalfoundation.tome.lexicon.1"));
        if (this.isEmpowered(itemStack)) {
            list.add(StringHelper.localize((String)"info.thermalfoundation.tome.lexicon.4") + "\u00a7r");
            list.add("\u00a7e\u00a7o" + StringHelper.localize((String)"info.cofh.press") + " " + StringHelper.getKeyName((int)KeyBindingEmpower.instance.getKey()) + " " + StringHelper.localize((String)"info.thermalfoundation.tome.lexicon.5") + "\u00a7r");
        } else {
            list.add(StringHelper.localize((String)"info.thermalfoundation.tome.lexicon.2") + "\u00a7r");
            list.add("\u00a7b\u00a7o" + StringHelper.localize((String)"info.cofh.press") + " " + StringHelper.getKeyName((int)KeyBindingEmpower.instance.getKey()) + " " + StringHelper.localize((String)"info.thermalfoundation.tome.lexicon.3") + "\u00a7r");
        }
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        if (this.isEmpowered(itemStack)) {
            return EnumRarity.rare;
        }
        return EnumRarity.uncommon;
    }

    public boolean func_77662_d() {
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (CoreUtils.isFakePlayer((EntityPlayer)entityPlayer)) {
            return itemStack;
        }
        if (ServerHelper.isServerWorld((World)world) && LexiconManager.getSortedOreNames().size() > 0) {
            if (this.isEmpowered(itemStack)) {
                entityPlayer.openGui((Object)ThermalFoundation.instance, 2, world, 0, 0, 0);
            } else {
                entityPlayer.openGui((Object)ThermalFoundation.instance, 1, world, 0, 0, 0);
            }
        }
        return itemStack;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int n, boolean bl) {
        if (!this.isEmpowered(itemStack)) {
            return;
        }
        NBTTagCompound nBTTagCompound = entity.getEntityData();
        nBTTagCompound.func_74772_a("cofh.LexiconUpdate", entity.field_70170_p.func_82737_E());
    }

    public boolean hasCustomEntity(ItemStack itemStack) {
        return SecurityHelper.isSecure((ItemStack)itemStack);
    }

    public String func_77667_c(ItemStack itemStack) {
        if (this.isEmpowered(itemStack)) {
            return "item.thermalfoundation.tome.lexicon.empowered";
        }
        return "item.thermalfoundation.tome.lexicon";
    }

    public Entity createEntity(World world, Entity entity, ItemStack itemStack) {
        if (SecurityHelper.isSecure((ItemStack)itemStack)) {
            entity.field_83001_bt = true;
            entity.field_70178_ae = true;
            ((EntityItem)entity).lifespan = Integer.MAX_VALUE;
        }
        return null;
    }

    public Item func_77655_b(String string) {
        GameRegistry.registerItem((Item)this, (String)string);
        string = this.modName + "." + string;
        return super.func_77655_b(string);
    }

    public Item setUnlocalizedName(String string, String string2) {
        GameRegistry.registerItem((Item)this, (String)string2);
        string = this.modName + "." + string;
        return super.func_77655_b(string);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iIconRegister) {
        this.field_77791_bV = iIconRegister.func_94245_a(this.modName + ":" + this.func_77658_a().replace("item." + this.modName + ".", "") + "/" + StringHelper.titleCase((String)this.itemName));
    }

    public int getSizeInventory(ItemStack itemStack) {
        return 3;
    }

    public boolean isEmpowered(ItemStack itemStack) {
        return itemStack.field_77990_d == null ? false : itemStack.field_77990_d.func_74767_n("Empowered");
    }

    public boolean setEmpoweredState(ItemStack itemStack, boolean bl) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74757_a("Empowered", bl);
        return true;
    }

    public void onStateChange(EntityPlayer entityPlayer, ItemStack itemStack) {
        if (this.isEmpowered(itemStack)) {
            entityPlayer.field_70170_p.func_72956_a((Entity)entityPlayer, "ambient.weather.thunder", 0.4f, 1.0f);
        } else {
            entityPlayer.field_70170_p.func_72956_a((Entity)entityPlayer, "random.orb", 0.2f, 0.6f);
        }
    }

    @Override
    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.BELT;
    }

    @Override
    public void onWornTick(ItemStack itemStack, EntityLivingBase entityLivingBase) {
        if (!this.isEmpowered(itemStack)) {
            return;
        }
        NBTTagCompound nBTTagCompound = entityLivingBase.getEntityData();
        nBTTagCompound.func_74772_a("cofh.LexiconUpdate", entityLivingBase.field_70170_p.func_82737_E());
    }

    @Override
    public void onEquipped(ItemStack itemStack, EntityLivingBase entityLivingBase) {
    }

    @Override
    public void onUnequipped(ItemStack itemStack, EntityLivingBase entityLivingBase) {
    }

    @Override
    public boolean canEquip(ItemStack itemStack, EntityLivingBase entityLivingBase) {
        return true;
    }

    @Override
    public boolean canUnequip(ItemStack itemStack, EntityLivingBase entityLivingBase) {
        return true;
    }
}

