/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util;

import com.google.common.base.Objects;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ArrayHashList<E>
extends AbstractCollection<E>
implements List<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 3230581060536180693L;
    private transient Object[] elementData;
    protected transient int size;
    protected transient int mask;
    protected transient Entry[] hashTable;
    protected transient int modCount;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    private static int roundUpToPowerOf2(int n) {
        return n >= 0x40000000 ? 0x40000000 : (n > 2 ? Integer.highestOneBit(n - 1 << 1) : 2);
    }

    public ArrayHashList() {
        this.elementData = new Object[10];
        this.hashTable = new Entry[8];
        this.mask = 7;
    }

    public ArrayHashList(int n) {
        this.elementData = new Object[n];
        n = ArrayHashList.roundUpToPowerOf2(n) >> 1;
        this.hashTable = new Entry[n];
        this.mask = n - 1;
    }

    public ArrayHashList(Collection<E> collection) {
        int n = collection.size();
        this.elementData = new Object[n];
        n = ArrayHashList.roundUpToPowerOf2(n) >> 1;
        this.hashTable = new Entry[n];
        this.mask = n - 1;
        this.addAll(collection);
    }

    protected int hash(Object object) {
        int n = object == null ? 0 : object.hashCode();
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    @Override
    public int size() {
        return this.size;
    }

    protected void add(E e, int n) {
        this.ensureCapacityInternal(this.size + 1);
        this.elementData[this.size++] = e;
        this.insert(new Entry(e, n));
        this.rehashIfNecessary();
    }

    @Override
    public boolean add(E e) {
        int n = this.hash(e);
        if (this.seek(e, n) != null) {
            return false;
        }
        this.add(e, n);
        return true;
    }

    @Override
    public E set(int n, E e) {
        this.checkElementIndex(n);
        int n2 = this.hash(e);
        if (this.seek(e, n2) != null) {
            throw new IllegalArgumentException("Duplicate entries not allowed");
        }
        ++this.modCount;
        Entry entry = this.seek(this.elementData[n], this.hash(this.elementData[n]));
        this.delete(entry);
        this.elementData[n] = e;
        this.insert(new Entry(e, n2));
        return (E)entry.key;
    }

    @Override
    public void add(int n, E e) {
        this.checkPositionIndex(n);
        int n2 = this.hash(e);
        if (this.seek(e, n2) != null) {
            throw new IllegalArgumentException("Duplicate entries not allowed");
        }
        if (n == this.size) {
            this.add(e, n2);
            return;
        }
        this.ensureCapacityInternal(++this.size);
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.size - n - 1);
        this.elementData[n] = e;
        this.insert(new Entry(e, n2));
        this.rehashIfNecessary();
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        if (collection.size() == 0) {
            return false;
        }
        for (E e : collection) {
            this.add(n++, e);
        }
        return true;
    }

    @Override
    public E get(int n) {
        this.checkElementIndex(n);
        return this.index(n);
    }

    @Override
    public int indexOf(Object object) {
        Entry entry = this.seek(object, this.hash(object));
        if (entry == null) {
            return -1;
        }
        Object object2 = entry.key;
        Object[] objectArray = this.elementData;
        int n = this.size;
        while (n-- > 0 && objectArray[n] != object2) {
        }
        return n;
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    @Override
    public boolean contains(Object object) {
        return this.seek(object, this.hash(object)) != null;
    }

    @Override
    public E remove(int n) {
        this.checkElementIndex(n);
        E e = this.index(n);
        this.delete(this.seek(e, this.hash(e)));
        this.fastRemove(n);
        return e;
    }

    @Override
    public boolean remove(Object object) {
        Entry entry = this.seek(object, this.hash(object));
        if (entry == null) {
            return false;
        }
        Object object2 = entry.key;
        Object[] objectArray = this.elementData;
        int n = this.size;
        while (n-- > 0) {
            if (objectArray[n] != object2) continue;
            this.fastRemove(n);
            break;
        }
        this.delete(entry);
        return true;
    }

    private void fastRemove(int n) {
        ++this.modCount;
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
    }

    @Override
    public void clear() {
        int n;
        ++this.modCount;
        for (n = 0; n < this.size; ++n) {
            this.elementData[n] = null;
        }
        n = this.hashTable.length;
        while (n-- > 0) {
            this.hashTable[n] = null;
        }
        this.size = 0;
    }

    public void trimToSize() {
        ++this.modCount;
        if (this.size < this.elementData.length) {
            this.elementData = Arrays.copyOf(this.elementData, this.size);
        }
    }

    public void ensureCapacity(int n) {
        if (n > 0) {
            this.ensureCapacityInternal(n);
        }
    }

    private void ensureCapacityInternal(int n) {
        ++this.modCount;
        if (n - this.elementData.length > 0) {
            this.grow(n);
        }
    }

    private void grow(int n) {
        int n2 = this.elementData.length;
        int n3 = n2 + (n2 >> 1);
        if (n3 - n < 0) {
            n3 = n;
        }
        if (n3 - 0x7FFFFFF7 > 0) {
            n3 = ArrayHashList.hugeCapacity(n);
        }
        this.elementData = Arrays.copyOf(this.elementData, n3);
    }

    private static int hugeCapacity(int n) {
        if (n < 0) {
            throw new OutOfMemoryError();
        }
        return n > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.modCount;
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeObject(this.elementData[i]);
        }
        if (this.modCount != n) {
            throw new ConcurrentModificationException();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.elementData = new Object[10];
        this.hashTable = new Entry[8];
        this.mask = 7;
        this.size = 0;
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n > 0) {
            this.ensureCapacityInternal(n);
            for (int i = 0; i < n; ++i) {
                this.add(objectInputStream.readObject());
            }
        }
    }

    E index(int n) {
        return (E)this.elementData[n];
    }

    protected Entry seek(Object object, int n) {
        Entry entry = this.hashTable[n & this.mask];
        while (entry != null) {
            if (n == entry.hash && Objects.equal((Object)object, (Object)entry.key)) {
                return entry;
            }
            entry = entry.nextInBucket;
        }
        return null;
    }

    protected void insert(Entry entry) {
        int n = entry.hash & this.mask;
        entry.nextInBucket = this.hashTable[n];
        this.hashTable[n] = entry;
    }

    protected void delete(Entry entry) {
        Entry[] entryArray = this.hashTable;
        synchronized (this.hashTable) {
            block6: {
                int n = entry.hash & this.mask;
                Entry entry2 = null;
                Entry entry3 = this.hashTable[n];
                if (entry3 == entry) {
                    this.hashTable[n] = entry3.nextInBucket;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    break block6;
                }
                while (true) {
                    if (entry3 == entry) {
                        entry2.nextInBucket = entry.nextInBucket;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        break;
                    }
                    entry2 = entry3;
                    entry3 = entry3.nextInBucket;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void rehashIfNecessary() {
        Entry[] entryArray = this.hashTable;
        if (this.size <= entryArray.length * 2 || entryArray.length >= 0x40000000) return;
        Entry[] entryArray2 = this.hashTable;
        synchronized (this.hashTable) {
            int n = entryArray.length * 2;
            int n2 = n - 1;
            Entry[] entryArray3 = new Entry[n];
            int n3 = entryArray.length;
            while (n3-- > 0) {
                Entry entry = entryArray[n3];
                while (entry != null) {
                    Entry entry2 = entry.nextInBucket;
                    int n4 = entry.hash & n2;
                    entry.nextInBucket = entryArray3[n4];
                    entryArray3[n4] = entry;
                    entry = entry2;
                }
            }
            this.hashTable = entryArray3;
            this.mask = n2;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    public ArrayHashList<E> clone() {
        return new ArrayHashList<E>(this);
    }

    @Override
    public List<E> subList(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        return new ListItr(n);
    }

    protected boolean isElementIndex(int n) {
        return n >= 0 && n < this.size;
    }

    protected boolean isPositionIndex(int n) {
        return n >= 0 && n <= this.size;
    }

    protected String outOfBoundsMsg(int n) {
        return "Index: " + n + ", Size: " + this.size;
    }

    protected void checkElementIndex(int n) {
        if (!this.isElementIndex(n)) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
    }

    protected void checkPositionIndex(int n) {
        if (!this.isPositionIndex(n)) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int n) {
            this.cursor = n;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            int n = this.cursor - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayHashList.this.elementData;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = n;
            this.lastRet = n;
            return objectArray[this.lastRet];
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArrayHashList.this.set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            try {
                int n = this.cursor;
                ArrayHashList.this.add(n, e);
                this.cursor = n + 1;
                this.lastRet = -1;
                this.expectedModCount = ArrayHashList.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = ArrayHashList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ArrayHashList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            int n = this.cursor;
            if (n >= ArrayHashList.this.size) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayHashList.this.elementData;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = n + 1;
            this.lastRet = n;
            return objectArray[this.lastRet];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArrayHashList.this.remove(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
                this.expectedModCount = ArrayHashList.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (ArrayHashList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    protected static final class Entry {
        final Object key;
        final int hash;
        Entry nextInBucket;

        protected Entry(Object object, int n) {
            this.key = object;
            this.hash = n;
        }
    }
}

