/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import techguns.TGItems;
import techguns.TGPackets;
import techguns.Techguns;
import techguns.entities.npc.NPCTurret;
import techguns.items.guns.GenericGun;
import techguns.packets.RequestTileEntitySync;
import techguns.tileentities.BasicPoweredTileEnt;
import techguns.util.ItemUtil;

public class TurretBaseEnt
extends BasicPoweredTileEnt {
    public NPCTurret mountedTurret = null;
    protected ItemStack lastWeapon = null;
    private long lastRequest = 0L;
    public boolean turretDeath = false;
    public int repairTime = 0;
    public int turretHealTime = 0;

    public TurretBaseEnt() {
        super(20, 1000);
    }

    public void spawnTurret(World w, int x, int y, int z) {
        if (!w.field_72995_K) {
            this.mountedTurret = new NPCTurret(w, this);
            this.mountedTurret.func_70107_b((double)x + 0.5, y + 1, (double)z + 0.5);
            w.func_72838_d((Entity)this.mountedTurret);
        }
    }

    public void spawnTurret(World w, int x, int y, int z, float health) {
        if (!w.field_72995_K) {
            this.mountedTurret = new NPCTurret(w, this);
            this.mountedTurret.func_70107_b((double)x + 0.5, y + 1, (double)z + 0.5);
            this.mountedTurret.func_70606_j(health);
            w.func_72838_d((Entity)this.mountedTurret);
        }
    }

    public ResourceLocation getTurretBaseTexture() {
        return NPCTurret.getTexture(this.getTurretArmorValue());
    }

    public int getTurretArmorValue() {
        ItemStack armor = this.content[19];
        if (armor != null) {
            if (ItemUtil.isItemEqual(armor, TGItems.turretArmorIron)) {
                return 5;
            }
            if (ItemUtil.isItemEqual(armor, TGItems.turretArmorSteel)) {
                return 10;
            }
            if (ItemUtil.isItemEqual(armor, TGItems.turretArmorObsidianSteel)) {
                return 15;
            }
            if (ItemUtil.isItemEqual(armor, TGItems.turretArmorCarbon)) {
                return 20;
            }
        }
        return 0;
    }

    @Override
    public void readEntityDataFromNBT(NBTTagCompound tags) {
        super.readEntityDataFromNBT(tags);
        if (tags.func_74764_b("mountedTurret")) {
            Entity ent;
            if (this.field_145850_b != null && (ent = this.field_145850_b.func_73045_a(tags.func_74762_e("mountedTurret"))) != null) {
                this.mountedTurret = (NPCTurret)ent;
                this.mountedTurret.setTileEnt(this);
            }
        } else {
            this.mountedTurret = null;
        }
        this.turretDeath = tags.func_74767_n("turretDeath");
        this.repairTime = tags.func_74762_e("repairTime");
        this.turretHealTime = tags.func_74762_e("turretHealTime");
    }

    @Override
    public void writeEntityDataToNBT(NBTTagCompound tags) {
        super.writeEntityDataToNBT(tags);
        if (this.mountedTurret != null) {
            tags.func_74768_a("mountedTurret", this.mountedTurret.func_145782_y());
        }
        tags.func_74757_a("turretDeath", this.turretDeath);
        tags.func_74768_a("repairTime", this.repairTime);
        tags.func_74768_a("turretHealTime", this.turretHealTime);
    }

    public boolean hasMountedTurret() {
        return this.mountedTurret != null;
    }

    public ItemStack getWeapon() {
        if (this.content[18] != null && this.content[18].func_77973_b() instanceof GenericGun) {
            return this.content[18];
        }
        return null;
    }

    public boolean consumeAmmo() {
        ItemStack gunstack = this.getWeapon();
        if (gunstack != null) {
            GenericGun gun = (GenericGun)gunstack.func_77973_b();
            if (gun.getCurrentAmmo(gunstack) <= 0) {
                this.doReload(gunstack);
            }
            if (gun.getCurrentAmmo(gunstack) >= 1) {
                gun.useAmmo(gunstack, 1);
                return true;
            }
        }
        return false;
    }

    protected void doReload(ItemStack gunstack) {
        GenericGun gun = (GenericGun)gunstack.func_77973_b();
        ItemStack ammo = gun.getAmmo();
        ItemStack emptyMag = gun.getEmptyMag();
        if (Techguns.consumeAmmo(this.content, ammo, 0, 9)) {
            if (emptyMag != null) {
                int tooMuch = Techguns.addItemToInventory(this.content, TGItems.newStack(emptyMag, 1), 9, 18);
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, TGItems.newStack(emptyMag, tooMuch)));
                }
            }
            if (gun.getAmmoCount() > 1) {
                int i;
                for (i = 1; i < gun.getAmmoCount() && Techguns.consumeAmmo(this.content, ammo, 0, 9); ++i) {
                }
                gun.reloadAmmo(gunstack, i);
            } else {
                gun.reloadAmmo(gunstack);
            }
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.func_70296_d();
            }
        }
    }

    public boolean isTurretDeath() {
        return this.turretDeath;
    }

    public int getRepairTime() {
        return this.repairTime;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.mountedTurret != null && this.mountedTurret.func_70694_bm() != this.lastWeapon) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.func_70296_d();
                this.lastWeapon = this.mountedTurret.func_70694_bm();
                this.mountedTurret.setCombatTask();
            }
        } else if (this.mountedTurret == null && !this.turretDeath) {
            if (Minecraft.func_71386_F() - this.lastRequest > 1000L) {
                TGPackets.network.sendToServer((IMessage)new RequestTileEntitySync(this.field_145851_c, (short)this.field_145848_d, this.field_145849_e));
                this.lastRequest = Minecraft.func_71386_F();
            }
        } else if (this.mountedTurret != null && this.mountedTurret.mountedTileEnt == null) {
            this.mountedTurret.setTileEnt(this);
        }
        if (this.turretDeath) {
            if (this.isRedstoneEnabled()) {
                if (this.consumePower(50)) {
                    --this.repairTime;
                }
                if (this.repairTime <= 0) {
                    this.repairTime = 0;
                    this.turretDeath = false;
                    if (!this.field_145850_b.field_72995_K) {
                        this.spawnTurret(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 10.0f);
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        this.func_70296_d();
                    }
                }
            }
        } else if (this.mountedTurret != null) {
            if (this.isRedstoneEnabled()) {
                if (!this.consumePower(5)) {
                    if (this.mountedTurret.active) {
                        this.mountedTurret.disable();
                        this.mountedTurret.active = false;
                    }
                } else if (!this.mountedTurret.active) {
                    this.mountedTurret.active = true;
                    this.mountedTurret.setAITasks();
                    this.mountedTurret.setCombatTask();
                }
                if (this.turretHealTime <= 0) {
                    if (this.mountedTurret.func_110143_aJ() < this.mountedTurret.func_110138_aP() && this.consumePower(500)) {
                        this.mountedTurret.func_70691_i(1.0f);
                        this.turretHealTime = 60;
                    }
                } else {
                    --this.turretHealTime;
                }
            } else if (this.mountedTurret.active) {
                this.mountedTurret.disable();
                this.mountedTurret.active = false;
            }
        }
    }

    public NPCTurret getMountedTurret() {
        return this.mountedTurret;
    }

    public void setMountedTurret(NPCTurret mountedTurret) {
        this.mountedTurret = mountedTurret;
    }

    public void onTurretDeath() {
        if (!this.field_145850_b.field_72995_K) {
            this.mountedTurret = null;
            this.turretDeath = true;
            this.repairTime = 200;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
    }

    public void breakTurret() {
        if (this.mountedTurret != null) {
            this.mountedTurret.func_70606_j(0.0f);
            this.mountedTurret.func_70106_y();
        }
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection dir) {
        return dir != ForgeDirection.UP;
    }

    public int[] func_94128_d(int side) {
        if (side == 0) {
            return new int[0];
        }
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return side != 0 && slot < 9;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return side != 0 && slot >= 9 && slot < 18;
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.name : "techguns.container.turretbase";
    }

    public int getRepairTimeScaled(int max) {
        int totaltime = 200;
        return max - this.repairTime * max / totaltime;
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        if (slot == 18) {
            return item.func_77973_b() instanceof GenericGun;
        }
        return true;
    }
}

