/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import techguns.inventory.ReactionBeamFocus;
import techguns.inventory.ReactionChamberRecipe;
import techguns.tileentities.ReactionChamberTileEntMaster;

public class ReactionChamberOperation {
    public static byte RECIPE_TICKRATE = (byte)60;
    public ReactionChamberRecipe recipe;
    public byte preferedIntensity;
    public byte nextTick;
    public short duration;
    public short maxDuration;
    public short requiredCompletion;
    public short completion;
    public byte liquidLevel;
    public int powerPerRecipeTick;

    public ReactionChamberOperation(ReactionChamberRecipe recipe) {
        this.recipe = recipe;
        this.nextTick = RECIPE_TICKRATE;
        if (recipe != null) {
            this.preferedIntensity = recipe.preferredIntensity;
            this.maxDuration = (short)(recipe.ticks * RECIPE_TICKRATE);
            this.requiredCompletion = recipe.requiredCompletion;
            this.liquidLevel = recipe.liquidLevel;
            this.powerPerRecipeTick = recipe.RFTick;
        } else {
            this.preferedIntensity = 0;
            this.duration = 0;
            this.requiredCompletion = 0;
            this.liquidLevel = 0;
            this.powerPerRecipeTick = 0;
        }
        this.duration = 0;
        this.completion = 0;
    }

    public void readDataFromNBT(NBTTagCompound operationData) {
        this.duration = operationData.func_74765_d("duration");
        this.maxDuration = operationData.func_74765_d("maxDuration");
        this.completion = operationData.func_74765_d("completion");
        this.requiredCompletion = operationData.func_74765_d("requiredCompletion");
        this.preferedIntensity = operationData.func_74771_c("preferedIntensity");
        this.liquidLevel = operationData.func_74771_c("liquidLevel");
        this.powerPerRecipeTick = operationData.func_74762_e("powerPerTick");
        this.nextTick = operationData.func_74771_c("nextTick");
    }

    public void writeDataToNBT(NBTTagCompound tags) {
        NBTTagCompound operationData = new NBTTagCompound();
        operationData.func_74777_a("recipeID", this.recipe.getID());
        operationData.func_74777_a("duration", this.duration);
        operationData.func_74777_a("maxDuration", this.maxDuration);
        operationData.func_74777_a("requiredCompletion", this.requiredCompletion);
        operationData.func_74777_a("completion", this.completion);
        operationData.func_74774_a("preferedIntensity", this.preferedIntensity);
        operationData.func_74774_a("liquidLevel", this.liquidLevel);
        operationData.func_74768_a("powerPerTick", this.powerPerRecipeTick);
        operationData.func_74774_a("nextTick", this.nextTick);
        tags.func_74782_a("operationData", (NBTBase)operationData);
    }

    public boolean focusMatches(ItemStack item) {
        return this.recipe.beamFocus == ReactionBeamFocus.getBeamFocus(item);
    }

    public boolean tick(byte intensity, byte liquidLevel, boolean client, ReactionChamberTileEntMaster tile, int RFTick) {
        this.nextTick = (byte)(this.nextTick - 1);
        this.duration = (short)(this.duration + 1);
        if (!client && this.nextTick == 0 && this.duration < this.maxDuration) {
            double f;
            boolean powered = tile.consumePower(RFTick);
            if (powered && this.preferedIntensity == intensity && this.liquidLevel == liquidLevel) {
                this.completion = (short)(this.completion + 1);
            }
            if ((f = Math.random()) <= 0.333) {
                if (this.preferedIntensity > this.recipe.preferredIntensity - this.recipe.intensityMargin) {
                    this.preferedIntensity = (byte)(this.preferedIntensity - 1);
                }
            } else if (!(f <= 0.666) && this.preferedIntensity < this.recipe.preferredIntensity + this.recipe.intensityMargin) {
                this.preferedIntensity = (byte)(this.preferedIntensity + 1);
            }
            this.nextTick = RECIPE_TICKRATE;
            return true;
        }
        return this.isFinished();
    }

    public boolean isFinished() {
        return this.duration >= this.maxDuration || this.completion >= this.requiredCompletion;
    }

    public boolean isSuccess() {
        return this.completion >= this.requiredCompletion;
    }

    public boolean isFailure() {
        return this.duration >= this.maxDuration;
    }

    public int getCurrentPreferedIntensity() {
        return this.preferedIntensity;
    }
}

