/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import techguns.TGConfig;
import techguns.TGItems;
import techguns.Techguns;
import techguns.blocks.ItemBlockOreDrill;
import techguns.blocks.OreCluster;
import techguns.blocks.machines.OreDrillBlock;
import techguns.tileentities.MultiBlockMasterTileEntBase;
import techguns.util.BlockCoords;

public class OreDrillTileEntMaster
extends MultiBlockMasterTileEntBase {
    public byte dir = 0;
    public byte radius = 0;
    public short enginesize = 0;
    public short rodsize = 0;
    public boolean haspower = false;
    private int soundLoopDelay = 0;
    public int currentRFperTick = 0;
    public ItemStack lastDrill = null;
    public boolean hasDrill = false;
    public int drillType = 0;

    public OreDrillTileEntMaster() {
        super(10, 500000);
        this.useRangeSquared = 128.0;
    }

    private int getPowerPerTick() {
        return this.currentRFperTick;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.complete) {
            int r;
            int n = r = this.radius == 2 ? 2 : 1;
            if (this.dir == 0) {
                return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - r), (double)this.field_145848_d, (double)(this.field_145849_e - r), (double)(this.field_145851_c + r), (double)(this.field_145848_d + this.enginesize + this.rodsize), (double)(this.field_145849_e + r));
            }
            if (this.dir == 1) {
                return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - r), (double)(this.field_145848_d - this.enginesize - this.rodsize), (double)(this.field_145849_e - r), (double)(this.field_145851_c + r), (double)this.field_145848_d, (double)(this.field_145849_e + r));
            }
            if (this.dir == 2) {
                return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d - r), (double)(this.field_145849_e - r), (double)(this.field_145851_c + this.enginesize + this.rodsize), (double)(this.field_145848_d + r), (double)(this.field_145849_e + r));
            }
            if (this.dir == 3) {
                return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - this.enginesize - this.rodsize), (double)(this.field_145848_d - r), (double)(this.field_145849_e - r), (double)this.field_145851_c, (double)(this.field_145848_d + r), (double)(this.field_145849_e + r));
            }
            if (this.dir == 4) {
                return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - r), (double)(this.field_145848_d - r), (double)this.field_145849_e, (double)(this.field_145851_c + r), (double)(this.field_145848_d + r), (double)(this.field_145849_e + this.enginesize + this.rodsize));
            }
            if (this.dir == 5) {
                return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - r), (double)(this.field_145848_d - r), (double)(this.field_145849_e - this.enginesize - this.rodsize), (double)(this.field_145851_c + r), (double)(this.field_145848_d + r), (double)this.field_145849_e);
            }
            return super.getRenderBoundingBox();
        }
        return super.getRenderBoundingBox();
    }

    public void func_145845_h() {
        if (this.complete && this.hasDrill && this.isRedstoneEnabled()) {
            if (this.currentOperation == null) {
                if (!this.field_145850_b.field_72995_K) {
                    this.checkAndStartOperation();
                }
            } else if (this.progress < this.totalTime) {
                if (!this.field_145850_b.field_72995_K && this.checkDrill()) {
                    if (this.consumePower(this.getPowerPerTick())) {
                        ++this.progress;
                        if (!this.haspower) {
                            this.haspower = true;
                            this.needUpdate();
                        }
                    } else if (this.haspower) {
                        this.haspower = false;
                        this.needUpdate();
                    }
                } else if (this.haspower) {
                    ++this.progress;
                    this.playAmbientSound();
                }
            } else if (!this.field_145850_b.field_72995_K) {
                int leftover = Techguns.addItemToInventory(this.content, new ItemStack(this.currentOperation.func_77973_b(), this.currentOperation.field_77994_a, this.currentOperation.func_77960_j()), 1, 10);
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, TGItems.newStack(this.currentOperation, leftover)));
                this.currentOperation = null;
                this.checkAndStartOperation();
            }
        }
    }

    private void playAmbientSound() {
        if (this.soundLoopDelay-- <= 0) {
            if (this.radius == 0) {
                this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "techguns:machines.oredrillSmallWork", 1.5f, 1.0f, true);
                this.soundLoopDelay = 61;
            } else if (this.radius <= 2) {
                this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "techguns:machines.oredrillMediumWork", 2.25f, 1.0f, true);
                this.soundLoopDelay = 61;
            } else {
                this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "techguns:machines.oredrillLargeWork", 3.0f, 1.0f, true);
                this.soundLoopDelay = 61;
            }
        }
    }

    public int getClusterSize(int count, int x, int y, int z, ArrayList<BlockCoords> visited, OreCluster clusterType, int clusterMeta) {
        Block target = this.field_145850_b.func_147439_a(x, y, z);
        int targetmeta = this.field_145850_b.func_72805_g(x, y, z);
        BlockCoords block = new BlockCoords(x, y, z);
        if (target instanceof OreCluster && !visited.contains(block)) {
            OreCluster cluster = (OreCluster)target;
            if (clusterType == cluster && clusterMeta == targetmeta) {
                ++count;
                visited.add(block);
                count = this.getClusterSize(count, x + 1, y, z, visited, clusterType, clusterMeta);
                count = this.getClusterSize(count, x - 1, y, z, visited, clusterType, clusterMeta);
                count = this.getClusterSize(count, x, y + 1, z, visited, clusterType, clusterMeta);
                count = this.getClusterSize(count, x, y - 1, z, visited, clusterType, clusterMeta);
                count = this.getClusterSize(count, x, y, z + 1, visited, clusterType, clusterMeta);
                count = this.getClusterSize(count, x, y, z - 1, visited, clusterType, clusterMeta);
                return count;
            }
            return count;
        }
        return count;
    }

    protected boolean checkDrill() {
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            if (this.lastDrill == null && this.content[0] == null) {
                this.hasDrill = false;
                this.needUpdate();
                return false;
            }
            if (this.lastDrill == null) {
                this.lastDrill = this.content[0];
                return true;
            }
            if (this.content[0] == null || !this.lastDrill.func_77969_a(this.content[0])) {
                this.lastDrill = this.content[0];
                this.currentOperation = null;
                this.progress = 0;
                this.totalTime = 0;
                this.currentRFperTick = 0;
                this.needUpdate();
                return false;
            }
        }
        return true;
    }

    public void checkAndStartOperation() {
        int distance = this.rodsize + this.enginesize + 1;
        int[] targetPos = OreDrillBlock.getNextBlockInDirOffset(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.dir, distance);
        if (ItemBlockOreDrill.isOreCluster(this.field_145850_b, targetPos[0], targetPos[1], targetPos[2])) {
            OreCluster cluster = (OreCluster)this.field_145850_b.func_147439_a(targetPos[0], targetPos[1], targetPos[2]);
            int meta = this.field_145850_b.func_72805_g(targetPos[0], targetPos[1], targetPos[2]);
            int drillheadmininglevel = this.getDrillItemMiningLevel();
            if (drillheadmininglevel > 0) {
                this.hasDrill = true;
                int effectivemininglevel = drillheadmininglevel + this.radius - cluster.mininglevels[meta];
                this.drillType = this.getDrillType();
                if (effectivemininglevel >= 0) {
                    int clustersize = this.getClusterSize(0, targetPos[0], targetPos[1], targetPos[2], new ArrayList<BlockCoords>(), cluster, meta);
                    int effectiveclustersize = Math.min(clustersize, this.getTotalDrillLength());
                    this.currentOperation = TGItems.newStack(cluster.ores[meta], 1);
                    this.progress = 0;
                    double orePerHour = ((double)(effectiveclustersize * 3) + (double)(effectiveclustersize * effectivemininglevel) * 0.5) * (double)TGConfig.oreDrillMultiplierOres;
                    this.totalTime = (int)(60.0 / orePerHour * 1200.0);
                    this.currentRFperTick = (int)(80.0 * orePerHour * (double)Math.max(this.radius, 1) * (double)TGConfig.oreDrillMultiplierPower);
                } else {
                    this.currentOperation = new ItemStack(Blocks.field_150347_e, 1);
                    this.progress = 0;
                    this.totalTime = 400;
                    this.currentRFperTick = (int)(240.0f * TGConfig.oreDrillMultiplierPower);
                }
            } else {
                this.hasDrill = false;
                this.drillType = 0;
            }
            this.needUpdate();
        } else {
            System.out.println("There is no ore Cluster at drill point, multiblock broken");
            this.complete = false;
            this.needUpdate();
        }
    }

    public int getDrillItemMiningLevel() {
        ItemStack drill = this.content[0];
        if (drill != null && this.isComplete()) {
            int mininglevel = -1;
            if (this.radius == 0) {
                if (drill.func_77973_b() == TGItems.sharedItem) {
                    if (drill.func_77960_j() == TGItems.oreDrillSmallSteel.func_77960_j()) {
                        mininglevel = 1;
                    } else if (drill.func_77960_j() == TGItems.oreDrillSmallObsidianSteel.func_77960_j()) {
                        mininglevel = 2;
                    } else if (drill.func_77960_j() == TGItems.oreDrillSmallCarbon.func_77960_j()) {
                        mininglevel = 3;
                    }
                }
            } else if (this.radius == 1 || this.radius == 2) {
                if (drill.func_77973_b() == TGItems.sharedItem) {
                    if (drill.func_77960_j() == TGItems.oreDrillMediumSteel.func_77960_j()) {
                        mininglevel = 1;
                    } else if (drill.func_77960_j() == TGItems.oreDrillMediumObsidianSteel.func_77960_j()) {
                        mininglevel = 2;
                    } else if (drill.func_77960_j() == TGItems.oreDrillMediumCarbon.func_77960_j()) {
                        mininglevel = 3;
                    }
                }
            } else if ((this.radius == 3 || this.radius == 4) && drill.func_77973_b() == TGItems.sharedItem) {
                if (drill.func_77960_j() == TGItems.oreDrillLargeSteel.func_77960_j()) {
                    mininglevel = 1;
                } else if (drill.func_77960_j() == TGItems.oreDrillLargeObsidianSteel.func_77960_j()) {
                    mininglevel = 2;
                } else if (drill.func_77960_j() == TGItems.oreDrillLargeCarbon.func_77960_j()) {
                    mininglevel = 3;
                }
            }
            return mininglevel;
        }
        return -1;
    }

    protected int getDrillType() {
        ItemStack drill = this.content[0];
        if (drill != null && this.isComplete()) {
            int drilltype = 0;
            if (this.radius == 0) {
                if (drill.func_77973_b() == TGItems.sharedItem) {
                    if (drill.func_77960_j() == TGItems.oreDrillSmallSteel.func_77960_j()) {
                        drilltype = 1;
                    } else if (drill.func_77960_j() == TGItems.oreDrillSmallObsidianSteel.func_77960_j()) {
                        drilltype = 2;
                    } else if (drill.func_77960_j() == TGItems.oreDrillSmallCarbon.func_77960_j()) {
                        drilltype = 3;
                    }
                }
            } else if (this.radius == 1 || this.radius == 2) {
                if (drill.func_77973_b() == TGItems.sharedItem) {
                    if (drill.func_77960_j() == TGItems.oreDrillMediumSteel.func_77960_j()) {
                        drilltype = 1;
                    } else if (drill.func_77960_j() == TGItems.oreDrillMediumObsidianSteel.func_77960_j()) {
                        drilltype = 2;
                    } else if (drill.func_77960_j() == TGItems.oreDrillMediumCarbon.func_77960_j()) {
                        drilltype = 3;
                    }
                }
            } else if ((this.radius == 3 || this.radius == 4) && drill.func_77973_b() == TGItems.sharedItem) {
                if (drill.func_77960_j() == TGItems.oreDrillLargeSteel.func_77960_j()) {
                    drilltype = 1;
                } else if (drill.func_77960_j() == TGItems.oreDrillLargeObsidianSteel.func_77960_j()) {
                    drilltype = 2;
                } else if (drill.func_77960_j() == TGItems.oreDrillLargeCarbon.func_77960_j()) {
                    drilltype = 3;
                }
            }
            return drilltype;
        }
        return 0;
    }

    public int getTotalDrillLength() {
        return this.enginesize + this.rodsize;
    }

    public void setMultiblockFormed(byte dir, byte radius, short enginesize, short rodsize) {
        this.dir = dir;
        this.radius = radius;
        this.enginesize = enginesize;
        this.rodsize = rodsize;
        this.complete = true;
        this.hasDrill = false;
    }

    @Override
    public void readEntityDataFromNBT(NBTTagCompound tags) {
        super.readEntityDataFromNBT(tags);
        this.complete = tags.func_74767_n("complete");
        if (this.complete) {
            this.dir = tags.func_74771_c("dir");
            this.radius = tags.func_74771_c("radius");
            this.enginesize = tags.func_74765_d("enginesize");
            this.rodsize = tags.func_74765_d("rodsize");
            this.haspower = tags.func_74767_n("haspower");
            this.currentRFperTick = tags.func_74762_e("currentRFperTick");
            this.hasDrill = tags.func_74767_n("hasDrill");
            this.drillType = tags.func_74771_c("drillType");
        }
    }

    @Override
    public void writeEntityDataToNBT(NBTTagCompound tags) {
        super.writeEntityDataToNBT(tags);
        tags.func_74757_a("complete", this.complete);
        if (this.complete) {
            tags.func_74774_a("dir", this.dir);
            tags.func_74774_a("radius", this.radius);
            tags.func_74777_a("enginesize", this.enginesize);
            tags.func_74777_a("rodsize", this.rodsize);
            tags.func_74757_a("haspower", this.haspower);
            tags.func_74768_a("currentRFperTick", this.currentRFperTick);
            tags.func_74757_a("hasDrill", this.hasDrill);
            tags.func_74774_a("drillType", (byte)this.drillType);
        }
    }

    public int getDrillRadius() {
        if (this.isComplete()) {
            return this.radius;
        }
        return 0;
    }

    public int[] func_94128_d(int side) {
        return new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return slot > 0 && slot <= 9;
    }

    public String func_145825_b() {
        return "techguns.container.oredrill";
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        return false;
    }

    @Override
    public void needUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
    }
}

