/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import cofh.api.energy.IEnergyContainerItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import techguns.TGItems;
import techguns.Techguns;
import techguns.inventory.ChargingStationRecipe;
import techguns.tileentities.BasicMachineTileEntity;

public class ChargingStationTileEnt
extends BasicMachineTileEntity {
    protected int CHARGERATE = 100;
    private int lastsound = 0;
    public boolean charging = false;

    public ChargingStationTileEnt() {
        super(3, 100000);
    }

    @Override
    public void readEntityDataFromNBT(NBTTagCompound tags) {
        super.readEntityDataFromNBT(tags);
        this.charging = tags.func_74767_n("charging");
    }

    @Override
    public void writeEntityDataToNBT(NBTTagCompound tags) {
        super.writeEntityDataToNBT(tags);
        tags.func_74757_a("charging", this.charging);
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return slot == 0;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return slot == 1;
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.name : "techguns.container.chargingStation";
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        return slot == this.getValidSlotForItemInMachine(item);
    }

    public int getValidSlotForItemInMachine(ItemStack item) {
        if (item != null && item.func_77973_b() == TGItems.machineStackUpgrade.func_77973_b() && item.func_77960_j() == TGItems.machineStackUpgrade.func_77960_j()) {
            return 2;
        }
        if (item != null && item.func_77973_b() instanceof IEnergyContainerItem) {
            return 0;
        }
        if (ChargingStationRecipe.getRecipeFor(item) != null) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isWorking() {
        if (this.currentOperation != null) {
            return true;
        }
        return this.content[0] != null && this.content[0].func_77973_b() instanceof IEnergyContainerItem;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.isRedstoneEnabled()) {
            if (this.currentOperation != null) {
                if (this.consumePower(20 * this.stackmultiplier)) {
                    ++this.progress;
                    this.playAmbientSound();
                    if (!this.field_145850_b.field_72995_K && this.progress >= this.totalTime) {
                        if (this.content[1] == null) {
                            this.content[1] = new ItemStack(this.currentOperation.func_77973_b(), this.currentOperation.field_77994_a * this.stackmultiplier, this.currentOperation.func_77960_j());
                        } else {
                            this.content[1].field_77994_a += this.currentOperation.field_77994_a * this.stackmultiplier;
                        }
                        this.progress = 0;
                        this.totalTime = 0;
                        this.currentOperation = null;
                        this.stackmultiplier = 1;
                        this.checkAndStartOperation();
                        this.needUpdate();
                    }
                }
            } else if (this.content[0] != null && this.content[0].func_77973_b() instanceof IEnergyContainerItem) {
                IEnergyContainerItem itm = (IEnergyContainerItem)this.content[0].func_77973_b();
                if (itm.receiveEnergy(this.content[0], this.CHARGERATE, true) > 0) {
                    int maxcharge = Math.min(this.energy.getEnergyStored(), this.CHARGERATE);
                    int pwr = itm.receiveEnergy(this.content[0], maxcharge, false);
                    this.energy.extractEnergy(pwr, false);
                    if (!this.field_145850_b.field_72995_K) {
                        if (!this.charging) {
                            this.charging = true;
                            this.needUpdate();
                        }
                    } else {
                        this.playAmbientSound();
                    }
                } else if (!this.field_145850_b.field_72995_K) {
                    if (this.content[1] == null) {
                        this.content[1] = this.content[0];
                        this.content[0] = null;
                    }
                    this.charging = false;
                    this.needUpdate();
                }
            } else if (!this.field_145850_b.field_72995_K) {
                if (this.charging) {
                    this.charging = false;
                    this.needUpdate();
                }
                if (this.checkAndStartOperation()) {
                    this.needUpdate();
                }
            }
        }
    }

    private boolean checkAndStartOperation() {
        ChargingStationRecipe rec;
        if (this.content[0] != null && (rec = ChargingStationRecipe.getRecipeFor(this.content[0])) != null) {
            int stackMultiplier = this.getStackMulti();
            stackMultiplier = Math.min(stackMultiplier, this.content[0].field_77994_a / rec.input.stackSize);
            if ((stackMultiplier = this.getMaxOutputAmount(rec.output, stackMultiplier)) > 0) {
                this.content[0].field_77994_a -= rec.input.stackSize * stackMultiplier;
                if (this.content[0].field_77994_a <= 0) {
                    this.content[0] = null;
                }
                this.currentOperation = new ItemStack(rec.output.func_77973_b(), rec.output.field_77994_a, rec.output.func_77960_j());
                this.stackmultiplier = stackMultiplier;
                this.progress = 0;
                this.totalTime = rec.chargeAmount / (this.CHARGERATE * 10);
                return true;
            }
        }
        return false;
    }

    private int getMaxOutputAmount(ItemStack item, int maxMulti) {
        if (this.content[1] == null) {
            return Math.min(item.func_77976_d(), item.field_77994_a * maxMulti);
        }
        if (this.content[1].func_77973_b() == item.func_77973_b() && this.content[1].func_77960_j() == item.func_77960_j()) {
            int multi;
            for (multi = maxMulti; multi > 0 && this.content[1].field_77994_a + item.field_77994_a * multi > this.content[1].func_77976_d(); --multi) {
            }
            return multi;
        }
        return 0;
    }

    private int getStackMulti() {
        if (this.content[2] != null && this.content[2].func_77973_b() == TGItems.sharedItem && this.content[2].func_77960_j() == TGItems.machineStackUpgrade.func_77960_j()) {
            return Math.min(this.content[2].field_77994_a + 1, 8);
        }
        return 1;
    }

    private void playAmbientSound() {
        if (this.field_145850_b.field_72995_K) {
            EntityPlayer ply = Techguns.proxy.getPlayerClient();
            Double distSq = this.func_145835_a(ply.field_70165_t, ply.field_70163_u, ply.field_70161_v);
            if (distSq < 100.0) {
                if (this.rotation != 2) {
                    Techguns.proxy.createFX("ChargeFlare", this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.3, 0.0, 0.0, 0.0);
                }
                if (this.rotation != 0) {
                    Techguns.proxy.createFX("ChargeFlare", this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.7, 0.0, 0.0, 0.0);
                }
                if (this.rotation != 1) {
                    Techguns.proxy.createFX("ChargeFlare", this.field_145850_b, (double)this.field_145851_c + 0.3, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 0.0, 0.0, 0.0);
                }
                if (this.rotation != 3) {
                    Techguns.proxy.createFX("ChargeFlare", this.field_145850_b, (double)this.field_145851_c + 0.7, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 0.0, 0.0, 0.0);
                }
            }
            if (this.lastsound > 0) {
                --this.lastsound;
            }
            if (this.lastsound <= 0) {
                this.lastsound = 20;
                this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "techguns:machines.chargingstationwork", 1.0f, 1.0f, true);
            }
        }
    }
}

