/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public abstract class BasicInventoryTileEnt
extends TileEntity
implements ISidedInventory {
    protected String name = null;
    protected ItemStack[] content;
    protected double useRangeSquared = 64.0;
    protected byte security = 0;
    public byte rotation = 0;
    private static Random random = new Random();

    public BasicInventoryTileEnt(int slots) {
        this.content = new ItemStack[slots];
    }

    public void buttonClicked(int id, EntityPlayer ply) {
    }

    public void emptyContent() {
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = null;
        }
    }

    public void onBlockBreak() {
        for (int i1 = 0; i1 < this.func_70302_i_(); ++i1) {
            ItemStack itemstack = this.func_70301_a(i1);
            if (itemstack == null) continue;
            float f = random.nextFloat() * 0.8f + 0.1f;
            float f1 = random.nextFloat() * 0.8f + 0.1f;
            float f2 = random.nextFloat() * 0.8f + 0.1f;
            while (itemstack.field_77994_a > 0) {
                int j1 = random.nextInt(21) + 10;
                if (j1 > itemstack.field_77994_a) {
                    j1 = itemstack.field_77994_a;
                }
                itemstack.field_77994_a -= j1;
                EntityItem entityitem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + f), (double)((float)this.field_145848_d + f1), (double)((float)this.field_145849_e + f2), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)random.nextGaussian() * f3;
                entityitem.field_70181_x = (float)random.nextGaussian() * f3 + 0.2f;
                entityitem.field_70179_y = (float)random.nextGaussian() * f3;
                if (itemstack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                }
                this.field_145850_b.func_72838_d((Entity)entityitem);
            }
        }
        this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, null);
    }

    public int func_70302_i_() {
        return this.content.length;
    }

    public int func_70297_j_() {
        return 64;
    }

    public ItemStack func_70301_a(int slot) {
        return this.content[slot];
    }

    public ItemStack func_70298_a(int slot, int number) {
        if (this.content[slot] != null) {
            if (this.content[slot].field_77994_a <= number) {
                ItemStack itemstack = this.content[slot];
                this.content[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.content[slot].func_77979_a(number);
            if (this.content[slot].field_77994_a == 0) {
                this.content[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.content[slot] != null) {
            ItemStack itemstack = this.content[slot];
            this.content[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack item) {
        this.content[slot] = item;
        if (item != null && item.field_77994_a > this.func_70297_j_()) {
            item.field_77994_a = this.func_70297_j_();
        }
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.readEntityDataFromNBT(tags);
    }

    public void func_145841_b(NBTTagCompound tags) {
        super.func_145841_b(tags);
        this.writeEntityDataToNBT(tags);
    }

    public void readEntityDataFromNBT(NBTTagCompound tags) {
        if (tags.func_150297_b("CustomName", 8)) {
            this.name = tags.func_74779_i("CustomName");
        }
        NBTTagList nbttaglist = tags.func_150295_c("Items", 10);
        this.content = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.content.length) continue;
            this.content[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.rotation = tags.func_74771_c("rotation");
    }

    public void writeEntityDataToNBT(NBTTagCompound tags) {
        if (this.func_145818_k_()) {
            tags.func_74778_a("CustomName", this.name);
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.content[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        tags.func_74782_a("Items", (NBTBase)nbttaglist);
        tags.func_74774_a("rotation", this.rotation);
    }

    public Packet func_145844_m() {
        NBTTagCompound tags = new NBTTagCompound();
        this.func_145841_b(tags);
        S35PacketUpdateTileEntity pkt = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tags);
        return pkt;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void rotate() {
        this.rotation = (byte)(this.rotation + 1);
        if (this.rotation >= 4) {
            this.rotation = 0;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.needUpdate();
        }
    }

    public boolean func_145818_k_() {
        return this.name != null && this.name.length() > 0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void needUpdate() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= this.useRangeSquared;
    }

    protected boolean canOutput(ItemStack output, int slot) {
        if (output == null) {
            return true;
        }
        if (this.content[slot] == null) {
            return output.field_77994_a <= 64;
        }
        return this.content[slot].func_77969_a(output) && this.content[slot].field_77994_a + output.field_77994_a <= this.content[slot].func_77976_d();
    }

    public ItemStack[] getContent() {
        return this.content;
    }
}

