/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import techguns.TGItems;
import techguns.inventory.AmmoPressBuildPlans;
import techguns.tileentities.BasicMachineTileEntity;

public class AmmoPressTileEnt
extends BasicMachineTileEntity {
    public byte buildPlan = 0;
    private final byte maxPlan = (byte)3;

    public AmmoPressTileEnt() {
        super(5, 20000);
    }

    @Override
    public void readEntityDataFromNBT(NBTTagCompound tags) {
        super.readEntityDataFromNBT(tags);
        this.buildPlan = tags.func_74771_c("BuildPlan");
    }

    @Override
    public void writeEntityDataToNBT(NBTTagCompound tags) {
        super.writeEntityDataToNBT(tags);
        tags.func_74774_a("BuildPlan", this.buildPlan);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.isRedstoneEnabled()) {
            if (this.currentOperation != null) {
                if (this.consumePower(5 * this.stackmultiplier)) {
                    ++this.progress;
                    this.playAmbientSound();
                    if (this.progress >= this.totalTime) {
                        if (!this.field_145850_b.field_72995_K) {
                            if (this.content[3] == null) {
                                this.content[3] = new ItemStack(this.currentOperation.func_77973_b(), this.currentOperation.field_77994_a * this.stackmultiplier, this.currentOperation.func_77960_j());
                            } else {
                                this.content[3].field_77994_a += this.currentOperation.field_77994_a * this.stackmultiplier;
                            }
                        }
                        this.progress = 0;
                        this.totalTime = 0;
                        this.currentOperation = null;
                        this.stackmultiplier = 1;
                        this.checkAndStartOperation();
                        if (!this.field_145850_b.field_72995_K) {
                            this.needUpdate();
                        }
                    }
                }
            } else if (this.content[0] != null && this.content[1] != null && this.content[2] != null) {
                this.checkAndStartOperation();
            }
        }
    }

    public void checkAndStartOperation() {
        ItemStack output = AmmoPressBuildPlans.getOutputFor(this.content[0], this.content[1], this.content[2], this.buildPlan);
        if (output != null && this.canOutput(output, 3)) {
            int maxStack = 1;
            if (this.content[4] != null && this.content[4].func_77973_b() == TGItems.machineStackUpgrade.func_77973_b() && this.content[4].func_77960_j() == TGItems.machineStackUpgrade.func_77960_j()) {
                maxStack = this.content[4].field_77994_a + 1;
            }
            int originalStacksize = output.field_77994_a;
            ItemStack outputStack = TGItems.newStack(output, output.field_77994_a);
            for (int i = maxStack; i > 1; --i) {
                outputStack.field_77994_a = output.field_77994_a * i;
                if (!this.canOutput(outputStack, 3) || this.content[0].field_77994_a < i || this.content[1].field_77994_a < i * 2 || this.content[2].field_77994_a < i) continue;
                output = outputStack;
                this.stackmultiplier = i;
                break;
            }
            this.content[0].field_77994_a -= 1 * this.stackmultiplier;
            if (this.content[0].field_77994_a <= 0) {
                this.content[0] = null;
            }
            this.content[1].field_77994_a -= 2 * this.stackmultiplier;
            if (this.content[1].field_77994_a <= 0) {
                this.content[1] = null;
            }
            this.content[2].field_77994_a -= 1 * this.stackmultiplier;
            if (this.content[2].field_77994_a <= 0) {
                this.content[2] = null;
            }
            this.currentOperation = new ItemStack(output.func_77973_b(), originalStacksize, output.func_77960_j());
            this.progress = 0;
            this.totalTime = 100;
            if (!this.field_145850_b.field_72995_K) {
                this.needUpdate();
            }
        }
    }

    public static int getValidSlotForItemInMachine(ItemStack item) {
        if (AmmoPressBuildPlans.isValidFor(item, 0)) {
            return 0;
        }
        if (AmmoPressBuildPlans.isValidFor(item, 1)) {
            return 1;
        }
        if (AmmoPressBuildPlans.isValidFor(item, 2)) {
            return 2;
        }
        if (item != null && item.func_77973_b() == TGItems.machineStackUpgrade.func_77973_b() && item.func_77960_j() == TGItems.machineStackUpgrade.func_77960_j()) {
            return 4;
        }
        return -1;
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        return AmmoPressBuildPlans.isValidFor(item, slot);
    }

    @Override
    public void buttonClicked(int id, EntityPlayer ply) {
        if (id <= 2) {
            super.buttonClicked(id, ply);
        } else if (this.func_70300_a(ply)) {
            switch (id) {
                case 3: {
                    this.buildPlan = (byte)(this.buildPlan + 1);
                    break;
                }
                case 4: {
                    this.buildPlan = (byte)(this.buildPlan - 1);
                }
            }
            if (this.buildPlan > this.maxPlan) {
                this.buildPlan = 0;
            } else if (this.buildPlan < 0) {
                this.buildPlan = (byte)this.maxPlan;
            }
        }
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3};
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return this.func_94041_b(slot, item);
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return slot == 3;
    }

    private void playAmbientSound() {
        int soundTick1 = Math.round((float)this.totalTime * 0.05f);
        int soundTick2 = Math.round((float)this.totalTime * 0.3f);
        int halfTime = Math.round((float)this.totalTime * 0.5f);
        if (this.progress == soundTick1 || this.progress == soundTick1 + halfTime) {
            this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "techguns:machines.ammopressWork1", 1.0f, 1.0f, true);
        } else if (this.progress == soundTick2 || this.progress == soundTick2 + halfTime) {
            this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "techguns:machines.ammopressWork2", 1.0f, 1.0f, true);
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.name : "techguns.container.ammopress";
    }
}

