/*
 * Decompiled with CFR 0.152.
 */
package techguns.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import techguns.TGPackets;
import techguns.Techguns;
import techguns.client.audio.TGSoundCategory;

public class PacketPlaySound
implements IMessage {
    String soundname;
    int entityId;
    float volume;
    float pitch;
    boolean repeat;
    boolean moving;
    boolean gunPosition = false;
    boolean playOnOwnPlayer = false;
    int soundx = 0;
    short soundy = 0;
    int soundz = 0;
    TGSoundCategory category;

    public PacketPlaySound() {
    }

    public PacketPlaySound(String soundname, Entity entity, float volume, float pitch, boolean repeat, boolean moving, boolean gunPosition, boolean playOnOwnPlayer, TGSoundCategory category) {
        this(soundname, entity, volume, pitch, repeat, moving, gunPosition, category);
        this.playOnOwnPlayer = playOnOwnPlayer;
    }

    public PacketPlaySound(String soundname, Entity entity, float volume, float pitch, boolean repeat, boolean moving, boolean gunPosition, TGSoundCategory category) {
        this.entityId = entity == null ? -1 : entity.func_145782_y();
        this.soundname = soundname;
        this.volume = volume;
        this.pitch = pitch;
        this.repeat = repeat;
        this.moving = moving;
        this.gunPosition = gunPosition;
        this.playOnOwnPlayer = false;
        this.category = category;
    }

    public PacketPlaySound(String soundname, Entity entity, float volume, float pitch, boolean repeat, boolean moving, TGSoundCategory category) {
        this.entityId = entity == null ? -1 : entity.func_145782_y();
        this.soundname = soundname;
        this.volume = volume;
        this.pitch = pitch;
        this.repeat = repeat;
        this.moving = moving;
        this.category = category;
    }

    public PacketPlaySound(String soundname, int posx, int posy, int posz, float volume, float pitch, boolean repeat, TGSoundCategory category) {
        this(soundname, null, volume, pitch, repeat, false, false, category);
        this.soundx = posx;
        this.soundy = (short)posy;
        this.soundz = posz;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
        this.repeat = buf.readBoolean();
        this.moving = buf.readBoolean();
        this.gunPosition = buf.readBoolean();
        this.playOnOwnPlayer = buf.readBoolean();
        this.soundx = buf.readInt();
        this.soundy = buf.readShort();
        this.soundz = buf.readInt();
        this.category = TGSoundCategory.values()[buf.readByte()];
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        this.soundname = new String(bytes);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
        buf.writeBoolean(this.repeat);
        buf.writeBoolean(this.moving);
        buf.writeBoolean(this.gunPosition);
        buf.writeBoolean(this.playOnOwnPlayer);
        buf.writeInt(this.soundx);
        buf.writeShort((int)this.soundy);
        buf.writeInt(this.soundz);
        buf.writeByte(this.category.ordinal());
        buf.writeBytes(this.soundname.getBytes());
    }

    public static class Handler
    implements IMessageHandler<PacketPlaySound, IMessage> {
        public IMessage onMessage(PacketPlaySound msg, MessageContext ctx) {
            EntityPlayer ply = TGPackets.getPlayerFromContext(ctx);
            if (msg.entityId != -1) {
                Techguns.proxy.handleSoundEvent(ply, msg.entityId, msg.soundname, msg.volume, msg.pitch, msg.repeat, msg.moving, msg.gunPosition, msg.playOnOwnPlayer, msg.category);
            } else {
                Techguns.proxy.playSoundOnPosition(msg.soundname, msg.soundx, msg.soundy, msg.soundz, msg.volume, msg.pitch, msg.repeat, msg.category);
            }
            return null;
        }
    }
}

