/*
 * Decompiled with CFR 0.152.
 */
package techguns.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import techguns.TGPackets;
import techguns.client.ClientProxy;

public class GunFiredMessage
implements IMessage {
    protected int entityID;
    protected int time;
    protected byte attackType;
    protected boolean checkRecoil;

    public GunFiredMessage() {
    }

    public GunFiredMessage(EntityLivingBase shooter, int firetime, int attackType, boolean checkRecoil) {
        this.entityID = shooter.func_145782_y();
        this.time = firetime;
        this.attackType = (byte)attackType;
        this.checkRecoil = checkRecoil;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.time = buf.readInt();
        this.attackType = buf.readByte();
        this.checkRecoil = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeInt(this.time);
        buf.writeByte((int)this.attackType);
        buf.writeBoolean(this.checkRecoil);
    }

    public static class Handler
    implements IMessageHandler<GunFiredMessage, IMessage> {
        public IMessage onMessage(GunFiredMessage message, MessageContext ctx) {
            EntityPlayer ply = TGPackets.getPlayerFromContext(ctx);
            EntityLivingBase shooter = (EntityLivingBase)ply.field_70170_p.func_73045_a(message.entityID);
            if (shooter != null) {
                ClientProxy cp = ClientProxy.get();
                if (!message.checkRecoil || !cp.isStillRecoiling(shooter, message.attackType)) {
                    cp.setplayerRecoiltime(shooter, System.currentTimeMillis() + (long)message.time, message.time, message.attackType);
                    ClientProxy.spawnMuzzleFXForEntity(shooter);
                }
            }
            return null;
        }
    }
}

