/*
 * Decompiled with CFR 0.152.
 */
package techguns.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.common.Optional;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import techguns.gui.GuiAmmoPress;
import techguns.gui.GuiReactionChamber;
import techguns.inventory.ReactionBeamFocus;
import techguns.inventory.ReactionChamberRecipe;
import techguns.nei.TechgunsChemLabNEIRecipeHandler;
import techguns.util.TextUtil;

public class TechgunsReactionChamberNEIRecipeHandler
extends TemplateRecipeHandler {
    private static final String ID = "Techguns:ReactionChamber";
    public static final int ICON_OFFSET_X = -5;
    public static final int ICON_OFFSET_Y = -11;
    private ResourceLocation texture_gui_elemets = GuiAmmoPress.texture;

    public static String getIDString() {
        return ID;
    }

    @Optional.Method(modid="NotEnoughItems")
    public String getRecipeName() {
        return TextUtil.trans("techguns.container.reactionChamber");
    }

    @Optional.Method(modid="NotEnoughItems")
    public String getGuiTexture() {
        return GuiReactionChamber.texture.toString();
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiReactionChamber.class;
    }

    public boolean isInRect(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    public void loadCraftingRecipes(ItemStack result) {
        ArrayList<ReactionChamberRecipe> recipes = ReactionChamberRecipe.getRecipes();
        for (int i = 0; i < recipes.size(); ++i) {
            if (!recipes.get(i).hasResult(result)) continue;
            this.arecipes.add(new CachedReactionChamberRecipe(recipes.get(i)));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        ArrayList<ReactionChamberRecipe> recipes = ReactionChamberRecipe.getRecipes();
        for (int i = 0; i < recipes.size(); ++i) {
            if (!recipes.get(i).usesItem(ingredient)) continue;
            this.arecipes.add(new CachedReactionChamberRecipe(recipes.get(i)));
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(ID)) {
            this.loadAllRecipes();
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadAllRecipes() {
        ArrayList<ReactionChamberRecipe> recipes = ReactionChamberRecipe.getRecipes();
        for (int i = 0; i < recipes.size(); ++i) {
            this.arecipes.add(new CachedReactionChamberRecipe(recipes.get(i)));
        }
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(61, 49, 102, 14), TechgunsReactionChamberNEIRecipeHandler.getIDString(), new Object[0]));
    }

    public void drawExtras(int recipe) {
        CachedReactionChamberRecipe crec = (CachedReactionChamberRecipe)((Object)this.arecipes.get(recipe));
        ReactionChamberRecipe rec = crec.recipe;
        int color = -1;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiReactionChamber.texture);
        this.drawProgressBar(62, 50, 0, 167, 105, 6, rec.requiredCompletion * 20, 0);
        this.drawProgressBar(62, 57, 0, 174, 105, 6, rec.ticks * 20, 0);
        int px = (10 - rec.preferredIntensity) * 4;
        GuiDraw.gui.func_73729_b(109, 5 + px, 190, px, 6, 40 - px);
        if (rec.liquidIn != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            IIcon tex = rec.liquidIn.getIcon();
            px = rec.liquidLevel * 5;
            TechgunsChemLabNEIRecipeHandler.drawFluidWithTesselator(tex, 14, 6, 10, 50, px);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiReactionChamber.texture);
        GuiDraw.gui.func_73729_b(13, 5, 176, 31, 12, 52);
        GuiDraw.gui.func_73729_b(13, 56 - rec.liquidLevel * 5, 178, 32, 8, 1);
        int power = 100;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture_gui_elemets);
        this.drawProgressBar(3, 6, 251, 1, 4, 48, 100, 7);
        GuiDraw.gui.func_73732_a(GuiDraw.fontRenderer, power + " RF", 52, 29, color);
        GuiDraw.gui.func_73731_b(GuiDraw.fontRenderer, rec.liquidLevel * 10 + "%", 29, 47, color);
        GuiDraw.gui.func_73731_b(GuiDraw.fontRenderer, rec.preferredIntensity + "", 116, 5, color);
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        int mx = GuiDraw.getMousePosition().x - (gui.field_146294_l - 176) / 2 - gui.getRecipePosition((int)recipe).x;
        int my = GuiDraw.getMousePosition().y - (gui.field_146295_m - 166) / 2 - gui.getRecipePosition((int)recipe).y;
        CachedReactionChamberRecipe rec = (CachedReactionChamberRecipe)((Object)this.arecipes.get(recipe));
        ReactionChamberRecipe r = rec.recipe;
        if (this.isInRect(mx, my, -5 + 18, -11 + 17, 12, 52)) {
            if (r.liquidIn != null) {
                currenttip.add(TextUtil.trans(r.liquidIn.getUnlocalizedName()));
                currenttip.add(TextUtil.trans("techguns.reactionTooltip.consume") + " " + r.liquidConsumtion + "mB");
            } else {
                currenttip.add(TextUtil.trans("techguns.chemlab.nofluidin"));
            }
        }
        return super.handleTooltip(gui, currenttip, recipe);
    }

    public class CachedReactionChamberRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ReactionChamberRecipe recipe;

        public CachedReactionChamberRecipe(ReactionChamberRecipe recipe) {
            super((TemplateRecipeHandler)TechgunsReactionChamberNEIRecipeHandler.this);
            this.recipe = recipe;
        }

        public ArrayList<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> recipestacks = new ArrayList<PositionedStack>();
            recipestacks.add(new PositionedStack(this.recipe.input.getItemStacks(), 30, 6));
            recipestacks.add(new PositionedStack((Object)ReactionBeamFocus.getItemForType(this.recipe.beamFocus), 88, 6));
            ArrayList<ItemStack> outputs = this.recipe.outputs;
            if (outputs.size() > 1) {
                recipestacks.add(new PositionedStack((Object)outputs.get(1), 147, 6));
                if (outputs.size() > 2) {
                    recipestacks.add(new PositionedStack((Object)outputs.get(2), 129, 24));
                    if (outputs.size() > 3) {
                        recipestacks.add(new PositionedStack((Object)outputs.get(3), 147, 24));
                    }
                }
            }
            return (ArrayList)this.getCycledIngredients(TechgunsReactionChamberNEIRecipeHandler.this.cycleticks / 24, recipestacks);
        }

        public PositionedStack getResult() {
            ArrayList<ItemStack> outputs = this.recipe.outputs;
            ItemStack output = null;
            PositionedStack stack = null;
            if (outputs.size() > 0) {
                output = outputs.get(0);
                stack = new PositionedStack((Object)output, 129, 6);
            }
            return stack;
        }
    }
}

