/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.guns;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import techguns.client.ClientProxy;
import techguns.damagesystem.DamageType;
import techguns.entities.projectiles.NukeRocketProjectile;
import techguns.extendedproperties.TechgunsExtendedPlayerProperties;
import techguns.items.guns.GenericGun;

public class NukeLauncher
extends GenericGun {
    private float radius = 10.0f;
    private float gravity = 0.01f;

    public NukeLauncher(String name, ItemStack ammo, boolean semiAuto, int minFiretime, int clipsize, int reloadtime, float damage, String firesound, String reloadsound, int TTL, float accuracy) {
        super(name, ammo, semiAuto, minFiretime, clipsize, reloadtime, damage, firesound, reloadsound, TTL, accuracy);
    }

    @Override
    protected void spawnProjectile(World world, EntityLivingBase player, ItemStack itemStack, float spread, float offset, float damagebonus) {
        TechgunsExtendedPlayerProperties props;
        boolean blockdamage = false;
        if (player instanceof EntityPlayer && (props = TechgunsExtendedPlayerProperties.get((EntityPlayer)player)) != null) {
            blockdamage = !props.enableSafemode;
        }
        world.func_72838_d((Entity)new NukeRocketProjectile(world, player, this.damage * damagebonus, this.radius, 1.0f, this.ticksToLive, spread, this.gravity, blockdamage, this.penetration));
    }

    @Override
    protected void client_weaponFired() {
        ClientProxy.get().showWarhead = false;
    }

    @Override
    protected void client_startReload() {
        ClientProxy.get().showWarhead = true;
    }

    @Override
    public DamageType getDamageType() {
        return DamageType.EXPLOSION;
    }
}

