/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.armors;

import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import techguns.TGArmorBonus;
import techguns.TGItems;
import techguns.TGPackets;
import techguns.client.audio.TGSoundCategory;
import techguns.extendedproperties.TechgunsExtendedPlayerProperties;
import techguns.items.TGSlotType;
import techguns.items.armors.ItemTGSpecialSlotAmmo;
import techguns.packets.PacketPlaySound;
import techguns.packets.PacketSpawnParticle;
import techguns.packets.PacketSpawnParticleOnEntity;
import techguns.util.TextUtil;

public class ItemJumppack
extends ItemTGSpecialSlotAmmo {
    private static int durPerUse = 1;
    private static final float JUMPBOOST = 0.8f;
    private static final float FREEHEIGHT = 8.0f;
    private static final float FALLDMG = 0.2f;

    public ItemJumppack(String unlocalizedName, String textureName, int camoCount, int dur) {
        super(unlocalizedName, textureName, camoCount, dur, TGItems.compressedAirTank, TGItems.compressedAirTankEmpty);
    }

    @Override
    public TGSlotType getSlot(ItemStack item) {
        return TGSlotType.BACKSLOT;
    }

    @Override
    public void onPlayerTick(ItemStack item, TickEvent.PlayerTickEvent player, TechgunsExtendedPlayerProperties extendedPlayer) {
        if (item.func_77960_j() + durPerUse > item.func_77958_k()) {
            this.tryReloadAndRepair(item, player.player);
        }
    }

    @Override
    public float getBonus(TGArmorBonus type, ItemStack stack, boolean consume, EntityPlayer player) {
        if (type == TGArmorBonus.JUMP) {
            if (consume) {
                TechgunsExtendedPlayerProperties props = TechgunsExtendedPlayerProperties.get(player);
                if (props.enableJetpack) {
                    if (stack.func_77960_j() + durPerUse <= stack.func_77958_k()) {
                        stack.func_77964_b(stack.func_77960_j() + durPerUse);
                        if (!player.field_70170_p.field_72995_K) {
                            this.doJumpEffect(player);
                        }
                        return 0.8f;
                    }
                }
            } else if (stack.func_77960_j() + durPerUse <= stack.func_77958_k()) {
                return 0.8f;
            }
        } else if (type == TGArmorBonus.FREEHEIGHT) {
            if (stack.func_77960_j() < stack.func_77958_k()) {
                return 8.0f;
            }
        } else if (type == TGArmorBonus.FALLDMG) {
            if (consume) {
                TechgunsExtendedPlayerProperties props = TechgunsExtendedPlayerProperties.get(player);
                if (props.enableJetpack) {
                    if (stack.func_77960_j() + durPerUse <= stack.func_77958_k()) {
                        stack.func_77964_b(stack.func_77960_j() + durPerUse);
                        if (!player.field_70170_p.field_72995_K) {
                            this.doFallEffect(player);
                        }
                        return 0.2f;
                    }
                }
            } else if (stack.func_77960_j() < stack.func_77958_k()) {
                return 0.2f;
            }
        }
        return 0.0f;
    }

    public void doJumpEffect(EntityPlayer ply) {
        if (!ply.field_70170_p.field_72995_K) {
            NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(ply.field_70170_p.field_73011_w.field_76574_g, ply.field_70165_t, ply.field_70163_u, ply.field_70161_v, 50.0);
            TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticleOnEntity("JumpPackBoost", (Entity)ply), targetPoint);
            TGPackets.network.sendToAllAround((IMessage)new PacketPlaySound("techguns:effects.steamarmorJump2", (Entity)ply, 1.0f, 1.0f, false, true, false, true, TGSoundCategory.PLAYER_EFFECT), targetPoint);
        }
    }

    public void doFallEffect(EntityPlayer ply) {
        if (!ply.field_70170_p.field_72995_K) {
            TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle("JumpPackFall", ply.field_70165_t, ply.field_70163_u, ply.field_70161_v), new NetworkRegistry.TargetPoint(ply.field_70170_p.field_73011_w.field_76574_g, ply.field_70165_t, ply.field_70163_u, ply.field_70161_v, 50.0));
        }
    }

    @Override
    public void func_77624_a(ItemStack item, EntityPlayer player, List list, boolean b) {
        super.func_77624_a(item, player, list, b);
        list.add(TextUtil.trans("techguns.armorTooltip.jumpheight") + ": +" + 0.8f);
        list.add(TextUtil.trans("techguns.armorTooltip.falldamage") + ": -" + 20.0f + "%");
        list.add(TextUtil.trans("techguns.armorTooltip.fallheight") + ": -" + 8.0f);
    }
}

