/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.armors;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Keyboard;
import techguns.TGArmorBonus;
import techguns.TGArmors;
import techguns.TGItems;
import techguns.Techguns;
import techguns.client.ClientProxy;
import techguns.damagesystem.DamageSystem;
import techguns.damagesystem.DamageType;
import techguns.damagesystem.TGArmorMaterial;
import techguns.damagesystem.TGDamageSource;
import techguns.entities.npc.GenericNPC;
import techguns.extendedproperties.TechgunsExtendedPlayerProperties;
import techguns.items.armors.ITGSpecialSlot;
import techguns.items.armors.PoweredArmor;
import techguns.items.guns.GenericGun;
import techguns.util.MathUtil;
import techguns.util.TextUtil;

public class GenericArmor
extends ItemArmor
implements ISpecialArmor {
    private ItemStack repairItem = null;
    protected ItemStack repairMatMetal = null;
    protected ItemStack repairMatCloth = null;
    protected float repairMatRatioMetal = 0.5f;
    protected int repairMatCount = 0;
    String textureName;
    int modelIndex = -1;
    public static double ARMOR_CAP = 0.96;
    public static float MAX_ARMOR = 24.0f;
    protected float SpeedBonus = 0.0f;
    protected float JumpBonus = 0.0f;
    protected float FallDMG = 0.0f;
    protected float FallFreeHeight = 0.0f;
    protected float MiningSpeedBonus = 0.0f;
    protected float WaterMiningBonus = 0.0f;
    protected int armorValue = 0;
    protected float GunAccuracy = 0.0f;
    protected float extraHearts = 0.0f;
    protected float nightvision = 0.0f;
    protected float knockbackresistance = 0.0f;
    protected float stepassist = 0.0f;
    protected float oxygen_gear = 0.0f;
    protected float water_electrolyzer = 0.0f;
    protected float coolingsystem = 0.0f;
    protected float waterspeedbonus = 0.0f;
    protected boolean hideFaceslot = false;
    protected boolean hideBackslot = false;
    protected TGArmorMaterial field_77878_bZ;
    protected static DecimalFormat formatArmor = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));

    public GenericArmor(String unlocalizedName, TGArmorMaterial material, String textureName, int type) {
        super(material.createVanillaMaterial(), 0, type);
        this.field_77878_bZ = material;
        this.textureName = textureName;
        this.func_77637_a(Techguns.tabTechgun);
        this.func_77655_b(unlocalizedName);
        this.func_111206_d("Techguns:" + unlocalizedName);
        this.armorValue = Math.round(material.getArmorValueSlot(type, DamageType.PHYSICAL));
        this.func_77656_e(this.field_77878_bZ.getDurability(type));
    }

    public static double getArmorCap(DamageType damageType) {
        return ARMOR_CAP;
    }

    public GenericArmor setArmorModel(int index) {
        this.modelIndex = index;
        return this;
    }

    public static boolean isTechgunArmor(ItemStack i) {
        if (i == null) {
            return false;
        }
        return i.func_77973_b() instanceof GenericArmor;
    }

    public GenericArmor setSpeedBoni(float speed, float jump) {
        this.SpeedBonus = speed;
        this.JumpBonus = jump;
        return this;
    }

    public GenericArmor setFallProtection(float multiplier, float freeheight) {
        this.FallDMG = multiplier;
        this.FallFreeHeight = freeheight;
        return this;
    }

    public GenericArmor setMiningBoni(float bonus) {
        this.MiningSpeedBonus = bonus;
        return this;
    }

    public GenericArmor setMiningBoniWater(float bonus) {
        this.WaterMiningBonus = bonus;
        return this;
    }

    public GenericArmor setGunBonus(float acc) {
        this.GunAccuracy = acc;
        return this;
    }

    public GenericArmor setHealthBonus(int bonusHearts) {
        this.extraHearts = bonusHearts;
        return this;
    }

    public GenericArmor setDurability(int dur) {
        this.func_77656_e(dur);
        return this;
    }

    public GenericArmor setKnockbackResistance(float resistpercent) {
        this.knockbackresistance = resistpercent;
        return this;
    }

    public GenericArmor setStepAssist(float stepassist) {
        this.stepassist = stepassist;
        return this;
    }

    public GenericArmor setOxygenGear(float value) {
        this.oxygen_gear = value;
        return this;
    }

    public GenericArmor setCoolingSystem(float value) {
        this.coolingsystem = value;
        return this;
    }

    public GenericArmor setWaterspeedBonus(float value) {
        this.waterspeedbonus = value;
        return this;
    }

    public float getBonus(TGArmorBonus type) {
        switch (type) {
            case SPEED: {
                return this.SpeedBonus;
            }
            case JUMP: {
                return this.JumpBonus;
            }
            case FALLDMG: {
                return this.FallDMG;
            }
            case FREEHEIGHT: {
                return this.FallFreeHeight;
            }
            case BREAKSPEED: {
                return this.MiningSpeedBonus;
            }
            case BREAKSPEED_WATER: {
                return this.WaterMiningBonus;
            }
            case GUN_ACCURACY: {
                return this.GunAccuracy;
            }
            case EXTRA_HEART: {
                return this.extraHearts;
            }
            case NIGHTVISION: {
                return this.nightvision;
            }
            case KNOCKBACK_RESISTANCE: {
                return this.knockbackresistance;
            }
            case STEPASSIST: {
                return this.stepassist;
            }
            case OXYGEN_GEAR: {
                return this.oxygen_gear;
            }
            case WATER_ELECTROLYZER: {
                return this.water_electrolyzer;
            }
            case COOLING_SYSTEM: {
                return this.coolingsystem;
            }
            case SPEED_WATER: {
                return this.waterspeedbonus;
            }
        }
        return 0.0f;
    }

    public GenericArmor addEnchantment() {
        return this;
    }

    public static float getArmorBonusForPlayer(EntityPlayer ply, TGArmorBonus type, boolean consumePower) {
        float bonus = 0.0f;
        TechgunsExtendedPlayerProperties props = TechgunsExtendedPlayerProperties.get(ply);
        if (props == null) {
            return 0.0f;
        }
        for (int i = 0; i < 4; ++i) {
            ItemStack armor = ply.field_71071_by.func_70440_f(i);
            if (!GenericArmor.isTechgunArmor(armor)) continue;
            if (!(armor.func_77973_b() instanceof PoweredArmor)) {
                if (armor.func_77960_j() >= armor.func_77958_k() - 1) continue;
                float bonusVal = ((GenericArmor)armor.func_77973_b()).getBonus(type);
                bonus += bonusVal;
                continue;
            }
            PoweredArmor pwrarmor = (PoweredArmor)armor.func_77973_b();
            boolean power = PoweredArmor.hasPower(armor);
            float bonusVal = 0.0f;
            if (armor.func_77960_j() >= armor.func_77958_k() - 1) continue;
            if (power) {
                bonusVal = pwrarmor.getBonus(type);
                bonus += bonusVal;
                if (!consumePower || !(bonusVal > 0.0f)) continue;
                PoweredArmor.consumePower(armor, pwrarmor.applyPowerConsumptionOnAction(type, ply));
                continue;
            }
            bonusVal = pwrarmor.getBonusUnpowered(type);
            bonus += bonusVal;
        }
        if (props != null) {
            ItemStack back;
            ItemStack face = props.TG_inventory.inventory[0];
            if (face != null) {
                ITGSpecialSlot faceitem = (ITGSpecialSlot)face.func_77973_b();
                if (face.func_77973_b() == TGItems.sharedItem || face.func_77960_j() < face.func_77958_k()) {
                    bonus += faceitem.getBonus(type, face, consumePower, ply);
                }
            }
            if ((back = props.TG_inventory.inventory[1]) != null) {
                ITGSpecialSlot backitem = (ITGSpecialSlot)back.func_77973_b();
                if (back.func_77973_b() == TGItems.sharedItem || back.func_77960_j() < back.func_77958_k()) {
                    bonus += backitem.getBonus(type, back, consumePower, ply);
                }
            }
        }
        return bonus;
    }

    private String getSingleTexture() {
        return "Techguns:textures/armor/" + this.textureName + ".png";
    }

    private String getDoubleTexture() {
        return "Techguns:textures/armor/" + this.textureName + "_" + (this.field_77881_a == 2 ? "2" : "1") + ".png";
    }

    protected boolean hasDoubleTexture() {
        if (this.modelIndex < 0) {
            return true;
        }
        return this.modelIndex == 4 || this.modelIndex == 5 || this.modelIndex == 6;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (this.hasDoubleTexture()) {
            return this.getDoubleTexture();
        }
        return this.getSingleTexture();
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (this.modelIndex >= 0) {
            ItemStack stack;
            ModelBiped model = ClientProxy.armorModels[this.modelIndex];
            model.field_78116_c.field_78806_j = armorSlot == 0;
            boolean bl = model.field_78114_d.field_78806_j = armorSlot == 0;
            if (itemStack != null && itemStack.func_77973_b() == TGArmors.t2_beret) {
                model.field_78114_d.field_78806_j = false;
            }
            model.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
            model.field_78112_f.field_78806_j = armorSlot == 1;
            model.field_78113_g.field_78806_j = armorSlot == 1;
            model.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
            model.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
            model.field_78117_n = entityLiving.func_70093_af();
            model.field_78093_q = entityLiving.func_70115_ae();
            model.field_78091_s = entityLiving.func_70631_g_();
            int n = model.field_78120_m = entityLiving.func_71124_b(0) != null ? 1 : 0;
            if (entityLiving instanceof EntityPlayer) {
                ItemStack stack2 = entityLiving.func_70694_bm();
                if (stack2 != null && stack2.func_77973_b() instanceof GenericGun) {
                    model.field_78118_o = true;
                } else {
                    boolean bl2 = model.field_78118_o = ((EntityPlayer)entityLiving).func_71057_bx() > 2 && ((EntityPlayer)entityLiving).func_71011_bu().func_77975_n() == EnumAction.bow;
                }
                if (stack2 != null && stack2.func_77975_n() == EnumAction.block && ((EntityPlayer)entityLiving).func_71052_bv() > 0) {
                    model.field_78120_m = 3;
                }
            } else if (entityLiving instanceof GenericNPC && ((GenericNPC)entityLiving).getHasAimedBowAnim() && (stack = entityLiving.func_70694_bm()) != null && stack.func_77973_b() instanceof GenericGun) {
                model.field_78118_o = true;
            }
            return model;
        }
        return null;
    }

    private String trans(String text) {
        return TextUtil.trans("techguns." + text);
    }

    public static String formatAV(float armorValue, DamageType damageType) {
        float percent = (float)((double)(armorValue / MAX_ARMOR) * GenericArmor.getArmorCap(damageType));
        return formatArmor.format(armorValue) + " (" + formatArmor.format(percent * 100.0f) + "%)";
    }

    protected void addArmorvaluesInformation(ItemStack item, EntityPlayer player, List list, boolean b) {
        int slot = this.field_77881_a;
        if (this.getPenetrationResistance() > 0.0f) {
            list.add(EnumChatFormatting.DARK_GRAY + this.trans("armorTooltip.penetrationResistance") + " " + formatArmor.format(this.getPenetrationResistance() * 100.0f) + "%");
        }
        list.add(EnumChatFormatting.DARK_GRAY + " AR: " + GenericArmor.formatAV(this.field_77878_bZ.getArmorValueSlot(slot, DamageType.PHYSICAL), DamageType.PHYSICAL));
        list.add(EnumChatFormatting.GRAY + " PR: " + GenericArmor.formatAV(this.field_77878_bZ.getArmorValueSlot(slot, DamageType.PROJECTILE), DamageType.PROJECTILE));
        list.add(EnumChatFormatting.DARK_RED + " EX: " + GenericArmor.formatAV(this.field_77878_bZ.getArmorValueSlot(slot, DamageType.EXPLOSION), DamageType.EXPLOSION));
        list.add(EnumChatFormatting.DARK_AQUA + " E: " + GenericArmor.formatAV(this.field_77878_bZ.getArmorValueSlot(slot, DamageType.ENERGY), DamageType.ENERGY));
        list.add(EnumChatFormatting.RED + " F: " + GenericArmor.formatAV(this.field_77878_bZ.getArmorValueSlot(slot, DamageType.FIRE), DamageType.FIRE));
        list.add(EnumChatFormatting.AQUA + " I: " + GenericArmor.formatAV(this.field_77878_bZ.getArmorValueSlot(slot, DamageType.ICE), DamageType.ICE));
        list.add(EnumChatFormatting.YELLOW + " L: " + GenericArmor.formatAV(this.field_77878_bZ.getArmorValueSlot(slot, DamageType.LIGHTNING), DamageType.LIGHTNING));
        list.add(EnumChatFormatting.DARK_GREEN + " P: " + GenericArmor.formatAV(this.field_77878_bZ.getArmorValueSlot(slot, DamageType.POISON), DamageType.POISON));
        list.add(EnumChatFormatting.GREEN + " RAD: " + GenericArmor.formatAV(this.field_77878_bZ.getArmorValueSlot(slot, DamageType.RADIATION), DamageType.RADIATION));
    }

    public void func_77624_a(ItemStack item, EntityPlayer player, List list, boolean b) {
        super.func_77624_a(item, player, list, b);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(this.trans("armorTooltip.durability") + ": " + (item.func_77958_k() - item.func_77960_j()) + "/" + item.func_77958_k());
            list.add(this.trans("armorTooltip.resistances") + ":");
            this.addArmorvaluesInformation(item, player, list, b);
            if (this.getBonus(TGArmorBonus.EXTRA_HEART) > 0.0f) {
                list.add(this.trans("armorTooltip.healthbonus") + ": +" + (int)this.getBonus(TGArmorBonus.EXTRA_HEART) + " " + this.trans("armorTooltip.hearts"));
            } else if (this.getBonus(TGArmorBonus.SPEED) > 0.0f) {
                list.add(this.trans("armorTooltip.movespeed") + ": +" + this.getBonus(TGArmorBonus.SPEED) * 100.0f + "%");
            } else if (this.getBonus(TGArmorBonus.JUMP) > 0.0f) {
                list.add(this.trans("armorTooltip.jumpheight") + ": +" + this.getBonus(TGArmorBonus.JUMP));
            }
            if (this.getBonus(TGArmorBonus.FALLDMG) > 0.0f) {
                list.add(this.trans("armorTooltip.falldamage") + ": -" + this.getBonus(TGArmorBonus.FALLDMG) * 100.0f + "%");
            }
            if (this.getBonus(TGArmorBonus.FREEHEIGHT) > 0.0f) {
                list.add(this.trans("armorTooltip.fallheight") + ": -" + this.getBonus(TGArmorBonus.FREEHEIGHT));
            }
            if (this.getBonus(TGArmorBonus.BREAKSPEED) > 0.0f) {
                list.add(this.trans("armorTooltip.miningspeed") + ": +" + this.getBonus(TGArmorBonus.BREAKSPEED) * 100.0f + "%");
            }
            if (this.getBonus(TGArmorBonus.BREAKSPEED_WATER) > 0.0f) {
                list.add(this.trans("armorTooltip.underwatermining") + ": +" + this.getBonus(TGArmorBonus.BREAKSPEED_WATER) * 100.0f + "%");
            }
            if (this.getBonus(TGArmorBonus.KNOCKBACK_RESISTANCE) > 0.0f) {
                list.add(this.trans("armorTooltip.knockbackresistance") + ": +" + this.getBonus(TGArmorBonus.KNOCKBACK_RESISTANCE) * 100.0f + "%");
            }
            if (this.getBonus(TGArmorBonus.NIGHTVISION) > 0.0f) {
                list.add(this.trans("armorTooltip.nightvision"));
            }
            if (this.getBonus(TGArmorBonus.STEPASSIST) > 0.0f) {
                list.add(this.trans("armorTooltip.stepassist"));
            }
            if (this.getBonus(TGArmorBonus.OXYGEN_GEAR) > 0.0f) {
                list.add(this.trans("armorTooltip.oxygengear"));
            }
            if (this.getBonus(TGArmorBonus.COOLING_SYSTEM) > 0.0f) {
                list.add(this.trans("armorTooltip.coolingsystem"));
            }
        } else {
            this.addMinimalInformation(item, player, list, b);
            list.add(TextUtil.trans("techguns.gun.tooltip.shift1") + " " + EnumChatFormatting.GREEN + TextUtil.trans("techguns.gun.tooltip.shift2") + " " + EnumChatFormatting.GRAY + TextUtil.trans("techguns.gun.tooltip.shift3"));
        }
    }

    protected void addMinimalInformation(ItemStack item, EntityPlayer player, List list, boolean b) {
        list.add(this.trans("armorTooltip.durability") + ": " + (item.func_77958_k() - item.func_77960_j()) + "/" + item.func_77958_k());
    }

    public float getArmorValue(ItemStack armor, DamageType type) {
        return this.field_77878_bZ.getArmorValueSlot(this.field_77881_a, type);
    }

    public float getPenetrationResistance() {
        return this.field_77878_bZ.getPenetrationResistance();
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        double reduction = 0.0;
        if (armor.func_77960_j() < armor.func_77958_k() - 1) {
            TGDamageSource dmgsrc = TGDamageSource.getFromGenericDamageSource(source);
            float armorAgainstType = this.getArmorValue(armor, dmgsrc.field_76373_n);
            if (armorAgainstType > 0.0f) {
                float pen = dmgsrc.armorPenetration;
                if (pen > 0.0f) {
                    pen -= this.getPenetrationResistance();
                    dmgsrc.armorPenetration = pen = MathUtil.clamp(pen, 0.0f, 1.0f);
                }
                reduction = DamageSystem.getReduction(dmgsrc, damage, armorAgainstType);
            }
        }
        return new ISpecialArmor.ArmorProperties(0, reduction, armor.func_77958_k() + 1 - armor.func_77960_j());
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (armor.func_77960_j() >= armor.func_77958_k() - 1) {
            return 0;
        }
        return this.armorValue;
    }

    public boolean func_82789_a(ItemStack item, ItemStack mat) {
        GenericArmor armor = (GenericArmor)item.func_77973_b();
        if (armor.repairItem != null) {
            return OreDictionary.itemMatches((ItemStack)armor.repairItem, (ItemStack)mat, (boolean)true);
        }
        return false;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (!(entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d || !stack.func_77984_f())) {
            int maxDmg = stack.func_77958_k() - 1 - stack.func_77960_j();
            if (damage > maxDmg) {
                damage = maxDmg;
            }
            if (stack.func_96631_a(damage, entity.func_70681_au())) {
                entity.func_70669_a(stack);
                if (stack.func_77960_j() > stack.func_77958_k()) {
                    stack.func_77964_b(stack.func_77958_k());
                }
            }
        }
    }

    public boolean isHideFaceslot() {
        return this.hideFaceslot;
    }

    public GenericArmor setHideFaceslot(boolean hideFaceslot) {
        this.hideFaceslot = hideFaceslot;
        return this;
    }

    public boolean isHideBackslot() {
        return this.hideBackslot;
    }

    public GenericArmor setHideBackslot(boolean hideBackslot) {
        this.hideBackslot = hideBackslot;
        return this;
    }

    public GenericArmor setRepairMats(ItemStack metal, ItemStack cloth, float metalpercent, int totalmats) {
        if (metal != null) {
            this.repairItem = TGItems.newStack(metal, 1);
        } else if (cloth != null) {
            this.repairItem = TGItems.newStack(cloth, 1);
        }
        if (metal != null) {
            this.repairMatMetal = TGItems.newStack(metal, 1);
        }
        if (cloth != null) {
            this.repairMatCloth = TGItems.newStack(cloth, 1);
        }
        this.repairMatCount = totalmats;
        this.repairMatRatioMetal = metalpercent;
        return this;
    }

    public boolean canRepairOnRepairBench(ItemStack item) {
        GenericArmor armor = (GenericArmor)item.func_77973_b();
        return armor.repairMatCount > 0;
    }

    public ArrayList<ItemStack> getRepairMats(ItemStack item) {
        ArrayList<ItemStack> mats = new ArrayList<ItemStack>();
        if (item.func_77960_j() > 0) {
            GenericArmor armor = (GenericArmor)item.func_77973_b();
            float dmgpercent = (float)item.func_77960_j() * 1.0f / ((float)(item.func_77958_k() - 1) * 1.0f);
            int count = (int)Math.ceil((float)armor.repairMatCount * dmgpercent);
            int metalcount = (int)Math.ceil((float)count * armor.repairMatRatioMetal);
            int clothcount = count - metalcount;
            if (armor.repairMatMetal != null && metalcount > 0) {
                mats.add(TGItems.newStack(armor.repairMatMetal, metalcount));
            }
            if (armor.repairMatCloth != null && clothcount > 0) {
                mats.add(TGItems.newStack(armor.repairMatCloth, clothcount));
            }
        }
        return mats;
    }

    public String func_77667_c(ItemStack s) {
        return "techguns." + super.func_77667_c(s);
    }
}

