/*
 * Decompiled with CFR 0.152.
 */
package techguns.inventory;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import techguns.TGItems;
import techguns.inventory.ItemStackOreDict;

public class FabricatorRecipe {
    public static ArrayList<ItemStackOreDict> items_wireslot = new ArrayList(4);
    public static ArrayList<ItemStackOreDict> items_powderslot = new ArrayList(2);
    public static ArrayList<ItemStackOreDict> items_plateslot = new ArrayList(4);
    public static ItemStackOreDict copperWires = new ItemStackOreDict(TGItems.copperWire, 1);
    public static ItemStackOreDict goldWires = new ItemStackOreDict(TGItems.goldWire, 1);
    public static ItemStackOreDict redstone = new ItemStackOreDict("dustRedstone", 1);
    public static ItemStackOreDict plastic = new ItemStackOreDict(TGItems.plasticSheet, 1);
    public static ItemStackOreDict circuit_basic = new ItemStackOreDict("circuitBasic", 1);
    public static ItemStackOreDict circuit_elite = new ItemStackOreDict("circuitElite", 1);
    public static ItemStackOreDict mechanicalPartsT3 = new ItemStackOreDict(TGItems.mechanicalPartsT3, 1);
    public static ItemStackOreDict carbonPlate = new ItemStackOreDict("plateCarbon", 1);
    public static ItemStackOreDict titaniumPlate = new ItemStackOreDict("plateTitanium", 1);
    public static ItemStackOreDict leadPlate = new ItemStackOreDict("plateLead", 1);
    public static ArrayList<FabricatorRecipe> recipes;
    public ItemStackOreDict inputItem;
    public byte amountInput;
    public ItemStackOreDict wireSlot;
    public byte amountWire;
    public ItemStackOreDict powderSlot;
    public byte amountPowder;
    public ItemStackOreDict plateSlot;
    public byte amountPlates;
    public ItemStack outputItem;
    public byte amountOutput;

    public static void addRecipe(ItemStackOreDict inputItem, int amountInput, ItemStackOreDict wireSlot, int amountWire, ItemStackOreDict powderSlot, int amountPowder, ItemStackOreDict plateSlot, int amountPlates, ItemStack outputItem, int amountOutput) {
        recipes.add(new FabricatorRecipe(inputItem, amountInput, wireSlot, amountWire, powderSlot, amountPowder, plateSlot, amountPlates, outputItem, amountOutput));
    }

    public boolean usesItem(ItemStack itm) {
        return this.inputItem.isEqualWithOreDict(itm) || this.wireSlot.isEqualWithOreDict(itm) || this.powderSlot.isEqualWithOreDict(itm) || this.plateSlot.isEqualWithOreDict(itm);
    }

    private FabricatorRecipe(ItemStackOreDict inputItem, int amountInput, ItemStackOreDict wireSlot, int amountWire, ItemStackOreDict powderSlot, int amountPowder, ItemStackOreDict plateSlot, int amountPlates, ItemStack outputItem, int amountOutput) {
        this.inputItem = inputItem;
        this.amountInput = (byte)amountInput;
        this.wireSlot = wireSlot;
        this.amountWire = (byte)amountWire;
        this.powderSlot = powderSlot;
        this.amountPowder = (byte)amountPowder;
        this.plateSlot = plateSlot;
        this.amountPlates = (byte)amountPlates;
        this.outputItem = outputItem;
        this.amountOutput = (byte)amountOutput;
    }

    private boolean matches(ItemStack input, ItemStack wires, ItemStack powder, ItemStack plate) {
        return this.inputItem.isEqualWithOreDict(input) && input.field_77994_a >= this.amountInput && (this.wireSlot.isNullStack() || wires != null && this.wireSlot.isEqualWithOreDict(wires) && wires.field_77994_a >= this.amountWire) && (this.powderSlot.isNullStack() || powder != null && this.powderSlot.isEqualWithOreDict(powder) && powder.field_77994_a >= this.amountPowder) && (this.plateSlot.isNullStack() || plate != null && this.plateSlot.isEqualWithOreDict(plate) && plate.field_77994_a >= this.amountPlates);
    }

    public static RecipeData getRecipeDataFor(ItemStack input, ItemStack wires, ItemStack powder, ItemStack plate, int maxMultiplier, ItemStack outputSlot) {
        FabricatorRecipe match = null;
        for (int i = 0; i < recipes.size(); ++i) {
            FabricatorRecipe rec = recipes.get(i);
            if (!rec.matches(input, wires, powder, plate)) continue;
            match = rec;
            break;
        }
        if (match != null && FabricatorRecipe.canMerge(outputSlot, match.outputItem, match.amountOutput)) {
            int maxMultiInput = FabricatorRecipe.getMaxMulti(input.field_77994_a, match.amountInput, maxMultiplier);
            int maxMultiWires = FabricatorRecipe.getMaxMulti(wires.field_77994_a, match.amountWire, maxMultiplier);
            int maxMultiPowder = FabricatorRecipe.getMaxMulti(powder.field_77994_a, match.amountPowder, maxMultiplier);
            int maxMultiPlate = FabricatorRecipe.getMaxMulti(powder.field_77994_a, match.amountPowder, maxMultiplier);
            int maxMultiOutput = FabricatorRecipe.getMaxMultiOutput(outputSlot == null ? 0 : outputSlot.field_77994_a, match.amountOutput, maxMultiplier, match.outputItem.func_77976_d());
            int multi = FabricatorRecipe.getMinArgument(maxMultiInput, maxMultiWires, maxMultiPowder, maxMultiPlate, maxMultiOutput);
            RecipeData data = new RecipeData(match.outputItem, match.amountOutput, match.amountInput, match.amountWire, match.amountPowder, match.amountPlates, multi);
            return data;
        }
        return null;
    }

    private static boolean canMerge(ItemStack content, ItemStack newStack, int newAmount) {
        if (content == null) {
            return true;
        }
        if (content.func_77973_b() == newStack.func_77973_b() && content.func_77960_j() == newStack.func_77960_j()) {
            return content.field_77994_a + newAmount <= content.func_77976_d();
        }
        return false;
    }

    private static int getMaxMulti(int stackSize, int consumption, int maxMulti) {
        int mult = maxMulti;
        while (mult * consumption > stackSize) {
            --mult;
        }
        return mult;
    }

    private static int getMaxMultiOutput(int stackSize, int amount, int maxMulti, int maxStackSize) {
        int mult = maxMulti;
        while (mult * amount + stackSize > maxStackSize) {
            --mult;
        }
        return mult;
    }

    private static int getMinArgument(int ... values) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < values.length; ++i) {
            int x = values[i];
            if (x >= min) continue;
            min = x;
        }
        return min;
    }

    public static ArrayList<FabricatorRecipe> getRecipes() {
        return recipes;
    }

    static {
        items_wireslot.add(copperWires);
        items_wireslot.add(goldWires);
        items_wireslot.add(circuit_basic);
        items_wireslot.add(circuit_elite);
        items_powderslot.add(redstone);
        items_powderslot.add(mechanicalPartsT3);
        items_plateslot.add(plastic);
        items_plateslot.add(carbonPlate);
        items_plateslot.add(titaniumPlate);
        items_plateslot.add(leadPlate);
        recipes = new ArrayList();
    }

    public static class RecipeData {
        public ItemStack output;
        public byte outputAmount;
        public byte inputConsumption;
        public byte wireConsumption;
        public byte powderConsumption;
        public byte plateConsumption;
        public byte stackMultiplier;

        public RecipeData(ItemStack output, int outputAmount, int inputConsumption, int wireConsumption, int powderConsumption, int plateConsumption, int stackMultiplier) {
            this.output = output;
            this.outputAmount = (byte)outputAmount;
            this.inputConsumption = (byte)inputConsumption;
            this.wireConsumption = (byte)wireConsumption;
            this.powderConsumption = (byte)powderConsumption;
            this.plateConsumption = (byte)plateConsumption;
            this.stackMultiplier = (byte)stackMultiplier;
        }
    }
}

