/*
 * Decompiled with CFR 0.152.
 */
package techguns.inventory;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import techguns.gui.SlotMachineUpgrade;
import techguns.gui.SlotOutput;
import techguns.gui.SlotRestrictedToList;
import techguns.inventory.FabricatorRecipe;
import techguns.tileentities.FabricatorTileEntMaster;

public class FabricatorContainer
extends Container {
    FabricatorTileEntMaster tile;
    private int lastProgress = 0;
    private int lastTotaltime = 0;
    private int lastPowerStored = 0;

    public FabricatorContainer(InventoryPlayer player, FabricatorTileEntMaster ent) {
        int i;
        this.tile = ent;
        this.func_75146_a(new Slot((IInventory)ent, (int)FabricatorTileEntMaster.SLOT_INPUT, 19, 17));
        this.func_75146_a(new SlotRestrictedToList((IInventory)ent, FabricatorTileEntMaster.SLOT_WIRES, 47, 17, FabricatorRecipe.items_wireslot));
        this.func_75146_a(new SlotRestrictedToList((IInventory)ent, FabricatorTileEntMaster.SLOT_POWDER, 68, 17, FabricatorRecipe.items_powderslot));
        this.func_75146_a(new SlotRestrictedToList((IInventory)ent, FabricatorTileEntMaster.SLOT_PLATE, 89, 17, FabricatorRecipe.items_plateslot));
        this.func_75146_a(new SlotOutput((IInventory)ent, FabricatorTileEntMaster.SLOT_OUTPUT, 116, 50));
        this.func_75146_a(new SlotMachineUpgrade((IInventory)ent, FabricatorTileEntMaster.SLOT_UPGRADE, 150, 50));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)player, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)player, i, 8 + i * 18, 142));
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.tile.func_70300_a(player);
    }

    public void func_75132_a(ICrafting craft) {
        super.func_75132_a(craft);
        craft.func_71112_a((Container)this, 0, this.tile.progress);
        craft.func_71112_a((Container)this, 1, this.tile.totalTime);
        craft.func_71112_a((Container)this, 2, this.tile.getPowerStored() / 100);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            ICrafting icrafting = (ICrafting)this.field_75149_d.get(i);
            if (this.lastProgress != this.tile.progress) {
                icrafting.func_71112_a((Container)this, 0, this.tile.progress);
            }
            if (this.lastTotaltime != this.tile.totalTime) {
                icrafting.func_71112_a((Container)this, 1, this.tile.totalTime);
            }
            if (this.lastPowerStored == this.tile.getPowerStored() && !this.tile.isWorking()) continue;
            icrafting.func_71112_a((Container)this, 2, this.tile.getPowerStored() / 100);
        }
        this.lastProgress = this.tile.progress;
        this.lastTotaltime = this.tile.totalTime;
        this.lastPowerStored = this.tile.getPowerStored();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        if (id == 0) {
            this.tile.progress = value;
        } else if (id == 1) {
            this.tile.totalTime = value;
        } else if (id == 2) {
            this.tile.setPowerStored(value * 100);
        }
    }

    public ItemStack func_82846_b(EntityPlayer ply, int id) {
        ItemStack stack1;
        int MAXSLOTS = FabricatorTileEntMaster.SLOT_UPGRADE + 36 + 1;
        ItemStack stack = null;
        Slot slot = (Slot)this.field_75151_b.get(id);
        if (slot.func_75216_d() && (stack = (stack1 = slot.func_75211_c()).func_77946_l()) != null) {
            if (id >= 0 && id <= FabricatorTileEntMaster.SLOT_UPGRADE) {
                if (!this.func_75135_a(stack1, FabricatorTileEntMaster.SLOT_UPGRADE + 1, MAXSLOTS, true)) {
                    return null;
                }
                slot.func_75220_a(stack1, stack);
            } else if (id > FabricatorTileEntMaster.SLOT_UPGRADE && id < MAXSLOTS) {
                int validslot = this.tile.getValidSlotForItemInMachine(stack1);
                if (validslot >= 0) {
                    if (!this.func_75135_a(stack1, validslot, validslot + 1, false)) {
                        return null;
                    }
                    slot.func_75220_a(stack1, stack);
                } else {
                    return null;
                }
            }
            if (stack1.field_77994_a == 0) {
                slot.func_75215_d((ItemStack)null);
            } else {
                slot.func_75218_e();
            }
            if (stack1.field_77994_a == stack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(ply, stack1);
        }
        return stack;
    }
}

