/*
 * Decompiled with CFR 0.152.
 */
package techguns.extendedproperties;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import techguns.TGConfig;
import techguns.gui.playerinventory.TGPlayerInventory;

public class TechgunsExtendedPlayerProperties
implements IExtendedEntityProperties {
    public static final String EXT_PROP_NAME = "TechgunsExtendedPlayer";
    private static final int NUMSLOTS = 12;
    protected final EntityPlayer player;
    public static int DATA_WATCHER_ID_FACESLOT = TGConfig.dataWatcherID_FaceSlot;
    public static int DATA_WATCHER_ID_BACKSLOT = TGConfig.dataWatcherID_BackSlot;
    public int radlevel = 0;
    public final TGPlayerInventory TG_inventory;
    public int foodleft = 0;
    public float lastSaturation = 1.0f;
    public boolean enableNightVision = false;
    public boolean enableSafemode = true;
    public boolean gotCreativeFlightLastTick = false;
    public boolean wasFlying = false;
    public boolean enableHovermode = false;
    public boolean enableStepAssist = true;
    public boolean showTGHudElements = true;
    public boolean enableJetpack = true;
    protected boolean isJumpkeyPressed = false;
    public boolean isForwardKeyPressed = false;
    public int fireDelay = 0;
    public int loopSoundDelay = 0;
    public boolean isGliding = false;
    public byte swingSoundDelay = 0;

    public TechgunsExtendedPlayerProperties(EntityPlayer player) {
        this.player = player;
        this.TG_inventory = new TGPlayerInventory(player);
        this.player.func_70096_w().func_82709_a(DATA_WATCHER_ID_FACESLOT, 5);
        this.player.func_70096_w().func_82709_a(DATA_WATCHER_ID_BACKSLOT, 5);
    }

    public static TechgunsExtendedPlayerProperties register(EntityPlayer ply) {
        TechgunsExtendedPlayerProperties props = new TechgunsExtendedPlayerProperties(ply);
        ply.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)props);
        return props;
    }

    public static final TechgunsExtendedPlayerProperties get(EntityPlayer ply) {
        return (TechgunsExtendedPlayerProperties)ply.getExtendedProperties(EXT_PROP_NAME);
    }

    public void saveNBTData(NBTTagCompound tags) {
        this.TG_inventory.saveNBTData(tags);
        tags.func_74768_a("radlevel", this.radlevel);
        tags.func_74777_a("foodLeft", (short)this.foodleft);
        tags.func_74776_a("lastSaturation", this.lastSaturation);
        tags.func_74757_a("enableNightvision", this.enableNightVision);
        tags.func_74757_a("enableSafemode", this.enableSafemode);
        tags.func_74757_a("enableHovermode", this.enableHovermode);
        tags.func_74757_a("enableJetpack", this.enableJetpack);
        tags.func_74757_a("showHud", this.showTGHudElements);
        tags.func_74757_a("stepAssist", this.enableStepAssist);
    }

    public void loadNBTData(NBTTagCompound tags) {
        this.TG_inventory.loadNBTData(tags);
        this.radlevel = tags.func_74762_e("radlevel");
        this.foodleft = tags.func_74762_e("foodLeft");
        this.lastSaturation = tags.func_74760_g("lastSaturation");
        this.enableNightVision = tags.func_74767_n("enableNightvision");
        this.enableSafemode = tags.func_74767_n("enableSafemode");
        this.enableHovermode = tags.func_74767_n("enableHovermode");
        this.enableJetpack = tags.func_74767_n("enableJetpack");
        if (!this.enableSafemode && !TGConfig.allowUnsafemode(this.player)) {
            this.enableSafemode = true;
        }
        this.showTGHudElements = tags.func_74767_n("showHud");
        this.enableStepAssist = tags.func_74767_n("stepAssist");
    }

    public void init(Entity entity, World world) {
    }

    public void dropInventory() {
        if (!this.player.field_70170_p.field_72995_K && !this.player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            this.player.captureDrops = true;
            for (int i = 0; i < this.TG_inventory.inventory.length; ++i) {
                if (this.TG_inventory.inventory[i] == null) continue;
                this.player.func_146097_a(this.TG_inventory.inventory[i], true, false);
                this.TG_inventory.inventory[i] = null;
            }
            this.player.captureDrops = false;
        }
    }

    public boolean isJumpkeyPressed() {
        return this.isJumpkeyPressed;
    }

    public void setJumpkeyPressed(boolean isJumpkeyPressed) {
        this.isJumpkeyPressed = isJumpkeyPressed;
    }
}

