/*
 * Decompiled with CFR 0.152.
 */
package techguns.events;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.ChunkEvent;
import techguns.TGArmorBonus;
import techguns.TGConfig;
import techguns.TGItems;
import techguns.TGPackets;
import techguns.Techguns;
import techguns.client.ClientProxy;
import techguns.client.renderer.additionalslots.RenderAdditionalSlotItem;
import techguns.client.renderer.death.RendererDeadLivingEntity;
import techguns.damagesystem.DamageSystem;
import techguns.damagesystem.INpcTGDamageSystem;
import techguns.damagesystem.IToolTGDamageSystem;
import techguns.damagesystem.TGDamageSource;
import techguns.entities.npc.GenericNPC;
import techguns.entities.npc.INPCTechgunsShooter;
import techguns.entities.npc.NPCTurret;
import techguns.entities.npc.TGDummySpawn;
import techguns.entities.spawn.TGSpawnManager;
import techguns.extendedproperties.TechgunsExtendedPlayerProperties;
import techguns.gui.playerinventory.TGGuiTabButton;
import techguns.items.armors.GenericArmor;
import techguns.items.guns.GenericGun;
import techguns.packets.PacketEntityDeathType;
import techguns.packets.PacketRequestTGPlayerSync;
import techguns.packets.PacketTGExtendedPlayerSync;
import techguns.util.EntityDeathUtils;

public class TechgunsEventhandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void handleFovEvent(FOVUpdateEvent event) {
        IAttributeInstance iattributeinstance = event.entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
        float f = 1.0f / (float)((iattributeinstance.func_111126_e() / (double)event.entity.field_71075_bZ.func_75094_b() + 1.0) / 2.0);
        event.newfov = event.fov * ClientProxy.get().player_zoom * f;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=false)
    public void onEvent(LivingEvent.LivingJumpEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer ply = (EntityPlayer)event.entity;
            float jumpbonus = GenericArmor.getArmorBonusForPlayer(ply, TGArmorBonus.JUMP, true);
            ply.field_70181_x += (double)jumpbonus;
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=false)
    public void onEvent(LivingFallEvent event) {
        if (event.entity instanceof EntityPlayer) {
            boolean consume = event.distance > 3.0f;
            EntityPlayer ply = (EntityPlayer)event.entity;
            float fallbonus = GenericArmor.getArmorBonusForPlayer(ply, TGArmorBonus.FALLDMG, consume);
            float reduction = fallbonus < 1.0f ? 1.0f - fallbonus : 0.0f;
            float freeheight = GenericArmor.getArmorBonusForPlayer(ply, TGArmorBonus.FREEHEIGHT, false);
            event.distance = freeheight < event.distance ? (event.distance -= freeheight) : 0.0f;
            event.distance *= reduction;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=false)
    public void stopGunHarvesting(PlayerEvent.BreakSpeed event) {
        GenericGun gun;
        ItemStack item = event.entityPlayer.func_71045_bC();
        if (item != null && item.func_77973_b() instanceof GenericGun && (gun = (GenericGun)item.func_77973_b()).isShootWithLeftClick()) {
            event.newSpeed = -1.0f;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=false)
    public void onEvent(PlayerEvent.BreakSpeed speed) {
        float bonus = 1.0f + GenericArmor.getArmorBonusForPlayer(speed.entityPlayer, TGArmorBonus.BREAKSPEED, true);
        float waterbonus = 1.0f;
        if (speed.entityPlayer.func_70055_a(Material.field_151586_h) || speed.entityPlayer.func_70055_a(Material.field_151587_i)) {
            waterbonus += GenericArmor.getArmorBonusForPlayer(speed.entityPlayer, TGArmorBonus.BREAKSPEED_WATER, true);
        }
        speed.newSpeed = speed.originalSpeed * bonus * waterbonus;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=false)
    public void onEvent(ChunkEvent.Unload event) {
        if (event.world.field_72995_K) {
            ClientProxy cp = ClientProxy.get();
            for (List list : event.getChunk().field_76645_j) {
                if (list == null) continue;
                for (int j = 0; j < list.size(); ++j) {
                    Object o = list.get(j);
                    if (!(o instanceof EntityLivingBase)) continue;
                    cp.removeEntityFromMaps((EntityLivingBase)o);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        NBTTagCompound tags = new NBTTagCompound();
        TechgunsExtendedPlayerProperties.get(event.original).saveNBTData(tags);
        TechgunsExtendedPlayerProperties.get(event.entityPlayer).loadNBTData(tags);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void handleEntityRenderEvent(RenderLivingEvent.Pre event) {
        ItemStack stack;
        ClientProxy cp = ClientProxy.get();
        if (cp.hasDeathType(event.entity)) {
            EntityDeathUtils.DeathType dt = cp.getEntityDeathType(event.entity);
            switch (dt) {
                case GORE: {
                    event.setCanceled(true);
                    break;
                }
                case DISMEMBER: 
                case BIO: 
                case LASER: {
                    event.setCanceled(true);
                    RendererDeadLivingEntity.doRender(event.renderer, event.entity, event.x, event.y, event.z, 0.0f, dt);
                    break;
                }
            }
            if (event.entity.field_70725_aQ == 0) {
                cp.clearEntityDeathType(event.entity);
            }
        }
        if (event.entity instanceof INPCTechgunsShooter && event.renderer instanceof RenderBiped && (stack = event.entity.func_70694_bm()) != null && stack.func_77973_b() instanceof GenericGun) {
            RenderBiped r = (RenderBiped)event.renderer;
            r.field_77071_a.field_78118_o = event.entity instanceof GenericNPC ? ((GenericNPC)event.entity).getHasAimedBowAnim() : true;
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=false)
    public void onPlayerDrops(PlayerDropsEvent event) {
        EntityPlayer ply = event.entityPlayer;
        TechgunsExtendedPlayerProperties props = TechgunsExtendedPlayerProperties.get(ply);
        if (props != null) {
            ply.captureDrops = true;
            props.dropInventory();
            ply.captureDrops = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=false)
    public void onLivingDeathEvent(LivingDeathEvent event) {
        if (event.entityLiving.field_70170_p.field_72995_K) {
            if (event.entityLiving instanceof GenericNPC || event.entityLiving instanceof NPCTurret) {
                ClientProxy cp = ClientProxy.get();
                cp.removeEntityFromMaps(event.entityLiving);
            }
        } else {
            if (event.entityLiving instanceof EntityPlayer) {
                TechgunsExtendedPlayerProperties tgplayer = TechgunsExtendedPlayerProperties.get((EntityPlayer)event.entityLiving);
                tgplayer.foodleft = 0;
                tgplayer.lastSaturation = 0.0f;
            }
            if (event.source instanceof TGDamageSource) {
                TGDamageSource tgs = (TGDamageSource)event.source;
                if (tgs.deathType != EntityDeathUtils.DeathType.DEFAULT && EntityDeathUtils.hasSpecialDeathAnim(event.entityLiving, tgs.deathType)) {
                    TGPackets.network.sendToAllAround((IMessage)new PacketEntityDeathType(event.entityLiving, tgs.deathType), new NetworkRegistry.TargetPoint(event.entityLiving.field_71093_bK, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, 100.0));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=false)
    public void onEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            ClientProxy cp = ClientProxy.get();
            cp.removeEntityFromMaps((EntityLivingBase)event.player);
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        TechgunsExtendedPlayerProperties properties;
        if (event.entity instanceof EntityPlayer && (properties = TechgunsExtendedPlayerProperties.get((EntityPlayer)event.entity)) == null) {
            TechgunsExtendedPlayerProperties techgunsExtendedPlayerProperties = Techguns.proxy.registerExtendedProperties((EntityPlayer)event.entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=false)
    public void onGuiPostInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (!Techguns.isTConstructLoaded && event.gui instanceof GuiInventory) {
            int xSize = 176;
            int ySize = 166;
            int k = (event.gui.field_146294_l - xSize) / 2;
            int l = (event.gui.field_146295_m - ySize) / 2;
            int index = 2;
            event.buttonList.add(new TGGuiTabButton(index, k - 26, l + 5, false, new ItemStack(Blocks.field_150462_ai, 1), 0));
            event.buttonList.add(new TGGuiTabButton(index, k - 26, l + 5 + 26, true, TGItems.newStack(TGItems.bullets9mm, 1), TGConfig.GUI_ID_tgplayerInventory));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=false)
    public void onRenderPlayerEventPre(RenderPlayerEvent.Pre event) {
        ItemStack backgear;
        ItemStack stack = event.entityPlayer.func_70694_bm();
        if (stack != null && stack.func_77973_b() instanceof GenericGun) {
            event.renderer.field_77108_b.field_78118_o = true;
            event.renderer.field_77111_i.field_78118_o = true;
            event.renderer.field_77109_a.field_78118_o = true;
        }
        ItemStack facegear = event.entityPlayer.func_70096_w().func_82710_f(TechgunsExtendedPlayerProperties.DATA_WATCHER_ID_FACESLOT);
        boolean showFaceslot = true;
        boolean showBackback = true;
        if (facegear != null) {
            RenderAdditionalSlotItem render;
            if (event.entityPlayer.field_71071_by.field_70460_b[3] != null && event.entityPlayer.field_71071_by.field_70460_b[3].func_77973_b() instanceof GenericArmor) {
                GenericArmor armor = (GenericArmor)event.entityPlayer.field_71071_by.field_70460_b[3].func_77973_b();
                boolean bl = showFaceslot = !armor.isHideFaceslot();
            }
            if ((render = RenderAdditionalSlotItem.getRenderForItem(facegear)) != null) {
                render.render(facegear, event.entityPlayer, event.renderer, event.partialRenderTick, showFaceslot);
            }
        }
        if ((backgear = event.entityPlayer.func_70096_w().func_82710_f(TechgunsExtendedPlayerProperties.DATA_WATCHER_ID_BACKSLOT)) != null) {
            RenderAdditionalSlotItem render;
            if (event.entityPlayer.field_71071_by.field_70460_b[2] != null && event.entityPlayer.field_71071_by.field_70460_b[2].func_77973_b() instanceof GenericArmor) {
                GenericArmor armor = (GenericArmor)event.entityPlayer.field_71071_by.field_70460_b[2].func_77973_b();
                boolean bl = showBackback = !armor.isHideBackslot();
            }
            if ((render = RenderAdditionalSlotItem.getRenderForItem(backgear)) != null) {
                render.render(backgear, event.entityPlayer, event.renderer, event.partialRenderTick, showBackback);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=false)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.entity.field_70170_p.field_72995_K) {
            if (event.entity instanceof EntityPlayer) {
                EntityPlayer ply = (EntityPlayer)event.entity;
                TechgunsExtendedPlayerProperties props = TechgunsExtendedPlayerProperties.get(ply);
                if (props != null) {
                    TGPackets.network.sendTo((IMessage)new PacketTGExtendedPlayerSync(ply, props, true), (EntityPlayerMP)ply);
                }
            } else if (event.entity instanceof TGDummySpawn) {
                TGSpawnManager.handleSpawn(event.world, event.entity);
                event.setCanceled(true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onMouseEvent(MouseEvent event) {
        ItemStack stack;
        EntityClientPlayerMP ply = Minecraft.func_71410_x().field_71439_g;
        if (event.button == 0 && Minecraft.func_71410_x().field_71415_G && (stack = ply.func_71045_bC()) != null && stack.func_77973_b() instanceof GenericGun) {
            long diff;
            ClientProxy cp = ClientProxy.get();
            if (((GenericGun)stack.func_77973_b()).isShootWithLeftClick()) {
                cp.keyFirePressed = event.buttonstate;
                event.setCanceled(true);
            } else if (cp.getplayerReloadtime((EntityLivingBase)ClientProxy.get().getPlayerClient()) > 0L && (diff = cp.getplayerReloadtime((EntityLivingBase)ClientProxy.get().getPlayerClient()) - System.currentTimeMillis()) > 0L && event.buttonstate) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void OnLivingAttack(LivingAttackEvent event) {
        ItemStack currentItem;
        EntityLivingBase elb = event.entityLiving;
        Object src = event.source;
        Entity attacker = src.func_76364_f();
        if (attacker instanceof EntityLivingBase && (currentItem = ((EntityLivingBase)attacker).func_71124_b(0)) != null && currentItem.func_77973_b() instanceof IToolTGDamageSystem) {
            src = ((IToolTGDamageSystem)currentItem.func_77973_b()).getDamageSource(event.source);
        }
        if (elb instanceof EntityPlayer && (src.equals(DamageSource.field_76371_c) || src.equals(DamageSource.field_76372_a) || src.equals(DamageSource.field_76370_b))) {
            EntityPlayer ply = (EntityPlayer)elb;
            if (GenericArmor.getArmorBonusForPlayer(ply, TGArmorBonus.COOLING_SYSTEM, true) >= 1.0f) {
                event.setCanceled(true);
            }
        } else if (src instanceof TGDamageSource || event.entityLiving instanceof INpcTGDamageSystem) {
            event.setCanceled(true);
            if (event.entityLiving instanceof EntityPlayer) {
                DamageSystem.onLivingAttackPlayer((EntityPlayer)event.entityLiving, src, event.ammount);
            } else {
                DamageSystem.onLivingAttackEntityLivingBase(event.entityLiving, src, event.ammount);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onStartTracking(PlayerEvent.StartTracking event) {
        if (event.entityPlayer.field_70170_p.field_72995_K) {
            TGPackets.network.sendToServer((IMessage)new PacketRequestTGPlayerSync(event.entityPlayer));
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onStopTracking(PlayerEvent.StopTracking event) {
        if (event.entityPlayer.field_70170_p.field_72995_K) {
            ClientProxy cp = ClientProxy.get();
            cp.removeEntityFromMaps((EntityLivingBase)event.entityPlayer);
            TechgunsExtendedPlayerProperties props = TechgunsExtendedPlayerProperties.get(event.entityPlayer);
            if (props != null) {
                props.setJumpkeyPressed(false);
                props.isGliding = false;
            }
        }
    }
}

